/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.marketdata.view;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.marketcetera.core.BigDecimalUtil;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.event.Event;
import org.marketcetera.event.LogEvent;
import org.marketcetera.marketdata.AssetClass;
import org.marketcetera.marketdata.Content;
import org.marketcetera.marketdata.MarketDataListener;
import org.marketcetera.marketdata.MarketDataRequest;
import org.marketcetera.marketdata.MarketDataRequestBuilder;
import org.marketcetera.trade.Factory;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.OrderSingleSuggestion;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.trade.Side;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.events.NotificationEvent;
import org.marketcetera.ui.marketdata.event.MarketDataDetailEvent;
import org.marketcetera.ui.marketdata.service.MarketDataClientService;
import org.marketcetera.ui.marketdata.view.MarketDataItem;
import org.marketcetera.ui.service.trade.TradeClientService;
import org.marketcetera.ui.trade.event.SuggestionEvent;
import org.marketcetera.ui.view.AbstractContentView;
import org.marketcetera.ui.view.ContentView;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.nocrala.tools.texttablefmt.BorderStyle;
import org.nocrala.tools.texttablefmt.ShownBorders;
import org.nocrala.tools.texttablefmt.Table;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class MarketDataListView
extends AbstractContentView
implements ContentView {
    private static final String ALL_PROVIDERS = "<all providers>";
    private ContextMenu marketDataContextMenu;
    private MenuItem removeMarketDataMenuItem;
    private MenuItem copyMarketDataMenuItem;
    private MenuItem buyMarketDataMenuItem;
    private MenuItem sellMarketDataMenuItem;
    private MenuItem viewDetailMarketDataMenuItem;
    private final Map<String, String> symbolsByRequestId = Maps.newHashMap();
    private TableView<MarketDataItem> marketDataTable;
    private MarketDataClientService marketDataClient;
    private TradeClientService tradeClient;
    private VBox rootLayout;
    private final String symbolsKey = "SYMBOLS";
    private HBox addSymbolLayout;
    private ComboBox<String> providerComboBox;
    private TextField addSymbolTextField;
    private Button addSymbolButton;
    private TableColumn<MarketDataItem, String> symbolColumn;
    private TableColumn<MarketDataItem, String> providerColumn;
    private TableColumn<MarketDataItem, String> tradeExchangeColumn;
    private TableColumn<MarketDataItem, BigDecimal> execPriceColumn;
    private TableColumn<MarketDataItem, BigDecimal> lastQtyColumn;
    private TableColumn<MarketDataItem, BigDecimal> bidQtyColumn;
    private TableColumn<MarketDataItem, BigDecimal> bidPriceColumn;
    private TableColumn<MarketDataItem, BigDecimal> askQtyColumn;
    private TableColumn<MarketDataItem, BigDecimal> askPriceColumn;
    private TableColumn<MarketDataItem, BigDecimal> prevCloseColumn;
    private TableColumn<MarketDataItem, BigDecimal> openPriceColumn;
    private TableColumn<MarketDataItem, BigDecimal> highPriceColumn;
    private TableColumn<MarketDataItem, BigDecimal> lowPriceColumn;
    private TableColumn<MarketDataItem, BigDecimal> closePriceColumn;
    private TableColumn<MarketDataItem, BigDecimal> volumeColumn;
    private static final String NAME = "Market Data List View";

    @Override
    public Region getMainLayout() {
        return this.rootLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClose() {
        try {
            Map<String, String> map = this.symbolsByRequestId;
            synchronized (map) {
                this.updateViewProperties();
                for (String requestId : this.symbolsByRequestId.keySet()) {
                    this.marketDataClient.cancel(requestId);
                }
                this.symbolsByRequestId.clear();
            }
        }
        catch (Exception e) {
            SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
        }
        super.onClose();
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    protected void onStart() {
        this.marketDataClient = this.serviceManager.getService(MarketDataClientService.class);
        this.tradeClient = this.serviceManager.getService(TradeClientService.class);
        this.rootLayout = new VBox(5.0);
        this.initializeAddSymbol();
        this.initializeTable();
        this.marketDataTable.prefWidthProperty().bind((ObservableValue)this.getParentWindow().widthProperty());
        this.rootLayout.prefHeightProperty().bind((ObservableValue)this.getParentWindow().heightProperty());
        this.rootLayout.getChildren().addAll((Object[])new Node[]{this.addSymbolLayout, this.marketDataTable});
        this.rootLayout.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.addSymbolButton.fire();
                event.consume();
            }
        });
        this.restoreSymbols();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onClientConnect() {
        Map<String, String> map = this.symbolsByRequestId;
        synchronized (map) {
            this.symbolsByRequestId.clear();
        }
        this.restoreSymbols();
    }

    @Override
    protected void onClientDisconnect() {
        Platform.runLater(() -> this.marketDataTable.getItems().clear());
    }

    public MarketDataListView(Region inParent, NewWindowEvent inEvent, Properties inProperties) {
        super(inParent, inEvent, inProperties);
    }

    private void restoreSymbols() {
        Properties windowProperties = this.getViewProperties();
        String symbolList = windowProperties.getProperty("SYMBOLS");
        if (symbolList != null) {
            String[] symbols;
            symbolList = symbolList.replaceAll("\\[|\\]", "");
            for (String symbol : symbols = symbolList.split(",")) {
                this.doMarketDataRequest(symbol);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateViewProperties() {
        Map<String, String> map = this.symbolsByRequestId;
        synchronized (map) {
            this.getViewProperties().setProperty("SYMBOLS", String.valueOf(this.symbolsByRequestId.values()));
        }
    }

    private void doMarketDataRequest(String inSymbol) {
        if (inSymbol == null) {
            return;
        }
        if (this.symbolsByRequestId.values().contains(inSymbol)) {
            return;
        }
        Instrument instrument = this.tradeClient.resolveSymbol(inSymbol);
        String marketDataRequestId = UUID.randomUUID().toString();
        MarketDataItem newItem = new MarketDataItem(instrument, marketDataRequestId);
        this.marketDataTable.getItems().add((Object)newItem);
        MarketDataRequestBuilder requestBuilder = MarketDataRequestBuilder.newRequest();
        if (this.providerComboBox.valueProperty().get() != null && this.providerComboBox.valueProperty().get() != ALL_PROVIDERS) {
            requestBuilder.withProvider((String)this.providerComboBox.valueProperty().get());
        }
        requestBuilder.withSymbols(inSymbol).withAssetClass(AssetClass.getFor((SecurityType)instrument.getSecurityType())).withContent(new Content[]{Content.LATEST_TICK, Content.TOP_OF_BOOK, Content.MARKET_STAT}).withRequestId(marketDataRequestId).create();
        MarketDataRowListener rowListener = new MarketDataRowListener(newItem);
        this.symbolsByRequestId.put(marketDataRequestId, inSymbol);
        MarketDataRequest request = requestBuilder.create();
        SLF4JLoggerProxy.debug((Object)this, (String)"Submitting {}", (Object[])new Object[]{request});
        this.marketDataClient.request(request, rowListener);
        this.updateViewProperties();
    }

    private void initializeAddSymbol() {
        this.addSymbolLayout = new HBox(5.0);
        this.addSymbolLayout.setPadding(new Insets(10.0, 30.0, 10.0, 10.0));
        this.addSymbolTextField = new TextField();
        this.addSymbolButton = new Button();
        this.addSymbolButton.setGraphic((Node)new ImageView(PhotonServices.getIcon("images/add.png")));
        this.addSymbolButton.setDisable(true);
        this.addSymbolTextField.textProperty().addListener((observableValue, oldValue, newValue) -> this.addSymbolButton.setDisable((newValue = this.tradeClient.getTreatedSymbol((String)newValue)) == null));
        this.addSymbolButton.setOnAction(event -> {
            String symbol = this.tradeClient.getTreatedSymbol(this.addSymbolTextField.getText());
            this.addSymbolTextField.setText(null);
            this.doMarketDataRequest(symbol);
        });
        this.addSymbolLayout.setAlignment(Pos.CENTER_RIGHT);
        this.providerComboBox = new ComboBox();
        this.providerComboBox.getItems().add((Object)ALL_PROVIDERS);
        this.providerComboBox.getItems().addAll(this.marketDataClient.getProviders());
        this.addSymbolLayout.getChildren().addAll((Object[])new Node[]{this.providerComboBox, this.addSymbolTextField, this.addSymbolButton});
    }

    private void initializeTable() {
        this.marketDataTable = new TableView();
        this.marketDataTable.setPlaceholder((Node)new Label("no market data selected"));
        this.initializeColumns();
        this.initializeContextMenu();
        this.marketDataTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
    }

    private void initializeColumns() {
        this.symbolColumn = new TableColumn("Symbol");
        this.symbolColumn.setCellValueFactory((Callback)new PropertyValueFactory("symbol"));
        this.providerColumn = new TableColumn("Provider");
        this.providerColumn.setCellValueFactory((Callback)new PropertyValueFactory("provider"));
        this.tradeExchangeColumn = new TableColumn("LastMkt");
        this.tradeExchangeColumn.setCellValueFactory((Callback)new PropertyValueFactory("tradeExchange"));
        this.execPriceColumn = new TableColumn("ExecPrice");
        this.execPriceColumn.setCellValueFactory((Callback)new PropertyValueFactory("lastPrice"));
        this.execPriceColumn.setCellFactory(tableColumn -> PhotonServices.renderCurrencyCell(tableColumn));
        this.lastQtyColumn = new TableColumn("LastQty");
        this.lastQtyColumn.setCellValueFactory((Callback)new PropertyValueFactory("lastQuantity"));
        this.lastQtyColumn.setCellFactory(tableColumn -> PhotonServices.renderNumberCell(tableColumn));
        this.bidQtyColumn = new TableColumn("BidQty");
        this.bidQtyColumn.setCellValueFactory((Callback)new PropertyValueFactory("bidQuantity"));
        this.bidQtyColumn.setCellFactory(tableColumn -> PhotonServices.renderNumberCell(tableColumn));
        this.bidPriceColumn = new TableColumn("BidPx");
        this.bidPriceColumn.setCellValueFactory((Callback)new PropertyValueFactory("bidPrice"));
        this.bidPriceColumn.setCellFactory(tableColumn -> PhotonServices.renderCurrencyCell(tableColumn));
        this.askQtyColumn = new TableColumn("AskQty");
        this.askQtyColumn.setCellValueFactory((Callback)new PropertyValueFactory("askQuantity"));
        this.askQtyColumn.setCellFactory(tableColumn -> PhotonServices.renderNumberCell(tableColumn));
        this.askPriceColumn = new TableColumn("AskPx");
        this.askPriceColumn.setCellValueFactory((Callback)new PropertyValueFactory("askPrice"));
        this.askPriceColumn.setCellFactory(tableColumn -> PhotonServices.renderCurrencyCell(tableColumn));
        this.prevCloseColumn = new TableColumn("PrevClose");
        this.prevCloseColumn.setCellValueFactory((Callback)new PropertyValueFactory("previousClosePrice"));
        this.prevCloseColumn.setCellFactory(tableColumn -> PhotonServices.renderCurrencyCell(tableColumn));
        this.openPriceColumn = new TableColumn("Open");
        this.openPriceColumn.setCellValueFactory((Callback)new PropertyValueFactory("openPrice"));
        this.openPriceColumn.setCellFactory(tableColumn -> PhotonServices.renderCurrencyCell(tableColumn));
        this.highPriceColumn = new TableColumn("High");
        this.highPriceColumn.setCellValueFactory((Callback)new PropertyValueFactory("highPrice"));
        this.highPriceColumn.setCellFactory(tableColumn -> PhotonServices.renderCurrencyCell(tableColumn));
        this.lowPriceColumn = new TableColumn("Low");
        this.lowPriceColumn.setCellValueFactory((Callback)new PropertyValueFactory("lowPrice"));
        this.lowPriceColumn.setCellFactory(tableColumn -> PhotonServices.renderCurrencyCell(tableColumn));
        this.closePriceColumn = new TableColumn("Close");
        this.closePriceColumn.setCellValueFactory((Callback)new PropertyValueFactory("closePrice"));
        this.closePriceColumn.setCellFactory(tableColumn -> PhotonServices.renderCurrencyCell(tableColumn));
        this.volumeColumn = new TableColumn("Volume");
        this.volumeColumn.setCellValueFactory((Callback)new PropertyValueFactory("tradeVolume"));
        this.volumeColumn.setCellFactory(tableColumn -> PhotonServices.renderNumberCell(tableColumn));
        this.marketDataTable.getColumns().add(this.symbolColumn);
        this.marketDataTable.getColumns().add(this.providerColumn);
        this.marketDataTable.getColumns().add(this.tradeExchangeColumn);
        this.marketDataTable.getColumns().add(this.execPriceColumn);
        this.marketDataTable.getColumns().add(this.lastQtyColumn);
        this.marketDataTable.getColumns().add(this.bidQtyColumn);
        this.marketDataTable.getColumns().add(this.bidPriceColumn);
        this.marketDataTable.getColumns().add(this.askPriceColumn);
        this.marketDataTable.getColumns().add(this.askQtyColumn);
        this.marketDataTable.getColumns().add(this.prevCloseColumn);
        this.marketDataTable.getColumns().add(this.openPriceColumn);
        this.marketDataTable.getColumns().add(this.highPriceColumn);
        this.marketDataTable.getColumns().add(this.lowPriceColumn);
        this.marketDataTable.getColumns().add(this.closePriceColumn);
        this.marketDataTable.getColumns().add(this.volumeColumn);
    }

    private void initializeContextMenu() {
        this.removeMarketDataMenuItem = new MenuItem("Remove");
        this.removeMarketDataMenuItem.setOnAction(event -> {
            MarketDataItem marketDataItem = (MarketDataItem)this.marketDataTable.getSelectionModel().getSelectedItem();
            if (marketDataItem == null) {
                return;
            }
            try {
                this.marketDataClient.cancel((String)marketDataItem.marketDataRequestIdProperty().get());
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
            }
            Map<String, String> map = this.symbolsByRequestId;
            synchronized (map) {
                this.symbolsByRequestId.remove(marketDataItem.marketDataRequestIdProperty().get());
            }
            this.marketDataTable.getItems().remove((Object)marketDataItem);
            this.updateViewProperties();
        });
        this.copyMarketDataMenuItem = new MenuItem("Copy");
        this.copyMarketDataMenuItem.setOnAction(event -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent clipboardContent = new ClipboardContent();
            MarketDataItem marketDataItem = (MarketDataItem)this.marketDataTable.getSelectionModel().getSelectedItem();
            if (marketDataItem == null) {
                return;
            }
            String output = this.renderMarketDataItem(marketDataItem);
            clipboardContent.putString(output);
            clipboard.setContent((Map)clipboardContent);
        });
        this.buyMarketDataMenuItem = new MenuItem("Buy");
        this.buyMarketDataMenuItem.setOnAction(event -> {
            MarketDataItem selectedItem = (MarketDataItem)this.marketDataTable.getSelectionModel().getSelectedItem();
            this.buyOrSellAction(selectedItem, Side.Buy, (BigDecimal)selectedItem.askPriceProperty().get());
        });
        this.sellMarketDataMenuItem = new MenuItem("Sell");
        this.sellMarketDataMenuItem.setOnAction(event -> {
            MarketDataItem selectedItem = (MarketDataItem)this.marketDataTable.getSelectionModel().getSelectedItem();
            this.buyOrSellAction(selectedItem, Side.Sell, (BigDecimal)selectedItem.bidPriceProperty().get());
        });
        this.viewDetailMarketDataMenuItem = new MenuItem("View Detail");
        this.viewDetailMarketDataMenuItem.setOnAction(event -> {
            MarketDataItem selectedItem = (MarketDataItem)this.marketDataTable.getSelectionModel().getSelectedItem();
            if (selectedItem == null) {
                return;
            }
            MarketDataDetailEvent viewFixMessageDetailsEvent = (MarketDataDetailEvent)this.applicationContext.getBean(MarketDataDetailEvent.class, new Object[]{selectedItem.getInstrument().getFullSymbol(), selectedItem.getInstrument()});
            this.uiMessageService.post(viewFixMessageDetailsEvent);
        });
        this.marketDataContextMenu = new ContextMenu();
        this.marketDataContextMenu.getItems().addAll((Object[])new MenuItem[]{this.removeMarketDataMenuItem, this.copyMarketDataMenuItem, this.buyMarketDataMenuItem, this.sellMarketDataMenuItem, this.viewDetailMarketDataMenuItem});
        this.marketDataTable.setContextMenu(this.marketDataContextMenu);
    }

    private void buyOrSellAction(MarketDataItem inSelectedItem, Side inSide, BigDecimal inPrice) {
        if (inSelectedItem == null) {
            return;
        }
        OrderSingle orderSingle = Factory.getInstance().createOrderSingle();
        orderSingle.setInstrument(inSelectedItem.getInstrument());
        orderSingle.setOrderType(OrderType.Limit);
        orderSingle.setPrice(inPrice);
        orderSingle.setSide(inSide);
        OrderSingleSuggestion suggestion = Factory.getInstance().createOrderSingleSuggestion();
        suggestion.setIdentifier("Market Data List View Action");
        suggestion.setScore(BigDecimal.ONE);
        suggestion.setOrder(orderSingle);
        this.uiMessageService.post(this.applicationContext.getBean(SuggestionEvent.class, new Object[]{inSide.name() + " " + (String)inSelectedItem.symbolProperty().get(), suggestion}));
    }

    private String renderMarketDataItem(MarketDataItem inMarketDataItem) {
        Table table = new Table(15, BorderStyle.CLASSIC_COMPATIBLE_WIDE, ShownBorders.ALL, false);
        table.addCell("Symbol", PlatformServices.cellStyleCenterAlign);
        table.addCell("Provider", PlatformServices.cellStyleCenterAlign);
        table.addCell("LastMk", PlatformServices.cellStyleCenterAlign);
        table.addCell("LastPrice", PlatformServices.cellStyleCenterAlign);
        table.addCell("LastQty", PlatformServices.cellStyleCenterAlign);
        table.addCell("BidQty", PlatformServices.cellStyleCenterAlign);
        table.addCell("BidPx", PlatformServices.cellStyleCenterAlign);
        table.addCell("AskPx", PlatformServices.cellStyleCenterAlign);
        table.addCell("AskQty", PlatformServices.cellStyleCenterAlign);
        table.addCell("PrevClose", PlatformServices.cellStyleCenterAlign);
        table.addCell("Open", PlatformServices.cellStyleCenterAlign);
        table.addCell("High", PlatformServices.cellStyleCenterAlign);
        table.addCell("Low", PlatformServices.cellStyleCenterAlign);
        table.addCell("Close", PlatformServices.cellStyleCenterAlign);
        table.addCell("Volume", PlatformServices.cellStyleCenterAlign);
        table.addCell((String)inMarketDataItem.symbolProperty().get(), PlatformServices.cellStyleLeftAlign);
        table.addCell((String)inMarketDataItem.providerProperty().get(), PlatformServices.cellStyleLeftAlign);
        table.addCell((String)inMarketDataItem.tradeExchangeProperty().get(), PlatformServices.cellStyleLeftAlign);
        table.addCell(BigDecimalUtil.renderCurrency((BigDecimal)((BigDecimal)inMarketDataItem.lastPriceProperty().get())), PlatformServices.cellStyleRightAlign);
        table.addCell(BigDecimalUtil.render((BigDecimal)((BigDecimal)inMarketDataItem.lastQuantityProperty().get())), PlatformServices.cellStyleRightAlign);
        table.addCell(BigDecimalUtil.render((BigDecimal)((BigDecimal)inMarketDataItem.bidQuantityProperty().get())), PlatformServices.cellStyleRightAlign);
        table.addCell(BigDecimalUtil.renderCurrency((BigDecimal)((BigDecimal)inMarketDataItem.bidPriceProperty().get())), PlatformServices.cellStyleRightAlign);
        table.addCell(BigDecimalUtil.renderCurrency((BigDecimal)((BigDecimal)inMarketDataItem.askPriceProperty().get())), PlatformServices.cellStyleRightAlign);
        table.addCell(BigDecimalUtil.render((BigDecimal)((BigDecimal)inMarketDataItem.askQuantityProperty().get())), PlatformServices.cellStyleRightAlign);
        table.addCell(BigDecimalUtil.renderCurrency((BigDecimal)((BigDecimal)inMarketDataItem.previousClosePriceProperty().get())), PlatformServices.cellStyleRightAlign);
        table.addCell(BigDecimalUtil.renderCurrency((BigDecimal)((BigDecimal)inMarketDataItem.openPriceProperty().get())), PlatformServices.cellStyleRightAlign);
        table.addCell(BigDecimalUtil.renderCurrency((BigDecimal)((BigDecimal)inMarketDataItem.highPriceProperty().get())), PlatformServices.cellStyleRightAlign);
        table.addCell(BigDecimalUtil.renderCurrency((BigDecimal)((BigDecimal)inMarketDataItem.lowPriceProperty().get())), PlatformServices.cellStyleRightAlign);
        table.addCell(BigDecimalUtil.renderCurrency((BigDecimal)((BigDecimal)inMarketDataItem.closePriceProperty().get())), PlatformServices.cellStyleRightAlign);
        table.addCell(BigDecimalUtil.render((BigDecimal)((BigDecimal)inMarketDataItem.tradeVolumeProperty().get())), PlatformServices.cellStyleRightAlign);
        return table.render();
    }

    private class MarketDataRowListener
    implements MarketDataListener {
        private final MarketDataItem marketDataItem;

        public void receiveMarketData(Event inEvent) {
            if (inEvent instanceof LogEvent) {
                Alert.AlertType alertType;
                LogEvent logEvent = (LogEvent)inEvent;
                switch (logEvent.getLevel()) {
                    case INFO: 
                    case DEBUG: {
                        alertType = Alert.AlertType.INFORMATION;
                        break;
                    }
                    case ERROR: {
                        alertType = Alert.AlertType.ERROR;
                        break;
                    }
                    case WARN: {
                        alertType = Alert.AlertType.WARNING;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected log level: " + logEvent.getLevel());
                    }
                }
                MarketDataListView.this.uiMessageService.post(new NotificationEvent("Market Data Request Failed", logEvent.getMessage(), alertType));
            } else {
                Platform.runLater(() -> this.marketDataItem.update(inEvent));
            }
        }

        private MarketDataRowListener(MarketDataItem inMarketDataItem) {
            this.marketDataItem = inMarketDataItem;
        }
    }
}

