/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.marketdata.view;

import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.marketcetera.core.Pair;
import org.marketcetera.marketdata.MarketDataPermissions;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.marketdata.view.MarketDataContentCategory;
import org.marketcetera.ui.marketdata.view.MarketDataListView;
import org.marketcetera.ui.view.AbstractContentViewFactory;
import org.marketcetera.ui.view.ContentView;
import org.marketcetera.ui.view.ContentViewFactory;
import org.marketcetera.ui.view.MenuContent;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class MarketDataListViewFactory
extends AbstractContentViewFactory
implements MenuContent {
    private static final Set<GrantedAuthority> requiredPermissions = Collections.unmodifiableSet(Sets.newHashSet((Object[])new MarketDataPermissions[]{MarketDataPermissions.RequestMarketDataAction}));

    @Override
    public String getMenuCaption() {
        return "Symbol List";
    }

    @Override
    public int getWeight() {
        return 100;
    }

    @Override
    public URL getMenuIcon() {
        return this.getClass().getClassLoader().getResource("images/server.svg");
    }

    @Override
    public MenuContent getCategory() {
        return MarketDataContentCategory.instance;
    }

    @Override
    public Runnable getCommand() {
        return new Runnable(){

            @Override
            public void run() {
                MarketDataListViewFactory.this.webMessageService.post(new NewWindowEvent(){

                    @Override
                    public Pair<Double, Double> getWindowSize() {
                        return Pair.create((Object)900.0, (Object)300.0);
                    }

                    @Override
                    public String getWindowTitle() {
                        return MarketDataListViewFactory.this.getMenuCaption();
                    }

                    @Override
                    public Class<? extends ContentViewFactory> getViewFactoryType() {
                        return MarketDataListViewFactory.class;
                    }
                });
            }
        };
    }

    @Override
    public Set<GrantedAuthority> getAllPermissions() {
        return requiredPermissions;
    }

    @Override
    protected Class<? extends ContentView> getViewType() {
        return MarketDataListView.class;
    }
}

