/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.service;

import javafx.stage.Stage;

public class DesktopParameters {
    private final Stage mainStage;
    private double top = 0.0;
    private double left = 0.0;
    private double bottom;
    private double right;

    public DesktopParameters(Stage inMainStage) {
        this.mainStage = inMainStage;
        this.mainStage.widthProperty().addListener((inObservable, inOldValue, inNewValue) -> this.recalculate());
        this.mainStage.heightProperty().addListener((inObservable, inOldValue, inNewValue) -> this.recalculate());
        this.mainStage.xProperty().addListener((inObservable, inOldValue, inNewValue) -> this.recalculate());
        this.mainStage.yProperty().addListener((inObservable, inOldValue, inNewValue) -> this.recalculate());
    }

    public double getTop() {
        return this.top;
    }

    public void setTop(double doubleop) {
        this.top = doubleop;
    }

    public double getLeft() {
        return this.left;
    }

    public void setLeft(double inLeft) {
        this.left = inLeft;
    }

    public double getBottom() {
        return this.bottom;
    }

    public void setBottom(double inBottom) {
        this.bottom = inBottom;
    }

    public double getRight() {
        return this.right;
    }

    public void setRight(double inRight) {
        this.right = inRight;
    }

    public void recalculate() {
        this.top = this.mainStage.getY();
        this.left = this.mainStage.getX();
        this.bottom = this.mainStage.getY() + this.mainStage.getHeight();
        this.right = this.mainStage.getX() + this.mainStage.getWidth();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DesktopParameters [top=").append(this.top).append(", left=").append(this.left).append(", bottom=").append(this.bottom).append(", right=").append(this.right).append("]");
        return builder.toString();
    }
}

