/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.service;

import com.google.common.collect.Sets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;

public class SessionUser {
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Set<GrantedAuthority> permissions = Sets.newHashSet();
    private static SessionUser currentUser;
    private final String username;
    private final String password;
    private final Date loggedIn = new Date();

    public static SessionUser getCurrent() {
        return currentUser;
    }

    public SessionUser(String inUsername, String inPassword) {
        currentUser = this;
        this.username = inUsername;
        this.password = inPassword;
    }

    public String getUsername() {
        return this.username;
    }

    public Date getLoggedIn() {
        return this.loggedIn;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return this.username;
    }

    public Set<GrantedAuthority> getPermissions() {
        return this.permissions;
    }

    public <T> T getAttribute(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("type can not be null");
        }
        Object value = this.getAttribute(type.getName());
        if (value == null) {
            return null;
        }
        return type.cast(value);
    }

    public Object getAttribute(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        return this.attributes.get(name);
    }

    public <T> void setAttribute(Class<T> type, T value) {
        if (type == null) {
            throw new IllegalArgumentException("type can not be null");
        }
        if (value != null && !type.isInstance(value)) {
            throw new IllegalArgumentException("value of type " + type.getName() + " expected but got " + value.getClass().getName());
        }
        this.setAttribute(type.getName(), value);
    }

    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.attributes.remove(name);
        }
    }
}

