/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.service;

import com.google.common.collect.Maps;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.annotation.PostConstruct;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.ui.view.ContentView;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class StyleService {
    @Value(value="#{${metc.styles}}")
    private Map<String, String> styleProperties = Maps.newHashMap();

    @PostConstruct
    public void start() {
        SLF4JLoggerProxy.info((Object)this, (String)"Starting {}", (Object[])new Object[]{PlatformServices.getServiceName(this.getClass())});
    }

    public void addStyle(ContentView inContentView) {
    }

    public void addStyle(Scene inScene) {
        Parent root = inScene.getRoot();
        for (Node node : root.getChildrenUnmodifiable()) {
            this.addStyle(node);
        }
    }

    public void addStyleToAll(Node ... inNodes) {
        for (Node node : inNodes) {
            this.addStyle(node);
        }
    }

    public void addStyle(Node inComponent) {
    }

    private void applyStyle(int inIndex, String inKey, Node inComponent) {
        if (inKey == null) {
            return;
        }
        String key = inIndex == -1 ? inKey : inKey.substring(0, inIndex);
        String stylesToApply = this.styleProperties.get(key);
        SLF4JLoggerProxy.trace((Object)this, (String)"Applying styles {} to {} from key {}", (Object[])new Object[]{stylesToApply, inComponent.getId(), key});
        if (stylesToApply != null) {
            inComponent.setStyle(stylesToApply);
        }
        if (inKey.equals(key)) {
            return;
        }
        int indexOfDot = inKey.indexOf(46, inIndex + 1);
        this.applyStyle(indexOfDot, inKey, inComponent);
    }
}

