/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.service;

import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.marketcetera.core.Pair;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.core.Util;
import org.marketcetera.ui.DragResizeMod;
import org.marketcetera.ui.PhotonApp;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.CascadeWindowsEvent;
import org.marketcetera.ui.events.CloseWindowsEvent;
import org.marketcetera.ui.events.LoginEvent;
import org.marketcetera.ui.events.LogoutEvent;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.events.TileWindowsEvent;
import org.marketcetera.ui.service.DisplayLayoutService;
import org.marketcetera.ui.service.SessionUser;
import org.marketcetera.ui.service.UiMessageService;
import org.marketcetera.ui.view.ContentView;
import org.marketcetera.ui.view.ContentViewFactory;
import org.marketcetera.ui.view.MenuContent;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class WindowManagerService {
    private static final String propId = WindowLayout.class.getSimpleName();
    public static final String windowUuidProp = propId + "_uid";
    private static final String windowContentViewFactoryProp = propId + "_contentViewFactory";
    private static final String windowTitleProp = propId + "_title";
    private static final String windowPosXProp = propId + "__posX";
    private static final String windowPosYProp = propId + "_posY";
    private static final String windowHeightProp = propId + "_height";
    private static final String windowWidthProp = propId + "_width";
    private static final String windowViewOrderProp = propId + "_viewOrder";
    private static final String windowDraggableProp = propId + "_draggable";
    private static final String windowResizableProp = propId + "_resizable";
    private static final String windowVerticalScrollProp = propId + "_scrollV";
    private static final String windowHorizontalScrollProp = propId + "_scrollH";
    private static final String workspaceLayout = propId + "_wsLayout";
    private static final String workspaceHeightProp = propId + "_wsHeight";
    private static final String workspaceWidthProp = propId + "_wsWidth";
    @Autowired
    private UiMessageService webMessageService;
    @Autowired
    private DisplayLayoutService displayLayoutService;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${metc.desktop.viewable.area.pad:2}")
    private int desktopViewableAreaPad;
    @Value(value="${metc.desktop.cascade.window.offset:100}")
    private double desktopCascadeWindowOffset;
    @Value(value="${metc.desktop.window.position.monitor.interval:250}")
    private long desktopWindowPositionMonitorInterval;
    private double newWindowAnchorX;
    private double newWindowAnchorY;

    public WindowManagerService() {
        this.newWindowAnchorX = this.desktopCascadeWindowOffset;
        this.newWindowAnchorY = this.desktopCascadeWindowOffset;
    }

    @PostConstruct
    public void start() {
        SLF4JLoggerProxy.info((Object)this, (String)"Starting {}", (Object[])new Object[]{PlatformServices.getServiceName(this.getClass())});
        this.webMessageService.register(this);
    }

    @PreDestroy
    public void stop() {
        SLF4JLoggerProxy.info((Object)this, (String)"Stopping {}", (Object[])new Object[]{PlatformServices.getServiceName(this.getClass())});
        this.webMessageService.unregister(this);
    }

    @Subscribe
    public void onLogin(LoginEvent inEvent) {
        Properties displayLayout = this.displayLayoutService.getDisplayLayout();
        SLF4JLoggerProxy.debug((Object)this, (String)"Received {}, retrieved display layout: {}", (Object[])new Object[]{inEvent, displayLayout});
        WindowRegistry windowRegistry = this.getCurrentUserRegistry();
        windowRegistry.restoreLayout(displayLayout);
        PhotonApp.getPrimaryStage().widthProperty().addListener((observableValue, oldValue, newValue) -> windowRegistry.updateDisplayLayout());
        PhotonApp.getPrimaryStage().heightProperty().addListener((observableValue, oldValue, newValue) -> windowRegistry.updateDisplayLayout());
    }

    @Subscribe
    public void onNewWindow(NewWindowEvent inEvent) {
        SLF4JLoggerProxy.debug((Object)this, (String)"onWindow: {} {}", (Object[])new Object[]{inEvent.getWindowTitle(), inEvent.getProperties()});
        ContentViewFactory viewFactory = (ContentViewFactory)this.applicationContext.getBean(inEvent.getViewFactoryType());
        WindowLayout newWindow = new WindowLayout(inEvent, viewFactory);
        if (inEvent.getWindowIcon() != null) {
            // empty if block
        }
        WindowRegistry windowRegistry = this.getCurrentUserRegistry();
        ContentView contentView = viewFactory.create(newWindow.getMainLayout(), inEvent, newWindow.getProperties());
        newWindow.setContentView(contentView);
        newWindow.setDraggable(inEvent.isDraggable());
        newWindow.setResizable(inEvent.isResizable());
        if ((Double)inEvent.getWindowSize().getFirstMember() > 0.0) {
            newWindow.setWidth((Double)inEvent.getWindowSize().getFirstMember());
        }
        if ((Double)inEvent.getWindowSize().getSecondMember() > 0.0) {
            newWindow.setHeight((Double)inEvent.getWindowSize().getSecondMember());
        }
        windowRegistry.addWindow(newWindow);
        newWindow.setRoot((Node)contentView.getMainLayout());
        windowRegistry.updateDisplayLayout();
        newWindow.show();
        windowRegistry.verifyWindowLocation(newWindow);
    }

    @Subscribe
    public void onLogout(LogoutEvent inEvent) {
        SLF4JLoggerProxy.debug((Object)this, (String)"onLogout: {}", (Object[])new Object[]{inEvent});
        if (SessionUser.getCurrent() == null) {
            return;
        }
        this.getCurrentUserRegistry().logout();
        SessionUser.getCurrent().setAttribute(WindowRegistry.class, null);
    }

    @Subscribe
    public void onCascade(CascadeWindowsEvent inEvent) {
        SLF4JLoggerProxy.trace((Object)this, (String)"onCascade: {}", (Object[])new Object[]{inEvent});
        this.getCurrentUserRegistry().cascadeWindows();
    }

    @Subscribe
    public void onTile(TileWindowsEvent inEvent) {
        SLF4JLoggerProxy.trace((Object)this, (String)"onTile: {}", (Object[])new Object[]{inEvent});
        this.getCurrentUserRegistry().tileWindows();
    }

    @Subscribe
    public void onCloseAllWindows(CloseWindowsEvent inEvent) {
        SLF4JLoggerProxy.trace((Object)this, (String)"onCloseWindows: {}", (Object[])new Object[]{inEvent});
        this.getCurrentUserRegistry().closeAllWindows(true);
    }

    private boolean isWindowOutsideDesktop(WindowLayout inWindow) {
        double windowTop = inWindow.getY();
        double windowLeft = inWindow.getX();
        double windowHeight = inWindow.getHeight();
        double windowWidth = inWindow.getWidth();
        double windowBottom = windowTop + windowHeight;
        double windowRight = windowLeft + windowWidth;
        double workspaceWidth = this.getWorkspaceWidth();
        double workspaceBottom = this.getWorkspaceBottom();
        double workspaceLeft = this.getWorkspaceLeft();
        double workspaceTop = this.getWorkspaceTop();
        double workspaceRight = workspaceWidth;
        boolean outsideDesktop = windowBottom > workspaceBottom || windowLeft < workspaceLeft || windowTop < workspaceTop || windowRight > workspaceRight;
        return outsideDesktop;
    }

    private double getWindowHeight(WindowLayout inWindow) {
        return inWindow.getHeight();
    }

    private double getWindowWidth(WindowLayout inWindow) {
        return inWindow.getWidth();
    }

    private WindowRegistry getCurrentUserRegistry() {
        WindowRegistry registry = SessionUser.getCurrent().getAttribute(WindowRegistry.class);
        if (registry == null) {
            registry = new WindowRegistry();
            SessionUser.getCurrent().setAttribute(WindowRegistry.class, registry);
        }
        return registry;
    }

    private double getWorkspaceWidth() {
        return PhotonApp.getWorkspace().getLayoutBounds().getWidth();
    }

    private double getWorkspaceHeight() {
        return PhotonApp.getWorkspace().getLayoutBounds().getHeight();
    }

    private double getWorkspaceLeft() {
        return 0.0;
    }

    private double getWorkspaceTop() {
        return 0.0;
    }

    private double getWorkspaceRight() {
        return this.getWorkspaceLeft() + this.getWorkspaceWidth();
    }

    private double getWorkspaceBottom() {
        return this.getWorkspaceTop() + this.getWorkspaceHeight();
    }

    private Properties getWorkspaceProperties() {
        Properties workspaceProperties = new Properties();
        workspaceProperties.setProperty(workspaceHeightProp, Double.toString(PhotonApp.getPrimaryStage().getHeight()));
        workspaceProperties.setProperty(workspaceWidthProp, Double.toString(PhotonApp.getPrimaryStage().getWidth()));
        return workspaceProperties;
    }

    private class WindowRegistry {
        private boolean isLoggingOut = false;
        private final Set<WindowLayout> activeWindows = Sets.newHashSet();

        private WindowRegistry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addWindow(WindowLayout inWindowMetaData) {
            Set<WindowLayout> set = this.activeWindows;
            synchronized (set) {
                this.activeWindows.add(inWindowMetaData);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeAllWindows(boolean inUpdateDisplay) {
            Set<WindowLayout> set = this.activeWindows;
            synchronized (set) {
                HashSet<WindowLayout> tempActiveWindows = new HashSet<WindowLayout>(this.activeWindows);
                for (WindowLayout window : tempActiveWindows) {
                    window.close();
                }
                if (inUpdateDisplay) {
                    this.updateDisplayLayout();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cascadeWindows() {
            Set<WindowLayout> set = this.activeWindows;
            synchronized (set) {
                double xPos = WindowManagerService.this.desktopCascadeWindowOffset;
                double yPos = WindowManagerService.this.desktopCascadeWindowOffset;
                double maxX = WindowManagerService.this.getWorkspaceRight();
                double maxY = WindowManagerService.this.getWorkspaceBottom();
                for (WindowLayout activeWindow : this.activeWindows) {
                    double proposedY;
                    double windowWidth = activeWindow.getWidth();
                    double windowHeight = activeWindow.getHeight();
                    double proposedX = xPos;
                    if (proposedX + windowWidth > maxX) {
                        proposedX = WindowManagerService.this.desktopCascadeWindowOffset;
                    }
                    if ((proposedY = yPos) + windowHeight > maxY) {
                        proposedY = WindowManagerService.this.desktopCascadeWindowOffset;
                    }
                    activeWindow.setX(proposedX);
                    activeWindow.setY(proposedY);
                    activeWindow.requestFocus();
                    xPos += WindowManagerService.this.desktopCascadeWindowOffset;
                    yPos += WindowManagerService.this.desktopCascadeWindowOffset;
                }
            }
            this.updateDisplayLayout();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tileWindows() {
            Set<WindowLayout> set = this.activeWindows;
            synchronized (set) {
                int numWindows = this.activeWindows.size();
                if (numWindows == 0) {
                    return;
                }
                int numCols = (int)Math.floor(Math.sqrt(numWindows));
                int numRows = (int)Math.floor(numWindows / numCols);
                if (!this.isPerfectSquare(numWindows)) {
                    ++numCols;
                }
                double windowWidth = Math.floorDiv(Double.valueOf(WindowManagerService.this.getWorkspaceRight()).intValue(), numCols);
                double windowHeight = Math.floorDiv(Double.valueOf(WindowManagerService.this.getWorkspaceBottom() - WindowManagerService.this.getWorkspaceTop()).intValue(), numRows);
                int colNum = 0;
                int rowNum = 0;
                double posX = WindowManagerService.this.getWorkspaceLeft();
                double posY = WindowManagerService.this.getWorkspaceTop();
                for (WindowLayout activeWindow : this.activeWindows) {
                    double suggestedX = posX + (double)colNum * windowWidth;
                    double suggestedY = posY + (double)rowNum * windowHeight;
                    activeWindow.setWidth(windowWidth);
                    activeWindow.setHeight(windowHeight);
                    activeWindow.setX(suggestedX);
                    activeWindow.setY(suggestedY);
                    if (++colNum != numCols) continue;
                    colNum = 0;
                    ++rowNum;
                }
            }
            this.updateDisplayLayout();
        }

        private boolean isPerfectSquare(double inValue) {
            double squareOfValue = Math.sqrt(inValue);
            return squareOfValue - Math.floor(squareOfValue) == 0.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restoreLayout(Properties inDisplayLayout) {
            String rawWorkspaceProperties = inDisplayLayout.getProperty(workspaceLayout);
            if (rawWorkspaceProperties != null) {
                Properties workspaceProperties = Util.propertiesFromString((String)rawWorkspaceProperties);
                Double desiredHeight = PhotonApp.getPrimaryStage().getHeight();
                Double desiredWidth = PhotonApp.getPrimaryStage().getWidth();
                String rawValue = workspaceProperties.getProperty(workspaceHeightProp);
                if (rawValue != null) {
                    desiredHeight = Double.parseDouble(rawValue);
                }
                if ((rawValue = workspaceProperties.getProperty(workspaceWidthProp)) != null) {
                    desiredWidth = Double.parseDouble(rawValue);
                }
                Double mainStageWidth = desiredWidth;
                Double mainStageHeight = desiredHeight;
                Platform.runLater(() -> {
                    PhotonApp.getPrimaryStage().setWidth(mainStageWidth.doubleValue());
                    PhotonApp.getPrimaryStage().setHeight(mainStageHeight.doubleValue());
                });
            }
            Set<WindowLayout> set = this.activeWindows;
            synchronized (set) {
                for (Map.Entry<Object, Object> entry : inDisplayLayout.entrySet()) {
                    String windowUid = String.valueOf(entry.getKey());
                    if (windowUid.equals(workspaceLayout)) continue;
                    Properties windowProperties = Util.propertiesFromString((String)String.valueOf(entry.getValue()));
                    SLF4JLoggerProxy.debug((Object)this, (String)"Restoring {} {}", (Object[])new Object[]{windowUid, windowProperties});
                    try {
                        ContentViewFactory viewFactory = (ContentViewFactory)WindowManagerService.this.applicationContext.getBean(Class.forName(windowProperties.getProperty(windowContentViewFactoryProp)));
                        RestartNewWindowEvent restartWindowEvent = new RestartNewWindowEvent(viewFactory, windowProperties);
                        WindowLayout newWindow = new WindowLayout(restartWindowEvent, viewFactory);
                        ContentView contentView = viewFactory.create(newWindow.getMainLayout(), restartWindowEvent, windowProperties);
                        newWindow.contentViewProperty.set((Object)contentView);
                        newWindow.setRoot((Node)contentView.getMainLayout());
                        this.addWindow(newWindow);
                        newWindow.show();
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            this.verifyAllWindowPositions();
        }

        private void updateDisplayLayout() {
            try {
                Properties displayLayout = this.getDisplayLayout();
                SLF4JLoggerProxy.debug((Object)this, (String)"Updating display layout for {}: {}", (Object[])new Object[]{SessionUser.getCurrent(), displayLayout});
                WindowManagerService.this.displayLayoutService.setDisplayLayout(displayLayout);
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)ExceptionUtils.getRootCauseMessage((Throwable)e), (Object[])new Object[0]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void verifyWindowLocation(WindowLayout inWindow) {
            Set<WindowLayout> set = this.activeWindows;
            synchronized (set) {
                if (WindowManagerService.this.isWindowOutsideDesktop(inWindow)) {
                    SLF4JLoggerProxy.trace((Object)WindowManagerService.this, (String)"{} is outside the desktop", (Object[])new Object[]{inWindow.getTitle()});
                    this.returnWindowToDesktop(inWindow);
                } else {
                    SLF4JLoggerProxy.trace((Object)WindowManagerService.this, (String)"{} is not outside the desktop", (Object[])new Object[]{inWindow.getTitle()});
                }
            }
        }

        private void returnWindowToDesktop(WindowLayout inWindow) {
            double newWindowLeft;
            double newWindowTop;
            double maxHeight;
            double workspaceHeight;
            double windowTop = inWindow.getY();
            double windowLeft = inWindow.getX();
            double windowHeight = inWindow.getHeight();
            double windowWidth = inWindow.getWidth();
            double windowBottom = windowTop + windowHeight;
            double windowRight = windowLeft + windowWidth;
            double workspaceWidth = WindowManagerService.this.getWorkspaceWidth();
            double workspaceBottom = workspaceHeight = WindowManagerService.this.getWorkspaceHeight();
            double workspaceLeft = WindowManagerService.this.getWorkspaceLeft();
            double workspaceTop = WindowManagerService.this.getWorkspaceTop();
            double workspaceRight = workspaceWidth;
            int pad = WindowManagerService.this.desktopViewableAreaPad;
            double maxWidth = workspaceRight;
            if (windowWidth > maxWidth) {
                inWindow.setWidth(maxWidth - (double)(pad * 2));
            }
            if (windowWidth <= 10.0) {
                windowWidth = 100.0;
                inWindow.setWidth(windowWidth);
            }
            if (windowHeight > (maxHeight = workspaceBottom)) {
                inWindow.setHeight(maxHeight - (double)(pad * 2));
            }
            if (windowBottom > workspaceBottom) {
                newWindowTop = workspaceBottom - WindowManagerService.this.getWindowHeight(inWindow) - (double)pad;
                inWindow.setY(newWindowTop);
            }
            if (windowTop < workspaceTop + (double)pad) {
                newWindowTop = workspaceTop + (double)pad;
                inWindow.setY(newWindowTop);
            }
            if (windowLeft < workspaceLeft) {
                newWindowLeft = workspaceLeft + (double)pad;
                inWindow.setX(newWindowLeft);
            }
            if (windowRight > workspaceRight) {
                newWindowLeft = workspaceRight - WindowManagerService.this.getWindowWidth(inWindow) - (double)pad;
                inWindow.setX(newWindowLeft);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeWindow(WindowLayout inWindowLayout) {
            Set<WindowLayout> set = this.activeWindows;
            synchronized (set) {
                this.activeWindows.remove(inWindowLayout);
            }
        }

        private void logout() {
            this.isLoggingOut = true;
            this.terminateRegistry();
        }

        private void terminateRegistry() {
            this.closeAllWindows(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void verifyAllWindowPositions() {
            Set<WindowLayout> set = this.activeWindows;
            synchronized (set) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        for (WindowLayout window : WindowRegistry.this.activeWindows) {
                            try {
                                if (!WindowManagerService.this.isWindowOutsideDesktop(window)) continue;
                                WindowRegistry.this.returnWindowToDesktop(window);
                            }
                            catch (Exception e) {
                                SLF4JLoggerProxy.warn((Object)WindowManagerService.this, (String)ExceptionUtils.getRootCauseMessage((Throwable)e));
                            }
                        }
                    }
                });
            }
        }

        private boolean isLoggingOut() {
            return this.isLoggingOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties getDisplayLayout() {
            Set<WindowLayout> set = this.activeWindows;
            synchronized (set) {
                Properties displayLayout = new Properties();
                for (WindowLayout activeWindow : this.activeWindows) {
                    String windowKey = activeWindow.getUuid();
                    String windowValue = activeWindow.getStorableValue();
                    displayLayout.setProperty(windowKey, windowValue);
                }
                Properties workspaceLayoutProperties = WindowManagerService.this.getWorkspaceProperties();
                displayLayout.setProperty(workspaceLayout, Util.propertiesToString((Properties)workspaceLayoutProperties));
                return displayLayout;
            }
        }
    }

    private class WindowLayout {
        private final ObjectProperty<ContentView> contentViewProperty = new SimpleObjectProperty();
        private final ObjectProperty<NewWindowEvent> newWindowEventProperty = new SimpleObjectProperty();
        private final DoubleProperty viewOrderProperty = new SimpleDoubleProperty();
        private final StringProperty uuidProperty = new SimpleStringProperty();
        private final Properties windowProperties;
        private final ObjectProperty<ContentViewFactory> viewFactoryProperty = new SimpleObjectProperty();
        private final DoubleProperty heightProperty = new SimpleDoubleProperty();
        private final DoubleProperty widthProperty = new SimpleDoubleProperty();
        private final DoubleProperty xProperty = new SimpleDoubleProperty();
        private final DoubleProperty yProperty = new SimpleDoubleProperty();
        private final BooleanProperty maximizedProperty = new SimpleBooleanProperty();
        private final BooleanProperty draggableProperty = new SimpleBooleanProperty();
        private final BooleanProperty resizableProperty = new SimpleBooleanProperty();
        private final DoubleProperty scrollVerticalProperty = new SimpleDoubleProperty();
        private final DoubleProperty scrollHorizontalProperty = new SimpleDoubleProperty();
        private final ObjectProperty<Modality> modalityProperty = new SimpleObjectProperty();
        private final StringProperty windowTitleProperty = new SimpleStringProperty();
        private final VBox windowLayout;
        private final HBox windowTitleLayout;
        private final HBox titleLayout;
        private final HBox closeButtonLayout;
        private final VBox contentLayout;
        private final Label windowTitle;
        private final Node closeImage;
        private final ScrollPane mainScrollPane;

        private WindowLayout(NewWindowEvent inEvent, ContentViewFactory inViewFactory) {
            this.newWindowEventProperty.set((Object)inEvent);
            this.viewFactoryProperty.set((Object)inViewFactory);
            this.windowProperties = inEvent.getProperties();
            this.uuidProperty.set((Object)UUID.randomUUID().toString());
            this.setWindowStaticProperties();
            this.windowLayout = new VBox();
            this.windowTitleLayout = new HBox();
            this.titleLayout = new HBox();
            this.closeButtonLayout = new HBox();
            this.contentLayout = new VBox();
            this.mainScrollPane = new ScrollPane();
            this.mainScrollPane.setContent((Node)this.contentLayout);
            this.mainScrollPane.setPannable(true);
            this.mainScrollPane.setPadding(new Insets(5.0));
            this.mainScrollPane.setFitToHeight(true);
            this.mainScrollPane.setFitToWidth(true);
            this.scrollHorizontalProperty.bind((ObservableValue)this.mainScrollPane.hvalueProperty());
            this.scrollVerticalProperty.bind((ObservableValue)this.mainScrollPane.vvalueProperty());
            this.windowLayout.getChildren().addAll((Object[])new Node[]{this.windowTitleLayout, this.mainScrollPane});
            this.windowTitleLayout.getChildren().addAll((Object[])new Node[]{this.titleLayout, this.closeButtonLayout});
            this.windowTitle = new Label();
            this.windowTitle.textProperty().bind((ObservableValue)this.windowTitleProperty);
            this.closeImage = PhotonServices.getSvgResource(this.getClass().getClassLoader().getResource("images/circle-with-cross.svg"), 1.0);
            this.titleLayout.getChildren().addAll((Object[])new Node[]{this.windowTitle});
            this.closeButtonLayout.getChildren().addAll((Object[])new Node[]{this.closeImage});
            this.windowTitleLayout.getStyleClass().add((Object)"title-bar");
            HBox.setHgrow((Node)this.windowTitleLayout, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.titleLayout, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.closeButtonLayout, (Priority)Priority.NEVER);
            this.windowTitleLayout.setAlignment(Pos.CENTER);
            this.closeButtonLayout.setAlignment(Pos.BASELINE_RIGHT);
            this.closeButtonLayout.setPrefWidth(20.0);
            this.contentLayout.setAlignment(Pos.CENTER);
            VBox.setVgrow((Node)this.contentLayout, (Priority)Priority.ALWAYS);
            DragResizeMod.makeResizable((Node)this.windowLayout, new DragResizeMod.OnDragResizeEventListener(){

                @Override
                public void onDrag(Node inNode, double inX, double inY, double inH, double inW) {
                    WindowLayout.this.setX(inX);
                    WindowLayout.this.setY(inY);
                    WindowRegistry windowRegistry = WindowManagerService.this.getCurrentUserRegistry();
                    windowRegistry.verifyWindowLocation(WindowLayout.this);
                    windowRegistry.updateDisplayLayout();
                }

                @Override
                public void onResize(Node inNode, double inX, double inY, double inH, double inW) {
                    WindowLayout.this.setHeight(inH);
                    WindowLayout.this.setWidth(inW);
                    WindowRegistry windowRegistry = WindowManagerService.this.getCurrentUserRegistry();
                    windowRegistry.verifyWindowLocation(WindowLayout.this);
                    windowRegistry.updateDisplayLayout();
                }
            });
            this.windowLayout.getStyleClass().add((Object)"view");
            PhotonServices.style((Parent)this.windowLayout);
            this.setupWindowListeners();
            Pair<Double, Double> suggestedWindowSize = inEvent.getWindowSize();
            String rawProperty = StringUtils.trimToNull((String)this.windowProperties.getProperty(windowWidthProp));
            if (rawProperty == null) {
                this.setWidth((Double)suggestedWindowSize.getFirstMember());
            } else {
                this.setWidth(Double.parseDouble(rawProperty));
            }
            rawProperty = StringUtils.trimToNull((String)this.windowProperties.getProperty(windowHeightProp));
            if (rawProperty == null) {
                this.setHeight((Double)suggestedWindowSize.getSecondMember());
            } else {
                this.setHeight(Double.parseDouble(rawProperty));
            }
            rawProperty = StringUtils.trimToNull((String)this.windowProperties.getProperty(windowPosXProp));
            if (rawProperty == null) {
                double proposedX = WindowManagerService.this.newWindowAnchorX += WindowManagerService.this.desktopCascadeWindowOffset;
                if (proposedX + this.getWidth() > WindowManagerService.this.getWorkspaceRight()) {
                    proposedX = WindowManagerService.this.newWindowAnchorX = WindowManagerService.this.desktopCascadeWindowOffset;
                }
                this.setX(proposedX);
            } else {
                this.setX(Double.parseDouble(rawProperty));
            }
            rawProperty = StringUtils.trimToNull((String)this.windowProperties.getProperty(windowPosYProp));
            if (rawProperty == null) {
                double proposedY = WindowManagerService.this.newWindowAnchorY += WindowManagerService.this.desktopCascadeWindowOffset;
                if (proposedY + this.getHeight() > WindowManagerService.this.getWorkspaceBottom()) {
                    proposedY = WindowManagerService.this.newWindowAnchorY = WindowManagerService.this.desktopCascadeWindowOffset;
                }
                this.setY(proposedY);
            } else {
                this.setY(Double.parseDouble(rawProperty));
            }
            rawProperty = StringUtils.trimToNull((String)this.windowProperties.getProperty(windowTitleProp));
            if (rawProperty == null) {
                this.setTitle(inEvent.getWindowTitle());
            } else {
                this.setTitle(rawProperty);
            }
            rawProperty = StringUtils.trimToNull((String)this.windowProperties.getProperty(windowHorizontalScrollProp));
            if (rawProperty != null) {
                this.setHorizontalScroll(Double.parseDouble(rawProperty));
            }
            if ((rawProperty = StringUtils.trimToNull((String)this.windowProperties.getProperty(windowVerticalScrollProp))) != null) {
                this.setVerticalScroll(Double.parseDouble(rawProperty));
            }
        }

        private void setupWindowListeners() {
            this.closeButtonLayout.setOnMouseClicked(event -> {
                ((ContentView)this.contentViewProperty.get()).onClose();
                this.close();
            });
            this.windowLayout.setOnMouseClicked(event -> {
                WindowRegistry windowRegistry = WindowManagerService.this.getCurrentUserRegistry();
                Set<WindowLayout> set = windowRegistry.activeWindows;
                synchronized (set) {
                    for (WindowLayout windowLayout : windowRegistry.activeWindows) {
                        windowLayout.getMainLayout().viewOrderProperty().set(0.0);
                    }
                }
                this.windowLayout.viewOrderProperty().set(-1.0);
            });
            this.xProperty.addListener((observableValue, oldValue, newValue) -> this.windowProperties.setProperty(windowPosXProp, String.valueOf(newValue)));
            this.yProperty.addListener((observableValue, oldValue, newValue) -> this.windowProperties.setProperty(windowPosYProp, String.valueOf(newValue)));
            this.heightProperty.addListener((observableValue, oldValue, newValue) -> this.windowProperties.setProperty(windowHeightProp, String.valueOf(newValue)));
            this.widthProperty.addListener((observableValue, oldValue, newValue) -> this.windowProperties.setProperty(windowWidthProp, String.valueOf(newValue)));
            this.windowTitleProperty.addListener((observableValue, oldValue, newValue) -> {
                if (newValue == null) {
                    this.windowProperties.remove(windowTitleProp);
                } else {
                    this.windowProperties.setProperty(windowTitleProp, this.getTitle());
                }
            });
            this.draggableProperty.addListener((observableValue, oldValue, newValue) -> this.windowProperties.setProperty(windowDraggableProp, String.valueOf(newValue)));
            this.resizableProperty.addListener((observableValue, oldValue, newValue) -> this.windowProperties.setProperty(windowResizableProp, String.valueOf(newValue)));
            this.scrollVerticalProperty.addListener((observableValue, oldValue, newValue) -> {
                this.windowProperties.setProperty(windowVerticalScrollProp, String.valueOf(newValue));
                WindowManagerService.this.getCurrentUserRegistry().updateDisplayLayout();
            });
            this.scrollHorizontalProperty.addListener((observableValue, oldValue, newValue) -> {
                this.windowProperties.setProperty(windowHorizontalScrollProp, String.valueOf(newValue));
                WindowManagerService.this.getCurrentUserRegistry().updateDisplayLayout();
            });
            this.viewOrderProperty.addListener((observableValue, oldValue, newValue) -> this.windowProperties.setProperty(windowViewOrderProp, String.valueOf(newValue)));
        }

        private void setViewOrder(double inViewOrder) {
            this.viewOrderProperty.set(inViewOrder);
            Platform.runLater(() -> this.windowLayout.setViewOrder(inViewOrder));
        }

        private void setContentView(ContentView inContentView) {
            this.contentViewProperty.set((Object)inContentView);
        }

        private void requestFocus() {
            Platform.runLater(() -> this.windowLayout.requestFocus());
        }

        private Properties getProperties() {
            return this.windowProperties;
        }

        private void setRoot(Node inNode) {
            this.contentLayout.getChildren().add((Object)inNode);
        }

        private void setDraggable(boolean inDraggable) {
            this.draggableProperty.set(inDraggable);
        }

        private void setHeight(double inHeight) {
            this.heightProperty.set(inHeight);
            this.windowLayout.setPrefHeight(inHeight);
            this.windowLayout.setMinHeight(inHeight);
        }

        private void setWidth(double inWidth) {
            this.widthProperty.set(inWidth);
            this.windowLayout.setPrefWidth(inWidth);
            this.windowLayout.setMinWidth(inWidth);
        }

        public void setResizable(boolean inResizable) {
            this.resizableProperty.set(inResizable);
        }

        private void setTitle(String inWindowTitle) {
            this.windowTitleProperty.set((Object)inWindowTitle);
        }

        private Node getMainLayout() {
            return this.windowLayout;
        }

        private double getX() {
            return this.xProperty.get();
        }

        private double getY() {
            return this.yProperty.get();
        }

        private double getHeight() {
            return this.heightProperty.get();
        }

        private double getWidth() {
            return this.widthProperty.get();
        }

        private boolean isMaximized() {
            return this.maximizedProperty.get();
        }

        private String getTitle() {
            return (String)this.windowTitleProperty.get();
        }

        private Modality getModality() {
            return (Modality)this.modalityProperty.get();
        }

        private boolean isDraggable() {
            return this.draggableProperty.get();
        }

        private boolean isResizable() {
            return this.resizableProperty.get();
        }

        private double getScrollLeft() {
            return this.scrollVerticalProperty.get();
        }

        private void setModality(Modality inModality) {
            this.modalityProperty.set((Object)inModality);
        }

        private void setMaximized(boolean inMaximized) {
            this.maximizedProperty.set(inMaximized);
        }

        private void setVerticalScroll(double inVerticalScrollValue) {
            Platform.runLater(() -> this.mainScrollPane.vvalueProperty().set(inVerticalScrollValue));
        }

        private void setHorizontalScroll(double inHorizontalScrollValue) {
            Platform.runLater(() -> this.mainScrollPane.hvalueProperty().set(inHorizontalScrollValue));
        }

        private void setX(double inX) {
            this.xProperty.set(inX);
            this.getMainLayout().translateXProperty().set(inX);
        }

        private void setY(double inY) {
            this.yProperty.set(inY);
            this.getMainLayout().translateYProperty().set(inY);
        }

        private void close() {
            WindowRegistry windowRegistry = WindowManagerService.this.getCurrentUserRegistry();
            if (!windowRegistry.isLoggingOut()) {
                windowRegistry.removeWindow(this);
                windowRegistry.updateDisplayLayout();
            }
            Platform.runLater(() -> PhotonApp.getWorkspace().getChildren().remove((Object)this.getMainLayout()));
        }

        private void show() {
            Platform.runLater(() -> {
                this.windowLayout.autosize();
                this.getMainLayout().translateXProperty().set(this.getX());
                this.getMainLayout().translateYProperty().set(this.getY());
                this.setViewOrder(-1.0);
                PhotonApp.getWorkspace().getChildren().add((Object)this.getMainLayout());
                this.requestFocus();
            });
        }

        private String getUuid() {
            return (String)this.uuidProperty.get();
        }

        private String getStorableValue() {
            return Util.propertiesToString((Properties)this.windowProperties);
        }

        private void setWindowStaticProperties() {
            this.windowProperties.setProperty(windowContentViewFactoryProp, ((ContentViewFactory)this.viewFactoryProperty.get()).getClass().getCanonicalName());
            this.windowProperties.setProperty(windowUuidProp, (String)this.uuidProperty.get());
        }
    }

    private class RestartNewWindowEvent
    implements NewWindowEvent {
        private final Properties properties;
        private final ContentViewFactory contentViewFactory;
        private final String windowTitle;

        @Override
        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public URL getWindowIcon() {
            if (this.contentViewFactory instanceof MenuContent) {
                return ((MenuContent)((Object)this.contentViewFactory)).getMenuIcon();
            }
            return null;
        }

        @Override
        public String getWindowTitle() {
            return this.windowTitle;
        }

        @Override
        public Class<? extends ContentViewFactory> getViewFactoryType() {
            return this.contentViewFactory.getClass();
        }

        private RestartNewWindowEvent(ContentViewFactory inContentViewFactory, Properties inProperties) {
            this.contentViewFactory = inContentViewFactory;
            this.properties = inProperties;
            this.windowTitle = this.properties.getProperty(windowTitleProp);
        }
    }
}

