/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.marketcetera.ui.service.ServerConnectionService;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.stereotype.Service;

@Service
@EnableAutoConfiguration
public class ServerConnectionServiceImpl
implements ServerConnectionService {
    @Value(value="${metc.security.use.ssl:false}")
    private boolean useSsl;
    @Value(value="${host.name}")
    private String hostname;
    @Value(value="${host.port}")
    private int port;

    @Override
    public ServerConnectionService.ServerConnectionData getConnectionData() {
        return new ServerConnectionDataImpl(this.hostname, this.port, this.useSsl);
    }

    @Override
    public void setConnectionData(ServerConnectionService.ServerConnectionData inServerConnectionData) throws IOException {
        this.hostname = inServerConnectionData.getHostname();
        this.port = inServerConnectionData.getPort();
        this.useSsl = inServerConnectionData.useSsl();
        this.updateConfigFile();
    }

    private void updateConfigFile() throws IOException {
        SLF4JLoggerProxy.info((Object)this, (String)"Updating config file with: {}:{} SSL: {}", (Object[])new Object[]{this.hostname, this.port, this.useSsl});
        File configFile = new File("conf/application.properties");
        StringBuilder newConfigFileContents = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(configFile));){
            String line = reader.readLine();
            while (line != null) {
                String lineToRead = StringUtils.trim((String)line);
                if (lineToRead.startsWith("host.name=")) {
                    newConfigFileContents.append("host.name=").append(this.hostname).append(System.lineSeparator());
                } else if (lineToRead.startsWith("host.port=")) {
                    newConfigFileContents.append("host.port=").append(this.port).append(System.lineSeparator());
                } else if (lineToRead.startsWith("metc.security.use.ssl=")) {
                    newConfigFileContents.append("metc.security.use.ssl=").append(this.useSsl).append(System.lineSeparator());
                } else {
                    newConfigFileContents.append(line).append(System.lineSeparator());
                }
                line = reader.readLine();
            }
        }
        try (FileWriter writer = new FileWriter(configFile);){
            writer.write(newConfigFileContents.toString());
        }
    }

    private static class ServerConnectionDataImpl
    implements ServerConnectionService.ServerConnectionData {
        private String hostname;
        private int port;
        private boolean useSsl;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ServerConnectionDataImpl [hostname=").append(this.hostname).append(", port=").append(this.port).append(", useSsl=").append(this.useSsl).append("]");
            return builder.toString();
        }

        private ServerConnectionDataImpl(String inHostname, int inPort, boolean inUseSsl) {
            this.hostname = inHostname;
            this.port = inPort;
            this.useSsl = inUseSsl;
        }

        @Override
        public String getHostname() {
            return this.hostname;
        }

        @Override
        public void setHostname(String inHostname) {
            this.hostname = inHostname;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public void setPort(int inPort) {
            this.port = inPort;
        }

        @Override
        public boolean useSsl() {
            return this.useSsl;
        }

        @Override
        public void setUseSsl(boolean inUseSsl) {
            this.useSsl = inUseSsl;
        }
    }
}

