/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.service.trade;

import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.marketcetera.core.ClientStatusListener;
import org.marketcetera.fix.ActiveFixSession;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.trade.AverageFillPrice;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.ExecutionReportSummary;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.Order;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderSummary;
import org.marketcetera.trade.Report;
import org.marketcetera.trade.ReportID;
import org.marketcetera.trade.Suggestion;
import org.marketcetera.trade.SuggestionListener;
import org.marketcetera.trade.TradeMessageListener;
import org.marketcetera.trade.client.SendOrderResponse;
import org.marketcetera.trade.client.TradeClient;
import org.marketcetera.trading.rpc.TradeRpcClientFactory;
import org.marketcetera.trading.rpc.TradeRpcClientParameters;
import org.marketcetera.trading.rpc.TradeRpcClientParametersImpl;
import org.marketcetera.ui.service.ConnectableService;
import org.marketcetera.ui.service.ServiceManager;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TradeClientService
implements ConnectableService {
    @Value(value="${metc.photon.capital.symbols}")
    private boolean forceCapitalSymbols;
    private TradeRpcClientFactory tradeClientFactory;
    private TradeClient tradeClient;

    public static TradeClientService getInstance() {
        return ServiceManager.getInstance().getService(TradeClientService.class);
    }

    public void deleteReport(ReportID inReportId) {
        this.tradeClient.deleteReport(inReportId);
    }

    public void addTradeMessageListener(TradeMessageListener inTradeMessageListener) {
        this.tradeClient.addTradeMessageListener(inTradeMessageListener);
    }

    public void removeTradeMessageListener(TradeMessageListener inTradeMessageListener) {
        this.tradeClient.removeTradeMessageListener(inTradeMessageListener);
    }

    public ExecutionReport getLatestExecutionReportForOrderChain(OrderID inOrderId) {
        return this.tradeClient.getLatestExecutionReportForOrderChain(inOrderId);
    }

    public CollectionPageResponse<Report> getReports(PageRequest inPageRequest) {
        return this.tradeClient.getReports(inPageRequest);
    }

    public CollectionPageResponse<ExecutionReportSummary> getFills(PageRequest inPageRequest) {
        return this.tradeClient.getFills(inPageRequest);
    }

    public CollectionPageResponse<AverageFillPrice> getAveragePrice(PageRequest inPageRequest) {
        return this.tradeClient.getAveragePriceFills(inPageRequest);
    }

    public CollectionPageResponse<OrderSummary> getOpenOrders(PageRequest inPageRequest) {
        return this.tradeClient.getOpenOrders(inPageRequest);
    }

    public List<ActiveFixSession> getAvailableFixInitiatorSessions() {
        return this.tradeClient.readAvailableFixInitiatorSessions();
    }

    public Instrument resolveSymbol(String inSymbol) {
        return this.tradeClient.resolveSymbol(inSymbol);
    }

    public String getTreatedSymbol(String inSymbol) {
        if ((inSymbol = StringUtils.trimToNull((String)inSymbol)) == null) {
            return null;
        }
        if (this.isForceCapitalSymbols()) {
            inSymbol = inSymbol.toUpperCase();
        }
        return inSymbol;
    }

    public boolean isForceCapitalSymbols() {
        return this.forceCapitalSymbols;
    }

    public SendOrderResponse send(Order inOrder) {
        return this.tradeClient.sendOrder(inOrder);
    }

    public void sendOrderSuggestion(Suggestion inSuggestion) {
        this.tradeClient.sendOrderSuggestion(inSuggestion);
    }

    public void addSuggestionListener(SuggestionListener inSuggestionListener) {
        this.tradeClient.addSuggestionListener(inSuggestionListener);
    }

    public void removeSuggestionListener(SuggestionListener inSuggestionListener) {
        this.tradeClient.removeSuggestionListener(inSuggestionListener);
    }

    @Override
    public boolean isRunning() {
        return this.tradeClient != null && this.tradeClient.isRunning();
    }

    @Override
    public void disconnect() {
        if (this.tradeClient != null) {
            try {
                this.tradeClient.close();
            }
            catch (IOException e) {
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
            }
        }
        this.tradeClient = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(String inUsername, String inPassword, String inHostname, int inPort, boolean inUseSsl) throws Exception {
        if (this.tradeClient != null) {
            try {
                this.tradeClient.stop();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (String)"Unable to stop existing Trade client for {}: {}", (Object[])new Object[]{inUsername, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
            finally {
                this.tradeClient = null;
            }
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"Creating trade client for {} to {}:{} with ssl: {}", (Object[])new Object[]{inUsername, inHostname, inPort, inUseSsl});
        TradeRpcClientParametersImpl params = new TradeRpcClientParametersImpl();
        params.setHostname(inHostname);
        params.setPort(inPort);
        params.setUsername(inUsername);
        params.setPassword(inPassword);
        params.setUseSsl(inUseSsl);
        this.tradeClient = this.tradeClientFactory.create((TradeRpcClientParameters)params);
        this.tradeClient.start();
        return this.tradeClient.isRunning();
    }

    public void addClientStatusListener(ClientStatusListener inListener) {
        this.tradeClient.addClientStatusListener(inListener);
    }

    public void removeClientStatusListener(ClientStatusListener inListener) {
        this.tradeClient.removeClientStatusListener(inListener);
    }

    public void setTradeClientFactory(TradeRpcClientFactory inTradeClientFactory) {
        this.tradeClientFactory = inTradeClientFactory;
    }
}

