/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.strategy.service;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Optional;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.marketcetera.core.notifications.INotification;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.strategy.FileUploadRequest;
import org.marketcetera.strategy.StrategyClient;
import org.marketcetera.strategy.StrategyEventListener;
import org.marketcetera.strategy.StrategyInstance;
import org.marketcetera.strategy.StrategyMessage;
import org.marketcetera.strategy.StrategyRpcClientFactory;
import org.marketcetera.strategy.StrategyRpcClientParameters;
import org.marketcetera.ui.service.ConnectableService;
import org.marketcetera.ui.service.ServiceManager;
import org.marketcetera.util.log.SLF4JLoggerProxy;

public class StrategyClientService
implements ConnectableService {
    private StrategyClient strategyClient;
    private StrategyRpcClientFactory strategyClientFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(String inUsername, String inPassword, String inHostname, int inPort, boolean inUseSsl) throws Exception {
        if (this.strategyClient != null) {
            try {
                this.strategyClient.stop();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (String)"Unable to stop existing strategy client for {}: {}", (Object[])new Object[]{inUsername, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            }
            finally {
                this.strategyClient = null;
            }
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"Creating strategy client for {} to {}:{} with ssl: {}", (Object[])new Object[]{inUsername, inHostname, inPort, inUseSsl});
        StrategyRpcClientParameters params = new StrategyRpcClientParameters();
        params.setHostname(inHostname);
        params.setPort(inPort);
        params.setUsername(inUsername);
        params.setPassword(inPassword);
        params.setUseSsl(inUseSsl);
        this.strategyClient = this.strategyClientFactory.create(params);
        this.strategyClient.start();
        return this.strategyClient.isRunning();
    }

    @Override
    public void disconnect() {
        if (this.strategyClient != null) {
            try {
                this.strategyClient.close();
            }
            catch (IOException e) {
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
            }
        }
        this.strategyClient = null;
    }

    @Override
    public boolean isRunning() {
        return this.strategyClient != null && this.strategyClient.isRunning();
    }

    public void deleteStrategyMessage(long inStrategyMessageId) {
        this.strategyClient.deleteStrategyMessage(inStrategyMessageId);
    }

    public void deleteAllStrategyMessages(String inStrategyInstanceName) {
        this.strategyClient.deleteAllStrategyMessages(inStrategyInstanceName);
    }

    public void unloadStrategyInstance(String inStrategyInstanceName) {
        this.strategyClient.unloadStrategyInstance(inStrategyInstanceName);
    }

    public static StrategyClientService getInstance() {
        return ServiceManager.getInstance().getService(StrategyClientService.class);
    }

    public Optional<? extends StrategyInstance> findByName(String inName) {
        return this.strategyClient.findByName(inName);
    }

    public Collection<? extends StrategyInstance> getStrategyInstances() {
        return this.strategyClient.getStrategyInstances();
    }

    public CollectionPageResponse<? extends StrategyMessage> getStrategyMessages(String inStrategyName, INotification.Severity inSeverity, PageRequest inPageRequest) {
        return this.strategyClient.getStrategyMessages(inStrategyName, inSeverity, inPageRequest);
    }

    public void addStrategyEventListener(StrategyEventListener inListener) {
        this.strategyClient.addStrategyEventListener(inListener);
    }

    public void removeStrategyEventListener(StrategyEventListener inListener) {
        this.strategyClient.removeStrategyEventListener(inListener);
    }

    public void startStrategyInstance(String inStrategyInstanceName) {
        this.strategyClient.startStrategyInstance(inStrategyInstanceName);
    }

    public void stopStrategyInstance(String inStrategyInstanceName) {
        this.strategyClient.stopStrategyInstance(inStrategyInstanceName);
    }

    public void uploadFile(FileUploadRequest inRequest) throws IOException, NoSuchAlgorithmException {
        this.strategyClient.uploadFile(inRequest);
    }

    public void setStrategyClientFactory(StrategyRpcClientFactory inStrategyClientFactory) {
        this.strategyClientFactory = inStrategyClientFactory;
    }
}

