/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.fixmessagedetails.view;

import java.util.Properties;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.quickfix.FIXMessageUtil;
import org.marketcetera.quickfix.FIXVersion;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.events.NotificationEvent;
import org.marketcetera.ui.view.AbstractContentView;
import org.marketcetera.ui.view.ContentView;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import quickfix.DataDictionary;
import quickfix.Field;
import quickfix.InvalidMessage;
import quickfix.Message;

@Component
@Scope(value="prototype")
public class FixMessageDetailsView
extends AbstractContentView
implements ContentView {
    private VBox mainLayout;
    private TableView<DisplayFixMessageValue> fixMessageTable;
    private final Message fixMessage;
    private static final String NAME = "FIX Message Details View";

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public Region getMainLayout() {
        return this.mainLayout;
    }

    public FixMessageDetailsView(Region inParent, NewWindowEvent inEvent, Properties inViewProperties) {
        super(inParent, inEvent, inViewProperties);
        String rawFixMessage = inViewProperties.getProperty(Message.class.getCanonicalName());
        try {
            this.fixMessage = new Message(rawFixMessage);
        }
        catch (InvalidMessage e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void onStart() {
        this.mainLayout = new VBox();
        this.initializeTable();
        this.mainLayout.getChildren().add(this.fixMessageTable);
        this.updateRows(this.fixMessage);
    }

    private void updateRows(Message inFixMessage) {
        this.fixMessageTable.getItems().clear();
        try {
            FIXVersion fixVersion = FIXVersion.getFIXVersion((Message)inFixMessage);
            DataDictionary dataDictionary = FIXMessageUtil.getDataDictionary((FIXVersion)fixVersion);
            for (Field field : inFixMessage.getHeader()) {
                this.fixMessageTable.getItems().add((Object)new DisplayFixMessageValue(field.getTag(), dataDictionary.getFieldName(field.getTag()), dataDictionary.getFieldType(field.getTag()).getJavaType().getSimpleName(), String.valueOf(field.getObject())));
            }
            for (Field field : inFixMessage) {
                this.fixMessageTable.getItems().add((Object)new DisplayFixMessageValue(field.getTag(), dataDictionary.getFieldName(field.getTag()), dataDictionary.getFieldType(field.getTag()).getJavaType().getSimpleName(), String.valueOf(field.getObject())));
            }
            for (Field field : inFixMessage.getTrailer()) {
                this.fixMessageTable.getItems().add((Object)new DisplayFixMessageValue(field.getTag(), dataDictionary.getFieldName(field.getTag()), dataDictionary.getFieldType(field.getTag()).getJavaType().getSimpleName(), String.valueOf(field.getObject())));
            }
        }
        catch (Exception e) {
            this.uiMessageService.post(new NotificationEvent("Display FIX Message Details", "Unable to display FIX message details: " + PlatformServices.getMessage((Throwable)e), Alert.AlertType.WARNING));
        }
    }

    private void initializeTable() {
        this.fixMessageTable = new TableView();
        this.initializeColumns();
        this.fixMessageTable.setPlaceholder((Node)new Label("no fields to display"));
        this.fixMessageTable.prefWidthProperty().bind((ObservableValue)this.getParentWindow().widthProperty());
        this.fixMessageTable.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.mainLayout.prefHeightProperty().bind((ObservableValue)this.getParentWindow().heightProperty());
    }

    private void initializeColumns() {
        TableColumn tagColumn = new TableColumn("Tag");
        tagColumn.setCellValueFactory((Callback)new PropertyValueFactory("tag"));
        tagColumn.setSortable(false);
        TableColumn nameColumn = new TableColumn("Name");
        nameColumn.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        nameColumn.setSortable(false);
        TableColumn typeColumn = new TableColumn("Type");
        typeColumn.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        typeColumn.setSortable(false);
        TableColumn valueColumn = new TableColumn("Value");
        valueColumn.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        valueColumn.setSortable(false);
        this.fixMessageTable.getColumns().add((Object)tagColumn);
        this.fixMessageTable.getColumns().add((Object)nameColumn);
        this.fixMessageTable.getColumns().add((Object)typeColumn);
        this.fixMessageTable.getColumns().add((Object)valueColumn);
    }

    public static class DisplayFixMessageValue {
        private final IntegerProperty tagProperty = new SimpleIntegerProperty();
        private final StringProperty nameProperty = new SimpleStringProperty();
        private final StringProperty typeProperty = new SimpleStringProperty();
        private final StringProperty valueProperty = new SimpleStringProperty();

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("DisplayFixMessageValue [tag=").append(this.tagProperty.get()).append(", name=").append((String)this.nameProperty.get()).append(", type=").append((String)this.typeProperty.get()).append(", value=").append((String)this.valueProperty.get()).append("]");
            return builder.toString();
        }

        private DisplayFixMessageValue(int inTag, String inName, String inType, String inValue) {
            this.tagProperty.set(inTag);
            this.nameProperty.set((Object)inName);
            this.typeProperty.set((Object)inType);
            this.valueProperty.set((Object)inValue);
        }

        public ReadOnlyIntegerProperty tagProperty() {
            return this.tagProperty;
        }

        public ReadOnlyStringProperty nameProperty() {
            return this.nameProperty;
        }

        public ReadOnlyStringProperty typeProperty() {
            return this.typeProperty;
        }

        public ReadOnlyStringProperty valueProperty() {
            return this.valueProperty;
        }
    }
}

