/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view;

import java.net.URL;
import javafx.scene.image.Image;
import org.marketcetera.core.Pair;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.service.UiMessageService;
import org.marketcetera.ui.trade.view.TradeContentCategory;
import org.marketcetera.ui.view.AbstractContentViewFactory;
import org.marketcetera.ui.view.MenuContent;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTradeViewFactory
extends AbstractContentViewFactory
implements MenuContent {
    private Image icon;
    protected static final int openOrdersWeight = 100;
    protected static final int averagePriceWeight = 200;
    protected static final int fillsWeight = 300;
    protected static final int fixMessagesWeight = 400;
    protected static final int orderTicketWeight = 500;
    protected static final int tradeSuggestionsWeight = 600;
    @Autowired
    protected UiMessageService webMessageService;

    @Override
    public MenuContent getCategory() {
        return TradeContentCategory.instance;
    }

    @Override
    public Runnable getCommand() {
        return new Runnable(){

            @Override
            public void run() {
                AbstractTradeViewFactory.this.webMessageService.post(new TradeViewMenuEvent());
            }
        };
    }

    protected Pair<Double, Double> getWindowSize() {
        return Pair.create((Object)800.0, (Object)300.0);
    }

    protected abstract Class<? extends AbstractTradeViewFactory> getViewFactoryType();

    protected abstract String getViewName();

    protected Image getIcon(String inName) {
        if (this.icon == null) {
            this.icon = new Image(inName);
        }
        return this.icon;
    }

    private class TradeViewMenuEvent
    implements NewWindowEvent {
        private TradeViewMenuEvent() {
        }

        @Override
        public String getWindowTitle() {
            return AbstractTradeViewFactory.this.getViewName();
        }

        public Class<? extends AbstractTradeViewFactory> getViewFactoryType() {
            return AbstractTradeViewFactory.this.getViewFactoryType();
        }

        @Override
        public Pair<Double, Double> getWindowSize() {
            return AbstractTradeViewFactory.this.getWindowSize();
        }

        @Override
        public URL getWindowIcon() {
            return AbstractTradeViewFactory.this.getMenuIcon();
        }
    }
}

