/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view.fills;

import java.math.BigDecimal;
import java.util.Date;
import org.marketcetera.admin.User;
import org.marketcetera.core.instruments.InstrumentFromMessage;
import org.marketcetera.trade.BrokerID;
import org.marketcetera.trade.ExecutionReportSummary;
import org.marketcetera.trade.ExecutionType;
import org.marketcetera.trade.HasBrokerID;
import org.marketcetera.trade.HasInstrument;
import org.marketcetera.trade.Hierarchy;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OptionType;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderStatus;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.Originator;
import org.marketcetera.trade.Report;
import org.marketcetera.trade.ReportID;
import org.marketcetera.trade.ReportType;
import org.marketcetera.trade.SecurityType;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.TimeInForce;
import org.marketcetera.trade.UserID;
import org.marketcetera.ui.trade.view.DeletableFixMessageDisplayType;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import quickfix.FieldMap;
import quickfix.InvalidMessage;
import quickfix.Message;
import quickfix.SessionID;

public class DisplayExecutionReportSummary
implements ExecutionReportSummary,
Report,
DeletableFixMessageDisplayType,
HasInstrument,
HasBrokerID {
    private final Instrument instrument;
    private final Message fixMessage;
    private final ExecutionReportSummary executionReportSummary;

    public UserID getActorID() {
        return this.executionReportSummary.getReport().getActorID();
    }

    public String getFixMessage() {
        return this.executionReportSummary.getReport().getFixMessage();
    }

    public SessionID getSessionId() {
        return this.executionReportSummary.getReport().getSessionId();
    }

    public int getMsgSeqNum() {
        return this.executionReportSummary.getReport().getMsgSeqNum();
    }

    public Date getTransactTime() {
        return this.executionReportSummary.getReport().getTransactTime();
    }

    public ReportType getReportType() {
        return this.executionReportSummary.getReport().getReportType();
    }

    public BrokerID getBrokerID() {
        return this.executionReportSummary.getReport().getBrokerID();
    }

    public BrokerID getBrokerId() {
        return this.getBrokerID();
    }

    public ReportID getReportID() {
        return this.executionReportSummary.getReport().getReportID();
    }

    public Originator getOriginator() {
        return this.executionReportSummary.getReport().getOriginator();
    }

    public Hierarchy getHierarchy() {
        return this.executionReportSummary.getReport().getHierarchy();
    }

    public String getText() {
        return this.executionReportSummary.getReport().getText();
    }

    public OrderID getOrderID() {
        return this.executionReportSummary.getOrderID();
    }

    public void setOrderId(OrderID inOrderId) {
        throw new UnsupportedOperationException();
    }

    public OrderID getOriginalOrderID() {
        return this.executionReportSummary.getOriginalOrderID();
    }

    public SecurityType getSecurityType() {
        return this.executionReportSummary.getSecurityType();
    }

    public String getSymbol() {
        return this.executionReportSummary.getSymbol();
    }

    public String getExpiry() {
        return this.executionReportSummary.getExpiry();
    }

    public BigDecimal getStrikePrice() {
        return this.executionReportSummary.getStrikePrice();
    }

    public OptionType getOptionType() {
        return this.executionReportSummary.getOptionType();
    }

    public String getAccount() {
        return this.executionReportSummary.getAccount();
    }

    public OrderID getRootOrderID() {
        return this.executionReportSummary.getRootOrderID();
    }

    public Side getSide() {
        return this.executionReportSummary.getSide();
    }

    public BigDecimal getCumulativeQuantity() {
        return this.executionReportSummary.getCumulativeQuantity();
    }

    public BigDecimal getEffectiveCumulativeQuantity() {
        return this.executionReportSummary.getEffectiveCumulativeQuantity();
    }

    public BigDecimal getAveragePrice() {
        return this.executionReportSummary.getAveragePrice();
    }

    public BigDecimal getLastQuantity() {
        return this.executionReportSummary.getLastQuantity();
    }

    public BigDecimal getLastPrice() {
        return this.executionReportSummary.getLastPrice();
    }

    public OrderStatus getOrderStatus() {
        return this.executionReportSummary.getOrderStatus();
    }

    public ExecutionType getExecutionType() {
        return this.executionReportSummary.getExecutionType();
    }

    public Date getSendingTime() {
        return this.executionReportSummary.getSendingTime();
    }

    public User getViewer() {
        return this.executionReportSummary.getViewer();
    }

    public User getActor() {
        return this.executionReportSummary.getActor();
    }

    public Report getReport() {
        return this.executionReportSummary.getReport();
    }

    public UserID getViewerID() {
        return this.executionReportSummary.getViewerID();
    }

    public OrderID getBrokerOrderId() {
        return this.executionReportSummary.getBrokerOrderId();
    }

    public String getExecutionId() {
        return this.executionReportSummary.getExecutionId();
    }

    public BigDecimal getLeavesQuantity() {
        return this.executionReportSummary.getLeavesQuantity();
    }

    public BigDecimal getOrderQuantity() {
        return this.executionReportSummary.getOrderQuantity();
    }

    public OrderType getOrderType() {
        return this.executionReportSummary.getOrderType();
    }

    public BigDecimal getPrice() {
        return this.executionReportSummary.getPrice();
    }

    public TimeInForce getTimeInForce() {
        return this.executionReportSummary.getTimeInForce();
    }

    public OrderID getOrderId() {
        return this.executionReportSummary.getOrderID();
    }

    public Message getMessage() {
        return this.fixMessage;
    }

    public String getTrader() {
        return this.getReport().getActor().getName();
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument inInstrument) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DisplayExecutionReportSummary [executionReportSummary=").append(this.executionReportSummary).append("]");
        return builder.toString();
    }

    public DisplayExecutionReportSummary(ExecutionReportSummary inExecutionReportSummary) {
        this.executionReportSummary = inExecutionReportSummary;
        try {
            this.fixMessage = new Message(this.executionReportSummary.getReport().getFixMessage());
            Instrument tmpInstrument = null;
            if (this.fixMessage.isSetField(55)) {
                try {
                    tmpInstrument = ((InstrumentFromMessage)InstrumentFromMessage.SELECTOR.forValue((Object)this.fixMessage)).extract((FieldMap)this.fixMessage);
                }
                catch (Exception e) {
                    SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
                }
            } else {
                tmpInstrument = null;
            }
            this.instrument = tmpInstrument;
        }
        catch (InvalidMessage e) {
            throw new RuntimeException(e);
        }
    }
}

