/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view.openorders;

import java.util.Properties;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.trade.OrderID;
import org.marketcetera.trade.OrderSummary;
import org.marketcetera.ui.PhotonServices;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.trade.view.AbstractFixMessageView;
import org.marketcetera.ui.trade.view.openorders.DisplayOrderSummary;
import org.marketcetera.ui.view.ContentView;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OpenOrderView
extends AbstractFixMessageView<DisplayOrderSummary, OrderSummary>
implements ContentView {
    private Button cancelOpenOrdersButton;
    private TableColumn<DisplayOrderSummary, OrderID> rootOrderIdColumn;
    private static final String NAME = "Open Orders View";

    @Override
    public String getViewName() {
        return NAME;
    }

    public OpenOrderView(Region inParentWindow, NewWindowEvent inEvent, Properties inViewProperties) {
        super(inParentWindow, inEvent, inViewProperties);
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.cancelOpenOrdersButton = new Button();
        this.cancelOpenOrdersButton.setTooltip(new Tooltip("Cancel all open orders"));
        this.cancelOpenOrdersButton.setGraphic((Node)new ImageView(PhotonServices.getIcon("images/erase.png")));
        this.cancelOpenOrdersButton.setPadding(new Insets(0.0, 30.0, 0.0, 0.0));
        this.cancelOpenOrdersButton.setOnAction(event -> this.cancelOpenOrders());
        this.getAboveTableLayout().setAlignment(Pos.BASELINE_RIGHT);
        this.getAboveTableLayout().getChildren().add((Object)this.cancelOpenOrdersButton);
        this.getAboveTableLayout().prefWidthProperty().bind((ObservableValue)this.getMainLayout().widthProperty());
    }

    @Override
    protected SelectionMode getTableSelectionMode() {
        return SelectionMode.MULTIPLE;
    }

    @Override
    protected CollectionPageResponse<OrderSummary> getClientReports(PageRequest inPageRequest) {
        return this.tradeClientService.getOpenOrders(inPageRequest);
    }

    @Override
    protected DisplayOrderSummary createFixDisplayObject(OrderSummary inClientClazz) {
        return new DisplayOrderSummary(inClientClazz);
    }

    @Override
    protected Node getPlaceholder() {
        return new Label("no open orders");
    }

    @Override
    protected void initializeColumns(TableView<DisplayOrderSummary> inTableView) {
        super.initializeColumns(inTableView);
        this.rootOrderIdColumn = new TableColumn("RootOrdId");
        this.rootOrderIdColumn.setCellValueFactory((Callback)new PropertyValueFactory("rootOrderId"));
        inTableView.getColumns().add(2, this.rootOrderIdColumn);
    }

    private void cancelOpenOrders() {
        for (DisplayOrderSummary orderSummary : this.reportsTableView.getItems()) {
            this.cancelOrder(orderSummary);
        }
    }
}

