/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view.orderticket;

import com.google.common.collect.Sets;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import org.marketcetera.core.Pair;
import org.marketcetera.fix.FixPermissions;
import org.marketcetera.trade.TradePermissions;
import org.marketcetera.ui.trade.view.AbstractTradeViewFactory;
import org.marketcetera.ui.trade.view.orderticket.OrderTicketView;
import org.marketcetera.ui.view.ContentView;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.stereotype.Component;

@Component
public class OrderTicketViewFactory
extends AbstractTradeViewFactory {
    private static final Set<GrantedAuthority> requiredPermissions = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Enum[]{TradePermissions.SendOrderAction, FixPermissions.ViewBrokerStatusAction}));

    @Override
    public String getMenuCaption() {
        return "Order Ticket";
    }

    @Override
    public int getWeight() {
        return 500;
    }

    @Override
    public URL getMenuIcon() {
        return this.getClass().getClassLoader().getResource("images/tags.svg");
    }

    @Override
    public Set<GrantedAuthority> getAllPermissions() {
        return requiredPermissions;
    }

    @Override
    protected String getViewName() {
        return this.getMenuCaption();
    }

    @Override
    protected Pair<Double, Double> getWindowSize() {
        return Pair.create((Object)850.0, (Object)200.0);
    }

    @Override
    protected Class<? extends ContentView> getViewType() {
        return OrderTicketView.class;
    }

    @Override
    protected Class<? extends AbstractTradeViewFactory> getViewFactoryType() {
        return OrderTicketViewFactory.class;
    }
}

