/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view.reports;

import java.util.Properties;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.layout.Region;
import javafx.util.Callback;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.trade.Report;
import org.marketcetera.trade.ReportType;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.trade.view.AbstractDeletableFixMessageView;
import org.marketcetera.ui.trade.view.reports.DisplayReport;
import org.marketcetera.ui.view.ContentView;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ReportsView
extends AbstractDeletableFixMessageView<DisplayReport, Report>
implements ContentView {
    private TableColumn<DisplayReport, ReportType> msgTypeColumn;
    private static final String NAME = "FIX Messages View";

    public ReportsView(Region inParentWindow, NewWindowEvent inEvent, Properties inViewProperties) {
        super(inParentWindow, inEvent, inViewProperties);
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    protected CollectionPageResponse<Report> getClientReports(PageRequest inPageRequest) {
        return this.tradeClientService.getReports(inPageRequest);
    }

    @Override
    protected DisplayReport createFixDisplayObject(Report inClientClazz) {
        return new DisplayReport(inClientClazz);
    }

    @Override
    protected SelectionMode getTableSelectionMode() {
        return SelectionMode.MULTIPLE;
    }

    @Override
    protected void initializeColumns(TableView<DisplayReport> inTableView) {
        super.initializeColumns(inTableView);
        this.msgTypeColumn = new TableColumn("MsgType");
        this.msgTypeColumn.setCellValueFactory((Callback)new PropertyValueFactory("msgType"));
        inTableView.getColumns().add(2, this.msgTypeColumn);
    }
}

