/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.trade.view.suggestions;

import java.math.BigDecimal;
import java.util.Date;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.marketcetera.trade.HasInstrument;
import org.marketcetera.trade.Instrument;
import org.marketcetera.trade.OrderSingleSuggestion;
import org.marketcetera.trade.OrderType;
import org.marketcetera.trade.Side;
import org.marketcetera.trade.Suggestion;

public class DisplaySuggestion
implements HasInstrument {
    private final StringProperty identifierProperty = new SimpleStringProperty();
    private final ObjectProperty<BigDecimal> scoreProperty = new SimpleObjectProperty();
    private final ObjectProperty<Side> sideProperty = new SimpleObjectProperty();
    private final ObjectProperty<BigDecimal> quantityProperty = new SimpleObjectProperty();
    private final ObjectProperty<BigDecimal> priceProperty = new SimpleObjectProperty();
    private final ObjectProperty<Instrument> instrumentProperty = new SimpleObjectProperty();
    private final ObjectProperty<OrderType> orderTypeProperty = new SimpleObjectProperty();
    private final ObjectProperty<Date> timestampProperty = new SimpleObjectProperty();
    private final ObjectProperty<Suggestion> sourceProperty = new SimpleObjectProperty();

    public DisplaySuggestion(Suggestion inSuggestion) {
        this.sourceProperty.set((Object)inSuggestion);
        this.identifierProperty.set((Object)inSuggestion.getIdentifier());
        this.scoreProperty.set((Object)inSuggestion.getScore());
        if (!(inSuggestion instanceof OrderSingleSuggestion)) {
            throw new UnsupportedOperationException("Unsupported suggestion type: " + inSuggestion.getClass().getSimpleName());
        }
        OrderSingleSuggestion orderSingleSuggestion = (OrderSingleSuggestion)inSuggestion;
        this.instrumentProperty.set((Object)orderSingleSuggestion.getOrder().getInstrument());
        this.orderTypeProperty.set((Object)orderSingleSuggestion.getOrder().getOrderType());
        this.priceProperty.set((Object)orderSingleSuggestion.getOrder().getPrice());
        this.quantityProperty.set((Object)orderSingleSuggestion.getOrder().getQuantity());
        this.sideProperty.set((Object)orderSingleSuggestion.getOrder().getSide());
        this.timestampProperty.set((Object)new Date());
    }

    public Instrument getInstrument() {
        return (Instrument)this.instrumentProperty.get();
    }

    public void setInstrument(Instrument inInstrument) {
        this.instrumentProperty.set((Object)inInstrument);
    }

    public ReadOnlyStringProperty identifierProperty() {
        return this.identifierProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> scoreProperty() {
        return this.scoreProperty;
    }

    public ReadOnlyObjectProperty<Side> sideProperty() {
        return this.sideProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> quantityProperty() {
        return this.quantityProperty;
    }

    public ReadOnlyObjectProperty<BigDecimal> priceProperty() {
        return this.priceProperty;
    }

    public ReadOnlyObjectProperty<Instrument> instrumentProperty() {
        return this.instrumentProperty;
    }

    public ReadOnlyObjectProperty<OrderType> orderTypeProperty() {
        return this.orderTypeProperty;
    }

    public ReadOnlyObjectProperty<Date> timestampProperty() {
        return this.timestampProperty;
    }

    public ReadOnlyObjectProperty<Suggestion> sourceProperty() {
        return this.sourceProperty;
    }

    public String toString() {
        return ((Suggestion)this.sourceProperty.get()).toString();
    }
}

