/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.ui.view;

import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javafx.scene.layout.Region;
import javax.annotation.PostConstruct;
import org.marketcetera.brokers.BrokerStatusListener;
import org.marketcetera.core.ClientStatusListener;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.core.XmlService;
import org.marketcetera.fix.ActiveFixSession;
import org.marketcetera.ui.events.NewWindowEvent;
import org.marketcetera.ui.service.AuthorizationHelperService;
import org.marketcetera.ui.service.ServiceManager;
import org.marketcetera.ui.service.StyleService;
import org.marketcetera.ui.service.UiMessageService;
import org.marketcetera.ui.service.admin.AdminClientService;
import org.marketcetera.ui.view.ContentView;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class AbstractContentView
implements ContentView,
ClientStatusListener {
    protected AdminClientService adminClientService;
    private Timer reconnectTimer;
    @Autowired
    protected StyleService styleService;
    @Autowired
    protected XmlService xmlService;
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected UiMessageService uiMessageService;
    @Autowired
    protected ServiceManager serviceManager;
    @Autowired
    protected AuthorizationHelperService authzHelperService;
    private final NewWindowEvent newWindowEvent;
    private final Region parentWindow;
    private final Properties viewProperties;
    protected String viewName;
    private BrokerStatusListener brokerStatusListener;

    @PostConstruct
    public void start() {
        this.viewName = PlatformServices.getServiceName(this.getClass());
        SLF4JLoggerProxy.info((Object)this, (String)"Starting {}", (Object[])new Object[]{this.viewName});
        this.reconnectTimer = new Timer();
        this.adminClientService = this.serviceManager.getService(AdminClientService.class);
        this.adminClientService.addClientStatusListener(this);
        this.onStart();
    }

    public void receiveClientStatus(boolean inIsAvailable) {
        SLF4JLoggerProxy.trace((Object)this, (String)"{} received client status available: {}", (Object[])new Object[]{this.viewName, inIsAvailable});
        if (inIsAvailable) {
            this.reconnectTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    boolean succeeded = false;
                    do {
                        try {
                            AbstractContentView.this.onClientConnect();
                            succeeded = true;
                        }
                        catch (Exception e) {
                            SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    } while (!succeeded);
                    AbstractContentView.this.initializeBrokerStatusListener();
                }
            }, 500L);
        } else {
            this.onClientDisconnect();
        }
    }

    @Override
    public void onClose() {
        if (this.brokerStatusListener != null) {
            try {
                this.adminClientService.removeBrokerStatusListener(this.brokerStatusListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.adminClientService.removeClientStatusListener(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        SLF4JLoggerProxy.trace((Object)this, (String)"{} close", (Object[])new Object[]{this.viewName});
    }

    protected void initializeBrokerStatusListener() {
        if (this.brokerStatusListener != null) {
            try {
                this.adminClientService.removeBrokerStatusListener(this.brokerStatusListener);
                this.brokerStatusListener = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.brokerStatusListener = new BrokerStatusListener(){

            public void receiveBrokerStatus(ActiveFixSession inActiveFixSession) {
                AbstractContentView.this.onBrokerStatusChange(inActiveFixSession);
            }
        };
        this.serviceManager.getService(AdminClientService.class).addBrokerStatusListener(this.brokerStatusListener);
    }

    protected void onBrokerStatusChange(ActiveFixSession inActiveFixSession) {
    }

    protected void onClientConnect() {
    }

    protected void onClientDisconnect() {
    }

    protected abstract void onStart();

    protected Properties getViewProperties() {
        return this.viewProperties;
    }

    protected Region getParentWindow() {
        return this.parentWindow;
    }

    protected NewWindowEvent getNewWindowEvent() {
        return this.newWindowEvent;
    }

    protected AbstractContentView(Region inParentWindow, NewWindowEvent inEvent, Properties inViewProperties) {
        this.parentWindow = inParentWindow;
        this.newWindowEvent = inEvent;
        this.viewProperties = inViewProperties;
    }
}

