/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.remote.emitter;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.ConnectException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jms.JMSException;
import javax.security.auth.login.LoginException;
import org.apache.log4j.Level;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.client.ClientTest;
import org.marketcetera.core.Pair;
import org.marketcetera.core.notifications.Notification;
import org.marketcetera.event.EventTestBase;
import org.marketcetera.module.CopierModuleFactory;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.modules.remote.emitter.EmitterAdapter;
import org.marketcetera.modules.remote.emitter.Messages;
import org.marketcetera.modules.remote.emitter.RemoteDataEmitter;
import org.marketcetera.modules.remote.emitter.RemoteEmitterTestBase;
import org.marketcetera.modules.remote.receiver.ReceiverFactory;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.TypesTestBase;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.test.LogTestAssist;
import org.springframework.beans.factory.BeanCreationException;

@ClassVersion(value="$Id: RemoteDataEmitterTest.java 16154 2012-07-14 16:34:05Z colin $")
public class RemoteDataEmitterTest
extends RemoteEmitterTestBase {
    private final LogTestAssist mAssist = new LogTestAssist(RemoteDataEmitter.class.getName(), Level.WARN);

    @Test
    public void nulls() throws Exception {
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new RemoteDataEmitter(null, "bla", "bla", (EmitterAdapter)new MyAdapter());
            }
        };
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new RemoteDataEmitter("tcp://localhost:61617", "bla", "bla", null);
            }
        };
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new RemoteDataEmitter("tcp://localhost:61617", null, "bla", (EmitterAdapter)new MyAdapter());
            }
        };
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new RemoteDataEmitter("tcp://localhost:61617", "bla", null, (EmitterAdapter)new MyAdapter());
            }
        };
    }

    @Test
    public void connectFailure() throws Exception {
        final MyAdapter adapter = new MyAdapter();
        Throwable jmsException = new ExpectedFailure<Exception>(){

            protected void run() throws Exception {
                new RemoteDataEmitter("tcp://localhost:101", "admin", "admin", (EmitterAdapter)adapter);
            }
        }.getException().getCause().getCause();
        Assert.assertTrue((String)jmsException.toString(), (boolean)(jmsException instanceof JMSException));
        Assert.assertTrue((String)jmsException.getCause().toString(), (boolean)(jmsException.getCause() instanceof ConnectException));
        Assert.assertTrue((boolean)adapter.hasNoObjects());
        Assert.assertTrue((boolean)adapter.hasNoStatus());
        new ExpectedFailure<Exception>(){

            protected void run() throws Exception {
                new RemoteDataEmitter("this is not a URL", "admin", "admin", (EmitterAdapter)adapter);
            }
        };
        Assert.assertTrue((boolean)adapter.hasNoObjects());
        Assert.assertTrue((boolean)adapter.hasNoStatus());
    }

    @Test
    public void connectAndClose() throws Exception {
        this.initManager();
        MyAdapter adapter = new MyAdapter();
        RemoteDataEmitter emitter = new RemoteDataEmitter("tcp://localhost:61617", "why", "why", (EmitterAdapter)adapter);
        Assert.assertTrue((boolean)emitter.isConnected());
        Assert.assertNull((Object)emitter.getLastFailure());
        Assert.assertTrue((String)adapter.toString(), (boolean)adapter.hasNoObjects());
        Assert.assertFalse((String)adapter.toString(), (boolean)adapter.hasNoStatus());
        Assert.assertEquals((Object)new Pair((Object)false, (Object)true), adapter.getNextStatus());
        emitter.close();
        Assert.assertFalse((boolean)emitter.isConnected());
        Assert.assertNull((Object)emitter.getLastFailure());
        Assert.assertTrue((String)adapter.toString(), (boolean)adapter.hasNoObjects());
        Assert.assertFalse((String)adapter.toString(), (boolean)adapter.hasNoStatus());
        Assert.assertEquals((Object)new Pair((Object)true, (Object)false), adapter.getNextStatus());
        emitter.close();
        Assert.assertFalse((boolean)emitter.isConnected());
        Assert.assertNull((Object)emitter.getLastFailure());
        Assert.assertTrue((String)adapter.toString(), (boolean)adapter.hasNoObjects());
        Assert.assertTrue((String)adapter.toString(), (boolean)adapter.hasNoStatus());
    }

    @Test
    public void authFailure() throws Exception {
        this.initManager();
        this.verifyAuthFailure("", "why");
        this.verifyAuthFailure("why", "");
        this.verifyAuthFailure("yes", "no");
    }

    @Test
    public void receiveData() throws Exception {
        this.initManager();
        MyAdapter adapter = new MyAdapter();
        RemoteDataEmitter emitter = new RemoteDataEmitter("tcp://localhost:61617", "why", "why", (EmitterAdapter)adapter);
        Assert.assertTrue((boolean)emitter.isConnected());
        Assert.assertFalse((String)adapter.toString(), (boolean)adapter.hasNoStatus());
        Assert.assertEquals((Object)new Pair((Object)false, (Object)true), adapter.getNextStatus());
        Object[] data = new Object[]{EventTestBase.generateEquityAskEvent((long)1L, (long)2L, (Equity)new Equity("asym"), (String)"ex", (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.TEN), EventTestBase.generateEquityBidEvent((long)3L, (long)4L, (Equity)new Equity("bsym"), (String)"ex", (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.TEN), EventTestBase.generateEquityTradeEvent((long)5L, (long)6L, (Equity)new Equity("csym"), (String)"ex", (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.TEN), new NonSerializable(), ClientTest.createOrderSingle(), ClientTest.createOrderReplace(), ClientTest.createOrderCancel(), ClientTest.createOrderFIX(), ClientTest.createCancelReject(), ClientTest.createExecutionReport(), Notification.high((String)"Subject", (String)"body", (String)"test.notification"), BigInteger.ONE, "Test String"};
        DataFlowID rFlowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)data), new DataRequest(ReceiverFactory.INSTANCE_URN)}, false);
        for (Object expected : data) {
            if (expected instanceof NonSerializable) continue;
            Object actual = adapter.getNextObject();
            if (expected instanceof OrderSingle) {
                TypesTestBase.assertOrderSingleEquals((OrderSingle)((OrderSingle)expected), (OrderSingle)((OrderSingle)actual));
                continue;
            }
            if (expected instanceof OrderReplace) {
                TypesTestBase.assertOrderReplaceEquals((OrderReplace)((OrderReplace)expected), (OrderReplace)((OrderReplace)actual));
                continue;
            }
            if (expected instanceof OrderCancel) {
                TypesTestBase.assertOrderCancelEquals((OrderCancel)((OrderCancel)expected), (OrderCancel)((OrderCancel)actual));
                continue;
            }
            if (expected instanceof FIXOrder) {
                TypesTestBase.assertOrderFIXEquals((FIXOrder)((FIXOrder)expected), (FIXOrder)((FIXOrder)actual));
                continue;
            }
            if (expected instanceof OrderCancelReject) {
                TypesTestBase.assertCancelRejectEquals((OrderCancelReject)((OrderCancelReject)expected), (OrderCancelReject)((OrderCancelReject)actual));
                continue;
            }
            if (expected instanceof ExecutionReport) {
                TypesTestBase.assertExecReportEquals((ExecutionReport)((ExecutionReport)expected), (ExecutionReport)((ExecutionReport)actual));
                continue;
            }
            if (expected instanceof Notification) {
                Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
                continue;
            }
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        Assert.assertTrue((String)adapter.toString(), (boolean)adapter.hasNoObjects());
        Assert.assertNull((Object)emitter.getLastFailure());
        Assert.assertTrue((String)adapter.toString(), (boolean)adapter.hasNoStatus());
        this.mManager.cancel(rFlowID);
    }

    @Test
    public void connectionStatusNotify() throws Exception {
        this.mAssist.resetAppender();
        this.initManager();
        MyAdapter adapter = new MyAdapter();
        RemoteDataEmitter emitter = new RemoteDataEmitter("tcp://localhost:61617", "why", "why", (EmitterAdapter)adapter);
        Assert.assertTrue((boolean)emitter.isConnected());
        Assert.assertNull((Object)emitter.getLastFailure());
        Assert.assertTrue((String)adapter.toString(), (boolean)adapter.hasNoObjects());
        Assert.assertFalse((String)adapter.toString(), (boolean)adapter.hasNoStatus());
        Assert.assertEquals((Object)new Pair((Object)false, (Object)true), adapter.getNextStatus());
        this.mManager.stop(ReceiverFactory.INSTANCE_URN);
        Thread.sleep(3000L);
        Assert.assertFalse((String)adapter.toString(), (boolean)adapter.hasNoStatus());
        Assert.assertEquals((Object)new Pair((Object)true, (Object)false), adapter.getNextStatus());
        Assert.assertFalse((boolean)emitter.isConnected());
        Assert.assertNotNull((Object)emitter.getLastFailure());
        emitter.close();
        Assert.assertFalse((boolean)emitter.isConnected());
        Assert.assertNotNull((Object)emitter.getLastFailure());
        Assert.assertTrue((String)adapter.toString(), (boolean)adapter.hasNoObjects());
        Assert.assertTrue((String)adapter.toString(), (boolean)adapter.hasNoStatus());
        this.mAssist.assertLastEvent(Level.WARN, RemoteDataEmitter.class.getName(), Messages.LOG_ERROR_CLOSING_CONNECTION.getText(), null);
        this.mManager.start(ReceiverFactory.INSTANCE_URN);
        adapter = new MyAdapter();
        emitter = new RemoteDataEmitter("tcp://localhost:61617", "why", "why", (EmitterAdapter)adapter);
        Assert.assertTrue((boolean)emitter.isConnected());
        Assert.assertNull((Object)emitter.getLastFailure());
        Assert.assertTrue((String)adapter.toString(), (boolean)adapter.hasNoObjects());
        Assert.assertFalse((String)adapter.toString(), (boolean)adapter.hasNoStatus());
        Assert.assertEquals((Object)new Pair((Object)false, (Object)true), adapter.getNextStatus());
        emitter.close();
        Assert.assertFalse((boolean)emitter.isConnected());
        Assert.assertNull((Object)emitter.getLastFailure());
        Assert.assertTrue((String)adapter.toString(), (boolean)adapter.hasNoObjects());
        Assert.assertFalse((String)adapter.toString(), (boolean)adapter.hasNoStatus());
        Assert.assertEquals((Object)new Pair((Object)true, (Object)false), adapter.getNextStatus());
    }

    @Test
    public void nonDeserializables() throws Exception {
        this.initManager();
        MyAdapter adapter = new MyAdapter();
        RemoteDataEmitter emitter = new RemoteDataEmitter("tcp://localhost:61617", "why", "why", (EmitterAdapter)adapter);
        Assert.assertTrue((boolean)emitter.isConnected());
        Assert.assertFalse((String)adapter.toString(), (boolean)adapter.hasNoStatus());
        Assert.assertEquals((Object)new Pair((Object)false, (Object)true), adapter.getNextStatus());
        Object[] data = new Object[]{"test", new NonDeserializable(), "once more"};
        DataFlowID rFlowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)data), new DataRequest(ReceiverFactory.INSTANCE_URN)}, false);
        for (Object expected : data) {
            if (expected instanceof NonDeserializable) continue;
            Object actual = adapter.getNextObject();
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        Assert.assertTrue((String)adapter.toString(), (boolean)adapter.hasNoObjects());
        Assert.assertNotNull((String)emitter.getLastFailure().toString(), (Object)emitter.getLastFailure());
        Assert.assertTrue((String)emitter.getLastFailure().toString(), (boolean)(emitter.getLastFailure().getCause() instanceof NotSerializableException));
        Assert.assertFalse((boolean)emitter.isConnected());
        Assert.assertFalse((String)adapter.toString(), (boolean)adapter.hasNoStatus());
        Assert.assertEquals((Object)new Pair((Object)true, (Object)false), adapter.getNextStatus());
        this.mManager.cancel(rFlowID);
    }

    private void verifyAuthFailure(final String inUsername, final String inPassword) throws Exception {
        final MyAdapter adapter = new MyAdapter();
        Throwable failure = new ExpectedFailure<BeanCreationException>(){

            protected void run() throws Exception {
                new RemoteDataEmitter("tcp://localhost:61617", inUsername, inPassword, (EmitterAdapter)adapter);
            }
        }.getException();
        boolean isLoginError = false;
        do {
            if (!(failure instanceof LoginException)) continue;
            isLoginError = true;
            break;
        } while ((failure = failure.getCause()) != null);
        Assert.assertTrue((boolean)isLoginError);
        Assert.assertTrue((boolean)adapter.hasNoObjects());
        Assert.assertTrue((boolean)adapter.hasNoStatus());
    }

    private static class MyAdapter
    implements EmitterAdapter {
        private final BlockingQueue<Object> mData = new LinkedBlockingQueue<Object>();
        private final BlockingQueue<Pair<Boolean, Boolean>> mStatus = new LinkedBlockingQueue<Pair<Boolean, Boolean>>();

        private MyAdapter() {
        }

        public void receiveData(Object inObject) {
            this.mData.add(inObject);
        }

        public void connectionStatusChanged(boolean inOldStatus, boolean inNewStatus) {
            this.mStatus.add((Pair<Boolean, Boolean>)new Pair((Object)inOldStatus, (Object)inNewStatus));
        }

        public Object getNextObject() throws InterruptedException {
            return this.mData.take();
        }

        public Pair<Boolean, Boolean> getNextStatus() throws InterruptedException {
            return this.mStatus.take();
        }

        public boolean hasNoObjects() {
            return this.mData.isEmpty();
        }

        public boolean hasNoStatus() {
            return this.mStatus.isEmpty();
        }

        public String toString() {
            return "MyAdapter{mData=" + this.mData + ", mStatus=" + this.mStatus + '}';
        }
    }

    private static class NonDeserializable
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private NonDeserializable() {
        }

        private void readObject(ObjectInputStream in) throws IOException {
            throw new NotSerializableException();
        }
    }

    private static class NonSerializable {
        private NonSerializable() {
        }
    }
}

