/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.remote.emitter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Deque;
import java.util.LinkedList;
import javax.management.AttributeChangeNotification;
import javax.management.JMX;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.client.ClientTest;
import org.marketcetera.event.EventTestBase;
import org.marketcetera.event.LogEvent;
import org.marketcetera.event.LogEventLevel;
import org.marketcetera.event.impl.LogEventBuilder;
import org.marketcetera.module.BlockingSinkDataListener;
import org.marketcetera.module.CopierModuleFactory;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.MockConfigProvider;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleInfo;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleState;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.SinkDataListener;
import org.marketcetera.modules.remote.emitter.EmitterFactory;
import org.marketcetera.modules.remote.emitter.EmitterModuleMXBean;
import org.marketcetera.modules.remote.emitter.Messages;
import org.marketcetera.modules.remote.emitter.RemoteEmitterTestBase;
import org.marketcetera.modules.remote.receiver.ReceiverFactory;
import org.marketcetera.modules.remote.receiver.ReceiverModuleMXBean;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.TypesTestBase;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: EmitterModuleTest.java 16154 2012-07-14 16:34:05Z colin $")
public class EmitterModuleTest
extends RemoteEmitterTestBase {
    private static final ModuleURN TEST_INSTANCE_URN = new ModuleURN(EmitterFactory.PROVIDER_URN, "test");

    @Test
    public void info() throws Exception {
        this.initManager();
        EmitterModuleTest.assertProviderInfo((ModuleManager)this.mManager, (ModuleURN)EmitterFactory.PROVIDER_URN, (String[])new String[]{String.class.getName()}, (Class[])new Class[]{String.class}, (String)Messages.PROVIDER_DESCRIPTION.getText(), (boolean)false, (boolean)true);
        String myModule = "mine";
        new ExpectedFailure<ModuleException>((I18NBoundMessage)Messages.START_FAIL_NO_URL){

            protected void run() throws Exception {
                EmitterModuleTest.this.mManager.createModule(EmitterFactory.PROVIDER_URN, new Object[]{"mine"});
            }
        };
        ModuleInfo info = EmitterModuleTest.assertModuleInfo((ModuleManager)this.mManager, (ModuleURN)new ModuleURN(EmitterFactory.PROVIDER_URN, "mine"), (ModuleState)ModuleState.START_FAILED, null, null, (boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)false);
        Assert.assertEquals((Object)Messages.START_FAIL_NO_URL.getText(), (Object)info.getLastStartFailure());
        Assert.assertNull((Object)info.getLastStopFailure());
    }

    @Test
    public void jmx() throws Exception {
        this.initManager();
        this.mManager.createModule(EmitterFactory.PROVIDER_URN, new Object[]{TEST_INSTANCE_URN.instanceName()});
        EmitterModuleTest.assertModuleInfo((ModuleManager)this.mManager, (ModuleURN)TEST_INSTANCE_URN, (ModuleState)ModuleState.STARTED, null, null, (boolean)false, (boolean)true, (boolean)false, (boolean)true, (boolean)false);
        MBeanInfo beanInfo = EmitterModuleTest.getMBeanServer().getMBeanInfo(TEST_INSTANCE_URN.toObjectName());
        EmitterModuleTest.verifyBeanInfo((MBeanInfo)beanInfo);
        Assert.assertEquals((long)1L, (long)beanInfo.getNotifications().length);
        Assert.assertEquals((Object)new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), Messages.ATTRIB_CHANGE_NOTIFICATION.getText()), (Object)beanInfo.getNotifications()[0]);
        final EmitterModuleMXBean bean = JMX.newMXBeanProxy(EmitterModuleTest.getMBeanServer(), TEST_INSTANCE_URN.toObjectName(), EmitterModuleMXBean.class);
        Assert.assertEquals(null, (Object)bean.getLastFailure());
        Assert.assertEquals((Object)"tcp://localhost:61617", (Object)bean.getURL());
        Assert.assertEquals((Object)"why", (Object)bean.getUsername());
        Assert.assertEquals((Object)true, (Object)bean.isConnected());
        new ExpectedFailure<IllegalStateException>(Messages.ILLEGAL_STATE_CHANGE_PASSWORD.getText()){

            protected void run() throws Exception {
                bean.setPassword("value");
            }
        };
        new ExpectedFailure<IllegalStateException>(Messages.ILLEGAL_STATE_CHANGE_URL.getText()){

            protected void run() throws Exception {
                bean.setURL("tcp://myurl");
            }
        };
        new ExpectedFailure<IllegalStateException>(Messages.ILLEGAL_STATE_CHANGE_USERNAME.getText()){

            protected void run() throws Exception {
                bean.setUsername("myuser");
            }
        };
        this.mManager.stop(TEST_INSTANCE_URN);
        Assert.assertEquals((Object)false, (Object)bean.isConnected());
        String newURL = "tcp://127.0.0.1:50000";
        bean.setURL(newURL);
        Assert.assertEquals((Object)newURL, (Object)bean.getURL());
        this.verifyStartFailure(bean);
        bean.setURL(null);
        Assert.assertEquals(null, (Object)bean.getURL());
        this.verifyStartFailure(bean, Messages.START_FAIL_NO_URL);
        bean.setURL("tcp://localhost:61617");
        String newUser = "who?";
        bean.setUsername(newUser);
        Assert.assertEquals((Object)newUser, (Object)bean.getUsername());
        this.verifyStartFailure(bean);
        bean.setUsername(null);
        Assert.assertEquals(null, (Object)bean.getUsername());
        this.verifyStartFailure(bean);
        bean.setUsername("why");
        String newPass = "pass";
        bean.setPassword(newPass);
        this.verifyStartFailure(bean);
        bean.setPassword(null);
        this.verifyStartFailure(bean);
        bean.setPassword("why");
        this.mManager.start(TEST_INSTANCE_URN);
        Assert.assertEquals((Object)true, (Object)bean.isConnected());
        this.mManager.stop(TEST_INSTANCE_URN);
        this.mManager.deleteModule(TEST_INSTANCE_URN);
    }

    @Test(timeout=10000L)
    public void flows() throws Exception {
        this.initManager();
        this.mManager.createModule(EmitterFactory.PROVIDER_URN, new Object[]{TEST_INSTANCE_URN.instanceName()});
        BlockingSinkDataListener listener = new BlockingSinkDataListener();
        this.mManager.addSinkListener((SinkDataListener)listener);
        DataFlowID eFlowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(TEST_INSTANCE_URN)}, true);
        Thread.sleep(1000L);
        Assert.assertEquals((long)0L, (long)listener.size());
        Object[] data = new Object[]{EventTestBase.generateEquityAskEvent((long)1L, (long)2L, (Equity)new Equity("asym"), (String)"ex", (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.TEN), EventTestBase.generateEquityBidEvent((long)3L, (long)4L, (Equity)new Equity("bsym"), (String)"ex", (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.TEN), EventTestBase.generateEquityTradeEvent((long)5L, (long)6L, (Equity)new Equity("csym"), (String)"ex", (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.TEN), ClientTest.createOrderSingle(), ClientTest.createOrderReplace(), ClientTest.createOrderCancel(), ClientTest.createOrderFIX(), ClientTest.createCancelReject(), ClientTest.createExecutionReport(), org.marketcetera.core.notifications.Notification.high((String)"Subject", (String)"body", (String)"test.notification"), BigInteger.ONE, "Test String"};
        DataFlowID rFlowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)data), new DataRequest(ReceiverFactory.INSTANCE_URN)}, false);
        for (Object expected : data) {
            Object actual = listener.getNextData();
            if (expected instanceof OrderSingle) {
                TypesTestBase.assertOrderSingleEquals((OrderSingle)((OrderSingle)expected), (OrderSingle)((OrderSingle)actual));
                continue;
            }
            if (expected instanceof OrderReplace) {
                TypesTestBase.assertOrderReplaceEquals((OrderReplace)((OrderReplace)expected), (OrderReplace)((OrderReplace)actual));
                continue;
            }
            if (expected instanceof OrderCancel) {
                TypesTestBase.assertOrderCancelEquals((OrderCancel)((OrderCancel)expected), (OrderCancel)((OrderCancel)actual));
                continue;
            }
            if (expected instanceof FIXOrder) {
                TypesTestBase.assertOrderFIXEquals((FIXOrder)((FIXOrder)expected), (FIXOrder)((FIXOrder)actual));
                continue;
            }
            if (expected instanceof OrderCancelReject) {
                TypesTestBase.assertCancelRejectEquals((OrderCancelReject)((OrderCancelReject)expected), (OrderCancelReject)((OrderCancelReject)actual));
                continue;
            }
            if (expected instanceof ExecutionReport) {
                TypesTestBase.assertExecReportEquals((ExecutionReport)((ExecutionReport)expected), (ExecutionReport)((ExecutionReport)actual));
                continue;
            }
            if (expected instanceof org.marketcetera.core.notifications.Notification) {
                Assert.assertEquals((Object)expected.toString(), (Object)actual.toString());
                continue;
            }
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        this.mManager.cancel(rFlowID);
        this.mManager.cancel(eFlowID);
    }

    @Test
    public void logEventFiltering() throws Exception {
        this.initManager();
        this.mManager.createModule(EmitterFactory.PROVIDER_URN, new Object[]{TEST_INSTANCE_URN.instanceName()});
        BlockingSinkDataListener listener = new BlockingSinkDataListener();
        this.mManager.addSinkListener((SinkDataListener)listener);
        ReceiverModuleMXBean bean = JMX.newMXBeanProxy(EmitterModuleTest.getMBeanServer(), ReceiverFactory.INSTANCE_URN.toObjectName(), ReceiverModuleMXBean.class);
        Assert.assertEquals((Object)LogEventLevel.WARN, (Object)bean.getLogLevel());
        this.runLogFilterFlow(listener, LogEventLevel.WARN);
        for (LogEventLevel level : LogEventLevel.values()) {
            bean.setLogLevel(level);
            Assert.assertEquals((Object)level, (Object)bean.getLogLevel());
            this.runLogFilterFlow(listener, level);
        }
    }

    @Test
    public void connectionFailureAndJMXNotifications() throws Exception {
        this.initManager();
        this.mManager.createModule(EmitterFactory.PROVIDER_URN, new Object[]{TEST_INSTANCE_URN.instanceName()});
        EmitterModuleMXBean bean = JMX.newMXBeanProxy(EmitterModuleTest.getMBeanServer(), TEST_INSTANCE_URN.toObjectName(), EmitterModuleMXBean.class);
        BeanNotificationListener listener = new BeanNotificationListener();
        EmitterModuleTest.getMBeanServer().addNotificationListener(TEST_INSTANCE_URN.toObjectName(), listener, null, new Object());
        Assert.assertEquals((Object)true, (Object)bean.isConnected());
        Assert.assertNull((Object)bean.getLastFailure());
        Assert.assertEquals((long)0L, (long)listener.size());
        this.mManager.stop(ReceiverFactory.INSTANCE_URN);
        Thread.sleep(3000L);
        Assert.assertEquals((Object)false, (Object)bean.isConnected());
        Assert.assertNotNull((Object)bean.getLastFailure());
        Assert.assertEquals((long)1L, (long)listener.size());
        EmitterModuleTest.assertNotification(listener.getLastNotification(), true, false);
        this.mManager.stop(TEST_INSTANCE_URN);
        Assert.assertEquals((long)1L, (long)listener.size());
        this.mManager.start(ReceiverFactory.INSTANCE_URN);
        this.mManager.start(TEST_INSTANCE_URN);
        Assert.assertEquals((Object)true, (Object)bean.isConnected());
        Assert.assertNull((Object)bean.getLastFailure());
        Assert.assertEquals((long)2L, (long)listener.size());
        EmitterModuleTest.assertNotification(listener.getLastNotification(), false, true);
        this.mManager.stop(TEST_INSTANCE_URN);
        Assert.assertEquals((Object)false, (Object)bean.isConnected());
        Assert.assertNull((Object)bean.getLastFailure());
        Assert.assertEquals((long)3L, (long)listener.size());
        EmitterModuleTest.assertNotification(listener.getLastNotification(), true, false);
        EmitterModuleTest.getMBeanServer().removeNotificationListener(TEST_INSTANCE_URN.toObjectName(), listener);
        this.mManager.start(TEST_INSTANCE_URN);
        Assert.assertEquals((Object)true, (Object)bean.isConnected());
        Assert.assertEquals((long)3L, (long)listener.size());
        this.mManager.stop(TEST_INSTANCE_URN);
        Assert.assertEquals((Object)false, (Object)bean.isConnected());
        Assert.assertEquals((long)3L, (long)listener.size());
        this.mManager.deleteModule(TEST_INSTANCE_URN);
        Assert.assertEquals((long)3L, (long)listener.size());
    }

    private void runLogFilterFlow(BlockingSinkDataListener inListener, LogEventLevel inCurrentLevel) throws Exception {
        DataFlowID eFlowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(TEST_INSTANCE_URN)}, true);
        Thread.sleep(1000L);
        Assert.assertEquals((long)0L, (long)inListener.size());
        I18NMessage0P[] msgs = new I18NMessage0P[]{new I18NMessage0P(Messages.LOGGER, "debug"), new I18NMessage0P(Messages.LOGGER, "info"), new I18NMessage0P(Messages.LOGGER, "warn"), new I18NMessage0P(Messages.LOGGER, "error")};
        LogEvent[] data = new LogEvent[]{(LogEvent)LogEventBuilder.debug().withMessage(msgs[0]).create(), (LogEvent)LogEventBuilder.info().withMessage(msgs[1]).create(), (LogEvent)LogEventBuilder.warn().withMessage(msgs[2]).create(), (LogEvent)LogEventBuilder.error().withMessage(msgs[3]).create()};
        DataFlowID rFlowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)data), new DataRequest(ReceiverFactory.INSTANCE_URN)}, false);
        int numEvents = data.length - inCurrentLevel.ordinal();
        int idx = inCurrentLevel.ordinal();
        while (numEvents-- > 0) {
            Assert.assertEquals((Object)data[idx++].getMessage(), (Object)((LogEvent)inListener.getNextData()).getMessage());
        }
        this.mManager.cancel(rFlowID);
        this.mManager.cancel(eFlowID);
    }

    @Override
    protected MockConfigProvider configProviderWithURLValue(String inUrl) {
        MockConfigProvider prov = super.configProviderWithURLValue(inUrl);
        prov.addDefault(TEST_INSTANCE_URN, "URL", inUrl);
        prov.addDefault(TEST_INSTANCE_URN, "Username", "why");
        prov.addDefault(TEST_INSTANCE_URN, "Password", "why");
        return prov;
    }

    private void verifyStartFailure(EmitterModuleMXBean inBean) throws Exception {
        this.verifyStartFailure(inBean, Messages.ERROR_STARTING_MODULE);
    }

    private void verifyStartFailure(EmitterModuleMXBean inBean, I18NMessage0P inMessage) throws Exception {
        new ExpectedFailure<ModuleException>((I18NBoundMessage)inMessage){

            protected void run() throws Exception {
                EmitterModuleTest.this.mManager.start(TEST_INSTANCE_URN);
            }
        };
        Assert.assertEquals((Object)false, (Object)inBean.isConnected());
        Assert.assertNull((Object)inBean.getLastFailure());
    }

    private static void assertNotification(Notification inNotify, boolean inOldValue, boolean inNewValue) throws Exception {
        Assert.assertEquals((Object)"jmx.attribute.change", (Object)inNotify.getType());
        Assert.assertEquals((Object)TEST_INSTANCE_URN.toString(), (Object)inNotify.getSource());
        Assert.assertTrue((String)inNotify.toString(), (boolean)(inNotify instanceof AttributeChangeNotification));
        AttributeChangeNotification note = (AttributeChangeNotification)inNotify;
        Assert.assertEquals((Object)"Connected", (Object)note.getAttributeName());
        Assert.assertEquals((Object)"boolean", (Object)note.getAttributeType());
        Assert.assertEquals((Object)inOldValue, (Object)note.getOldValue());
        Assert.assertEquals((Object)inNewValue, (Object)note.getNewValue());
    }

    private static class BeanNotificationListener
    implements NotificationListener {
        private final Deque<Notification> mNotifications = new LinkedList<Notification>();

        private BeanNotificationListener() {
        }

        @Override
        public synchronized void handleNotification(Notification notification, Object handback) {
            this.mNotifications.addLast(notification);
        }

        synchronized int size() {
            return this.mNotifications.size();
        }

        synchronized Notification getLastNotification() {
            return this.mNotifications.getLast();
        }
    }
}

