/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.remote.emitter;

import org.marketcetera.modules.remote.emitter.EmitterAdapter;
import org.marketcetera.modules.remote.emitter.Messages;
import org.marketcetera.modules.remote.emitter.MessagingDelegate;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.spring.SpringUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

@ClassVersion(value="$Id: RemoteDataEmitter.java 17401 2017-04-25 15:59:46Z colin $")
public class RemoteDataEmitter {
    private volatile ClassPathXmlApplicationContext mContext;
    private volatile Exception mLastFailure;
    private final EmitterAdapter mAdapter;

    public RemoteDataEmitter(String inURL, String inUsername, String inPassword, EmitterAdapter inAdapter) {
        if (inURL == null) {
            throw new NullPointerException();
        }
        if (inAdapter == null) {
            throw new NullPointerException();
        }
        if (inUsername == null) {
            throw new NullPointerException();
        }
        if (inPassword == null) {
            throw new NullPointerException();
        }
        this.mAdapter = inAdapter;
        StaticApplicationContext parent = new StaticApplicationContext();
        SpringUtils.addStringBean((BeanDefinitionRegistry)parent, (String)"brokerURI", (String)inURL);
        SpringUtils.addStringBean((BeanDefinitionRegistry)parent, (String)"username", (String)inUsername);
        SpringUtils.addStringBean((BeanDefinitionRegistry)parent, (String)"password", (String)inPassword);
        parent.refresh();
        this.mContext = new ClassPathXmlApplicationContext(new String[]{"remote-emitter-jms.xml"}, (ApplicationContext)parent);
        this.mContext.start();
        MessagingDelegate delegate = (MessagingDelegate)this.mContext.getBean("delegate", MessagingDelegate.class);
        delegate.setDataEmitter(this);
        this.setLastFailure(null);
        this.sendConnectedChanged(false, true);
    }

    public synchronized void close() {
        if (this.mContext == null) {
            return;
        }
        boolean isConnected = this.getLastFailure() == null;
        try {
            this.mContext.close();
        }
        catch (Exception e) {
            Messages.LOG_ERROR_CLOSING_CONNECTION.warn((Object)this, (Throwable)e);
        }
        this.mContext = null;
        if (isConnected) {
            this.sendConnectedChanged(isConnected, false);
        }
    }

    public Exception getLastFailure() {
        return this.mLastFailure;
    }

    public boolean isConnected() {
        return this.mContext != null && this.mLastFailure == null;
    }

    void receive(Object inObject) {
        this.mAdapter.receiveData(inObject);
    }

    void onException(Exception inException) {
        Messages.LOG_ERROR_RECEIVER_CONNECTION.warn((Object)this, (Throwable)inException);
        this.setLastFailure(inException);
    }

    private void setLastFailure(Exception inLastFailure) {
        boolean newConnected;
        boolean oldConnected = this.mLastFailure == null;
        this.mLastFailure = inLastFailure;
        boolean bl = newConnected = this.mLastFailure == null;
        if (oldConnected != newConnected) {
            this.sendConnectedChanged(oldConnected, newConnected);
        }
    }

    private void sendConnectedChanged(boolean inOldStatus, boolean inNewStatus) {
        this.mAdapter.connectionStatusChanged(inOldStatus, inNewStatus);
    }
}

