/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.remote.emitter;

import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.MockLoginModule;
import org.marketcetera.client.MockServer;
import org.marketcetera.module.MockConfigProvider;
import org.marketcetera.module.ModuleConfigurationProvider;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleTestBase;
import org.marketcetera.modules.remote.receiver.ClientLoginModule;
import org.marketcetera.modules.remote.receiver.ReceiverFactory;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
public class RemoteEmitterTestBase
extends ModuleTestBase {
    protected ModuleManager mManager;
    protected static final String DEFAULT_CREDENTIAL = "why";
    protected static final String DEFAULT_URL = "tcp://localhost:61617";
    private static MockServer sServer;

    @After
    public void stopManager() throws Exception {
        if (this.mManager != null) {
            this.mManager.stop();
            this.mManager = null;
        }
    }

    @BeforeClass
    public static void setupClientAndServer() throws Exception {
        RemoteEmitterTestBase.setupConfiguration();
        sServer = new MockServer();
        ClientManager.init((ClientParameters)new ClientParameters(DEFAULT_CREDENTIAL, DEFAULT_CREDENTIAL.toCharArray(), "tcp://localhost:61616", "127.0.0.1", 9000));
    }

    @AfterClass
    public static void shutdownClientAndServer() throws Exception {
        if (ClientManager.isInitialized()) {
            ClientManager.getInstance().close();
        }
        if (sServer != null) {
            sServer.close();
            sServer = null;
        }
    }

    protected void initManager() throws Exception {
        this.initManager(this.configProviderWithURLValue(DEFAULT_URL));
    }

    protected MockConfigProvider configProviderWithURLValue(String inUrl) {
        MockConfigProvider prov = new MockConfigProvider();
        prov.addDefault(ReceiverFactory.INSTANCE_URN, "URL", inUrl);
        return prov;
    }

    private void initManager(MockConfigProvider inProvider) throws Exception {
        this.mManager = new ModuleManager();
        this.mManager.setConfigurationProvider((ModuleConfigurationProvider)inProvider);
        this.mManager.init();
    }

    private static void setupConfiguration() {
        Configuration.setConfiguration(new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String inName) {
                if ("remoting-amq-domain".equals(inName)) {
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(ClientLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.unmodifiableMap(new HashMap()))};
                }
                if ("test-amq-domain".equals(inName)) {
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(MockLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.unmodifiableMap(new HashMap()))};
                }
                return null;
            }
        });
    }
}

