/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.remote.emitter;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.AttributeChangeNotification;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import org.marketcetera.module.DataEmitter;
import org.marketcetera.module.DataEmitterSupport;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.Module;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleState;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.RequestDataException;
import org.marketcetera.module.RequestID;
import org.marketcetera.modules.remote.emitter.EmitterAdapter;
import org.marketcetera.modules.remote.emitter.EmitterModuleMXBean;
import org.marketcetera.modules.remote.emitter.Messages;
import org.marketcetera.modules.remote.emitter.RemoteDataEmitter;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id$")
class EmitterModule
extends Module
implements DataEmitter,
EmitterModuleMXBean,
NotificationEmitter,
EmitterAdapter {
    private volatile String mURL;
    private volatile String mUsername;
    private volatile String mPassword;
    private volatile RemoteDataEmitter mDataEmitter;
    private final AtomicLong mSequence = new AtomicLong();
    private final NotificationBroadcasterSupport mNotifySupport = new NotificationBroadcasterSupport(new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), Messages.ATTRIB_CHANGE_NOTIFICATION.getText()));
    private final Map<RequestID, DataEmitterSupport> mRequests = new ConcurrentHashMap<RequestID, DataEmitterSupport>();

    public void requestData(DataRequest inRequest, DataEmitterSupport inSupport) throws RequestDataException {
        this.mRequests.put(inSupport.getRequestID(), inSupport);
    }

    public void cancel(DataFlowID inFlowID, RequestID inRequestID) {
        this.mRequests.remove(inRequestID);
    }

    @Override
    public String getURL() {
        return this.mURL;
    }

    @Override
    public void setURL(String inURL) {
        this.failIfStarted(Messages.ILLEGAL_STATE_CHANGE_URL);
        this.mURL = inURL;
    }

    @Override
    public String getUsername() {
        return this.mUsername;
    }

    @Override
    public void setUsername(String inUsername) {
        this.failIfStarted(Messages.ILLEGAL_STATE_CHANGE_USERNAME);
        this.mUsername = inUsername;
    }

    @Override
    public void setPassword(String inPassword) {
        this.failIfStarted(Messages.ILLEGAL_STATE_CHANGE_PASSWORD);
        this.mPassword = inPassword;
    }

    @Override
    public boolean isConnected() {
        return this.getState().isStarted() && this.mDataEmitter != null && this.mDataEmitter.isConnected();
    }

    @Override
    public String getLastFailure() {
        if (this.mDataEmitter != null && this.mDataEmitter.getLastFailure() != null) {
            return this.mDataEmitter.getLastFailure().toString();
        }
        return null;
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.mNotifySupport.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.mNotifySupport.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.mNotifySupport.removeNotificationListener(listener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return this.mNotifySupport.getNotificationInfo();
    }

    protected EmitterModule(ModuleURN inURN) {
        super(inURN, true);
    }

    protected void preStart() throws ModuleException {
        String url = this.getURL();
        if (url == null) {
            throw new ModuleException((I18NBoundMessage)Messages.START_FAIL_NO_URL);
        }
        try {
            this.mDataEmitter = new RemoteDataEmitter(url, this.getUsername(), this.mPassword, this);
        }
        catch (Exception e) {
            throw new ModuleException((Throwable)e, (I18NBoundMessage)Messages.ERROR_STARTING_MODULE);
        }
    }

    protected void preStop() throws ModuleException {
        this.mDataEmitter.close();
        this.mDataEmitter = null;
    }

    @Override
    public void receiveData(Object inObject) {
        for (DataEmitterSupport support : this.mRequests.values()) {
            support.send(inObject);
        }
    }

    private void failIfStarted(I18NMessage0P inMessage) {
        if (this.getState().isStarted()) {
            throw new IllegalStateException(inMessage.getText());
        }
    }

    @Override
    public void connectionStatusChanged(boolean inOldValue, boolean inNewValue) {
        if (this.getState().isStarted() || this.getState() == ModuleState.STARTING || this.getState() == ModuleState.STOPPING) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Sending attrib changed from {} to {}", (Object[])new Object[]{inOldValue, inNewValue});
            this.mNotifySupport.sendNotification(new AttributeChangeNotification(this.getURN().toString(), this.mSequence.getAndIncrement(), System.currentTimeMillis(), Messages.ATTRIB_CHANGE_NOTIFICATION.getText(), "Connected", "boolean", inOldValue, inNewValue));
        }
    }
}

