/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.remote.receiver;

import com.sun.security.auth.UserPrincipal;
import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.ObjectUtils;
import org.apache.log4j.Level;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.core.LoggerConfiguration;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.modules.remote.receiver.ClientLoginHelper;
import org.marketcetera.modules.remote.receiver.ClientLoginModule;
import org.marketcetera.modules.remote.receiver.JaasConfiguration;
import org.marketcetera.modules.remote.receiver.Messages;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.misc.RandomStrings;
import org.marketcetera.util.test.TestCaseBase;

@ClassVersion(value="$Id: ClientLoginModuleTest.java 16154 2012-07-14 16:34:05Z colin $")
public class ClientLoginModuleTest
extends TestCaseBase {
    private static boolean doNotHandleCallbacks = false;
    private static IOException callbackException = null;
    private LoginContext loginContext;
    private static MockLoginHelper sMockHelper;

    @Test
    public void loginTest() throws Exception {
        ClientLoginModuleTest.setLevel((String)ClientLoginModule.class.getName(), (Level)Level.INFO);
        this.attemptLogin(null, ClientLoginModuleTest.getTestPassword(), AccountNotFoundException.class, Messages.EMPTY_USERNAME.getText());
        this.attemptLogin("", ClientLoginModuleTest.getTestPassword(), AccountNotFoundException.class, Messages.EMPTY_USERNAME.getText());
        String u = this.randomString();
        this.attemptLogin(u, ClientLoginModuleTest.getTestPassword(), FailedLoginException.class, Messages.USER_LOGIN_FAIL.getText((Object)u));
        this.assertLastEvent(Level.WARN, ClientLoginModule.class.getName(), Messages.USER_LOGIN_ERROR_LOG.getText((Object)u), ClientLoginModule.class.getName());
        this.attemptLogin(ClientLoginModuleTest.getTestUsername(), null, FailedLoginException.class, Messages.USER_LOGIN_FAIL.getText((Object)ClientLoginModuleTest.getTestUsername()));
        this.assertLastEvent(Level.WARN, ClientLoginModule.class.getName(), Messages.USER_LOGIN_ERROR_LOG.getText((Object)ClientLoginModuleTest.getTestUsername()), ClientLoginModule.class.getName());
        this.attemptLogin(ClientLoginModuleTest.getTestUsername(), "".toCharArray(), FailedLoginException.class, Messages.USER_LOGIN_FAIL.getText((Object)ClientLoginModuleTest.getTestUsername()));
        this.assertLastEvent(Level.WARN, ClientLoginModule.class.getName(), Messages.USER_LOGIN_ERROR_LOG.getText((Object)ClientLoginModuleTest.getTestUsername()), ClientLoginModule.class.getName());
        this.attemptLogin(ClientLoginModuleTest.getTestUsername(), this.randomString().toCharArray(), FailedLoginException.class, Messages.USER_LOGIN_FAIL.getText((Object)ClientLoginModuleTest.getTestUsername()));
        this.assertLastEvent(Level.WARN, ClientLoginModule.class.getName(), Messages.USER_LOGIN_ERROR_LOG.getText((Object)ClientLoginModuleTest.getTestUsername()), ClientLoginModule.class.getName());
        I18NMessage0P fail = new I18NMessage0P(Messages.LOGGER, "testMessage");
        sMockHelper.setFail((I18NBoundMessage)fail);
        this.attemptLogin(ClientLoginModuleTest.getTestUsername(), ClientLoginModuleTest.getTestPassword(), FailedLoginException.class, Messages.USER_LOGIN_ERROR.getText());
        this.assertLastEvent(Level.WARN, ClientLoginModule.class.getName(), Messages.USER_LOGIN_ERROR_LOG.getText((Object)ClientLoginModuleTest.getTestUsername()), ClientLoginModule.class.getName());
        sMockHelper.setFail(null);
        this.attemptLogin(ClientLoginModuleTest.getTestUsername(), ClientLoginModuleTest.getTestPassword(), null, null);
        this.assertLastEvent(Level.INFO, ClientLoginModule.class.getName(), Messages.USER_LOGIN_LOG.getText((Object)ClientLoginModuleTest.getTestUsername()), ClientLoginModule.class.getName());
        this.loginContext.logout();
        Assert.assertTrue((boolean)this.loginContext.getSubject().getPrincipals().isEmpty());
        this.assertLastEvent(Level.INFO, ClientLoginModule.class.getName(), Messages.USER_LOGOUT_LOG.getText((Object)ClientLoginModuleTest.getTestUsername()), ClientLoginModule.class.getName());
    }

    @Test
    public void unsupportedCallback() throws Exception {
        doNotHandleCallbacks = true;
        UnsupportedCallbackException uce = new UnsupportedCallbackException(new NameCallback(Messages.PROMPT_USERNAME.getText()));
        LoginException ex = this.attemptLogin(ClientLoginModuleTest.getTestUsername(), ClientLoginModuleTest.getTestPassword(), LoginException.class, uce.getMessage());
        Assert.assertNotNull((Object)ex.getCause());
        Assert.assertTrue((boolean)(ex.getCause() instanceof UnsupportedCallbackException));
        Callback callback = ((UnsupportedCallbackException)ex.getCause()).getCallback();
        Assert.assertNotNull((Object)callback);
        Assert.assertTrue((String)callback.getClass().toString(), (boolean)(callback instanceof NameCallback));
        Assert.assertEquals((Object)Messages.PROMPT_USERNAME.getText(), (Object)((NameCallback)callback).getPrompt());
    }

    @Test
    public void callbackIOFailure() throws Exception {
        callbackException = new IOException("ioeoeoe");
        LoginException ex = this.attemptLogin(ClientLoginModuleTest.getTestUsername(), ClientLoginModuleTest.getTestPassword(), LoginException.class, callbackException.getMessage());
        Assert.assertNotNull((Object)ex.getCause());
        Assert.assertTrue((boolean)(ex.getCause() instanceof IOException));
        Assert.assertSame((Object)callbackException, (Object)ex.getCause());
    }

    @Test
    public void nullHelperFail() throws Exception {
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                ClientLoginHelper.setCurrentHelper(null);
            }
        };
    }

    @BeforeClass
    public static void setup() throws Exception {
        LoggerConfiguration.logSetup();
        JaasConfiguration.setup();
        sMockHelper = new MockLoginHelper();
        ClientLoginHelper.setCurrentHelper((ClientLoginHelper)sMockHelper);
    }

    @AfterClass
    public static void cleanup() throws Exception {
        ClientLoginHelper.setCurrentHelper((ClientLoginHelper)ClientLoginHelper.DEFAULT_HELPER);
    }

    @After
    public void reset() throws Exception {
        doNotHandleCallbacks = false;
        callbackException = null;
        sMockHelper.setFail(null);
    }

    private static String getTestUsername() {
        return sMockHelper.getTestUsername();
    }

    private static char[] getTestPassword() {
        return sMockHelper.getTestPassword();
    }

    private String randomString() {
        return RandomStrings.genStrLetter();
    }

    private LoginException attemptLogin(String name, char[] password, Class<? extends LoginException> failure, String failureMsg) throws Exception {
        MockCallbackHandler ch = null;
        this.loginContext = null;
        try {
            ch = new MockCallbackHandler(name, password);
            this.loginContext = new LoginContext("remoting-amq-domain", ch);
            this.loginContext.login();
            Assert.assertNull((String)("Expected failure:" + failure + failureMsg), failure);
            Assert.assertTrue((String)this.loginContext.getSubject().getPrincipals().toString(), (boolean)this.loginContext.getSubject().getPrincipals().contains(new UserPrincipal(ClientLoginModuleTest.getTestUsername())));
        }
        catch (LoginException e) {
            Assert.assertNotNull((String)("Unexpected failure:" + e), failure);
            Assert.assertTrue((String)("Expected:" + failure + ":Actual:" + e.getClass().getName() + e.toString()), (boolean)failure.isInstance(e));
            if (failureMsg != null) {
                Assert.assertEquals((Object)failureMsg, (Object)e.getMessage());
            }
            Assert.assertNotNull((Object)this.loginContext);
            if (this.loginContext.getSubject() != null && this.loginContext.getSubject().getPrincipals() != null) {
                Assert.assertFalse((String)this.loginContext.getSubject().getPrincipals().toString(), (boolean)this.loginContext.getSubject().getPrincipals().contains(new UserPrincipal(ClientLoginModuleTest.getTestUsername())));
            }
            Assert.assertEquals((long)2L, (long)ch.getNumCallbacks());
            if (callbackException == null && !doNotHandleCallbacks) {
                Assert.assertEquals((Object)Messages.PROMPT_USERNAME.getText(), (Object)ch.getNamePrompt());
                Assert.assertEquals((Object)Messages.PROMPT_PASSWORD.getText(), (Object)ch.getPasswordPrompt());
                Assert.assertNull((Object)ch.getDefaultName());
            }
            return e;
        }
        return null;
    }

    private static class MockCallbackHandler
    implements CallbackHandler {
        private int numCallbacks;
        private String namePrompt;
        private String defaultName;
        private String nameValue;
        private String passwordPrompt;
        private char[] passwordValue;

        MockCallbackHandler(String nameValue, char[] passwordValue) {
            this.nameValue = nameValue;
            this.passwordValue = passwordValue;
        }

        public String getNamePrompt() {
            return this.namePrompt;
        }

        public String getPasswordPrompt() {
            return this.passwordPrompt;
        }

        public String getDefaultName() {
            return this.defaultName;
        }

        public int getNumCallbacks() {
            return this.numCallbacks;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks == null) {
                return;
            }
            this.numCallbacks = callbacks.length;
            for (Callback c : callbacks) {
                if (doNotHandleCallbacks) {
                    throw new UnsupportedCallbackException(c);
                }
                if (callbackException != null) {
                    throw callbackException;
                }
                if (c instanceof NameCallback) {
                    NameCallback nc = (NameCallback)c;
                    this.namePrompt = nc.getPrompt();
                    this.defaultName = nc.getName();
                    nc.setName(this.nameValue);
                    continue;
                }
                if (c instanceof PasswordCallback) {
                    PasswordCallback pc = (PasswordCallback)c;
                    this.passwordPrompt = pc.getPrompt();
                    pc.setPassword(this.passwordValue);
                    continue;
                }
                throw new UnsupportedCallbackException(c);
            }
        }
    }

    private static class MockLoginHelper
    extends ClientLoginHelper {
        private I18NBoundMessage mFail = null;
        private final String mUsername = "testuser";
        private final char[] mPassword = "testpassword".toCharArray();

        private MockLoginHelper() {
        }

        protected boolean validateCredentials(String inUsername, char[] inPassword) throws ClientInitException {
            if (this.mFail != null) {
                throw new ClientInitException(this.mFail);
            }
            return ObjectUtils.equals((Object)inUsername, (Object)"testuser") && Arrays.equals(inPassword, this.mPassword);
        }

        public String getTestUsername() {
            return "testuser";
        }

        public char[] getTestPassword() {
            return this.mPassword;
        }

        public void setFail(I18NBoundMessage inFailMessage) {
            this.mFail = inFailMessage;
        }
    }
}

