/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.remote.receiver;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import javax.management.JMX;
import javax.management.MBeanInfo;
import javax.security.auth.login.Configuration;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.event.LogEventLevel;
import org.marketcetera.module.CopierModule;
import org.marketcetera.module.CopierModuleFactory;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataFlowInfo;
import org.marketcetera.module.DataFlowStep;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.MockConfigProvider;
import org.marketcetera.module.ModuleConfigurationProvider;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.module.ModuleState;
import org.marketcetera.module.ModuleTestBase;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.modules.remote.receiver.Messages;
import org.marketcetera.modules.remote.receiver.ReceiverFactory;
import org.marketcetera.modules.remote.receiver.ReceiverModule;
import org.marketcetera.modules.remote.receiver.ReceiverModuleMXBean;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.test.LogTestAssist;

@ClassVersion(value="$Id: ReceiverTest.java 16154 2012-07-14 16:34:05Z colin $")
public class ReceiverTest
extends ModuleTestBase {
    private ModuleManager mManager;
    private final LogTestAssist mLogAssist = new LogTestAssist(ReceiverModule.class.getName(), Level.INFO);
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 61617;
    private static final String DEFAULT_URL = "tcp://localhost:61617";

    @Test
    public void info() throws Exception {
        this.initManager();
        ReceiverTest.assertProviderInfo((ModuleManager)this.mManager, (ModuleURN)ReceiverFactory.PROVIDER_URN, (String[])new String[0], (Class[])new Class[0], (String)Messages.PROVIDER_DESCRIPTION.getText(), (boolean)false, (boolean)false);
        ReceiverTest.assertModuleInfo((ModuleManager)this.mManager, (ModuleURN)ReceiverFactory.INSTANCE_URN, (ModuleState)ModuleState.STARTED, null, null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
    }

    @Test
    public void noURL() throws Exception {
        this.initManager(new MockConfigProvider());
        this.verifyDataFlow();
        this.verifyNoConnectToReceiver();
        this.mLogAssist.assertSomeEvent(Level.INFO, null, Messages.NO_URL_SPECIFIED_LOG.getText(), null);
    }

    @Test
    public void initFailures() throws Exception {
        new ExpectedFailure<ModuleException>((I18NBoundMessage)Messages.ERROR_STARTING_MODULE){

            protected void run() throws Exception {
                ReceiverTest.this.initManager(ReceiverTest.this.configProviderWithURLValue("this is not a valid URL"));
            }
        };
        this.verifyNoConnectToReceiver();
        this.info();
        this.verifyConnectToReceiver();
        this.mLogAssist.assertSomeEvent(Level.INFO, null, Messages.RECIEVER_REMOTING_CONFIGURED.getText((Object)DEFAULT_URL), null);
    }

    @Test
    public void dataFlowSuccess() throws Exception {
        this.verifyNoConnectToReceiver();
        this.initManager();
        this.verifyDataFlow();
        this.verifyConnectToReceiver();
    }

    @Test
    public void dataFlowFailures() throws Exception {
        this.initManager();
        Object[] objs = new Object[]{Integer.MAX_VALUE, null, Arrays.asList(BigInteger.TEN), new Object(), BigDecimal.TEN, Arrays.asList(new Object())};
        CopierModule.SynchronousRequest req = new CopierModule.SynchronousRequest((Object)objs);
        req.semaphore.acquire();
        DataFlowID flowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)req), new DataRequest(ReceiverFactory.PROVIDER_URN)});
        req.semaphore.acquire();
        DataFlowInfo flowInfo = this.mManager.getDataFlowInfo(flowID);
        ReceiverTest.assertFlowInfo((DataFlowInfo)flowInfo, (DataFlowID)flowID, (int)2, (boolean)true, (boolean)false, null, null);
        ReceiverTest.assertFlowStep((DataFlowStep)flowInfo.getFlowSteps()[0], (ModuleURN)CopierModuleFactory.INSTANCE_URN, (boolean)true, (int)6, (int)0, null, (boolean)false, (int)0, (int)0, null, (ModuleURN)CopierModuleFactory.INSTANCE_URN, (Object)req.toString());
        ReceiverTest.assertFlowStep((DataFlowStep)flowInfo.getFlowSteps()[1], (ModuleURN)ReceiverFactory.INSTANCE_URN, (boolean)false, (int)0, (int)0, null, (boolean)true, (int)6, (int)2, (String)Messages.ERROR_WHEN_TRANSMITTING.getText((Object)String.valueOf(objs[objs.length - 1])), (ModuleURN)ReceiverFactory.PROVIDER_URN, null);
    }

    @Test
    public void jmx() throws Exception {
        this.initManager();
        ReceiverTest.verifyBeanInfo((MBeanInfo)ReceiverTest.getMBeanServer().getMBeanInfo(ReceiverFactory.INSTANCE_URN.toObjectName()));
        final ReceiverModuleMXBean bean = JMX.newMXBeanProxy(ReceiverTest.getMBeanServer(), ReceiverFactory.INSTANCE_URN.toObjectName(), ReceiverModuleMXBean.class);
        Assert.assertEquals((Object)DEFAULT_URL, (Object)bean.getURL());
        Assert.assertEquals((Object)false, (Object)bean.isSkipJAASConfiguration());
        this.assertLogLevel(bean, LogEventLevel.WARN);
        new ExpectedFailure<IllegalStateException>(Messages.ILLEGAL_STATE_SET_URL.getText()){

            protected void run() throws Exception {
                bean.setURL("blah");
            }
        };
        new ExpectedFailure<IllegalArgumentException>(Messages.ILLEGAL_STATE_SET_SKIP_JAAS.getText()){

            protected void run() throws Exception {
                bean.setSkipJAASConfiguration(true);
            }
        };
        LogEventLevel logLevel = LogEventLevel.INFO;
        bean.setLogLevel(logLevel);
        this.assertLogLevel(bean, logLevel);
        this.mManager.stop(ReceiverFactory.INSTANCE_URN);
        Assert.assertEquals((Object)DEFAULT_URL, (Object)bean.getURL());
        this.assertLogLevel(bean, logLevel);
        String url = "myURL";
        bean.setURL(url);
        Assert.assertEquals((Object)url, (Object)bean.getURL());
        bean.setURL(null);
        Assert.assertEquals(null, (Object)bean.getURL());
        this.verifyLogLevels(bean);
        logLevel = LogEventLevel.ERROR;
        bean.setLogLevel(logLevel);
        this.assertLogLevel(bean, logLevel);
        new ExpectedFailure<IllegalArgumentException>(Messages.NULL_LEVEL_VALUE.getText(EnumSet.allOf(LogEventLevel.class))){

            protected void run() throws Exception {
                bean.setLogLevel(null);
            }
        };
        new ExpectedFailure<IllegalArgumentException>(Messages.ILLEGAL_STATE_SET_SKIP_JAAS.getText()){

            protected void run() throws Exception {
                bean.setSkipJAASConfiguration(true);
            }
        };
        bean.setURL("invalidURL");
        new ExpectedFailure<ModuleException>((I18NBoundMessage)Messages.ERROR_STARTING_MODULE){

            protected void run() throws Exception {
                ReceiverTest.this.mManager.start(ReceiverFactory.INSTANCE_URN);
            }
        };
        ReceiverTest.assertModuleInfo((ModuleManager)this.mManager, (ModuleURN)ReceiverFactory.INSTANCE_URN, (ModuleState)ModuleState.START_FAILED, null, null, (boolean)false, (boolean)true, (boolean)true, (boolean)false, (boolean)false);
        bean.setURL(DEFAULT_URL);
        this.mManager.start(ReceiverFactory.INSTANCE_URN);
    }

    @Test(timeout=10000L)
    public void skipJaasConfig() throws Exception {
        MockConfigProvider prov = this.configProviderWithURLValue(DEFAULT_URL);
        prov.addDefault(ReceiverFactory.INSTANCE_URN, "SkipJAASConfiguration", "true");
        this.initManager(prov);
        ReceiverModuleMXBean bean = JMX.newMXBeanProxy(ReceiverTest.getMBeanServer(), ReceiverFactory.INSTANCE_URN.toObjectName(), ReceiverModuleMXBean.class);
        Assert.assertEquals((Object)true, (Object)bean.isSkipJAASConfiguration());
        int data = Integer.MAX_VALUE;
        DataFlowID flowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)new Object[]{Integer.MAX_VALUE}), new DataRequest(ReceiverFactory.PROVIDER_URN)});
        DataFlowInfo flowInfo = this.mManager.getDataFlowInfo(flowID);
        ReceiverTest.assertFlowInfo((DataFlowInfo)flowInfo, (DataFlowID)flowID, (int)2, (boolean)true, (boolean)false, null, null);
        Assert.assertEquals((long)2L, (long)flowInfo.getFlowSteps().length);
        while (flowInfo.getFlowSteps()[1].getLastReceiveError() == null) {
            Thread.sleep(100L);
            flowInfo = this.mManager.getDataFlowInfo(flowID);
        }
        ReceiverTest.assertFlowStep((DataFlowStep)flowInfo.getFlowSteps()[1], (ModuleURN)ReceiverFactory.INSTANCE_URN, (boolean)false, (int)0, (int)0, null, (boolean)true, (int)1, (int)1, (String)Messages.ERROR_WHEN_TRANSMITTING.getText((Object)String.valueOf(Integer.MAX_VALUE)), (ModuleURN)ReceiverFactory.PROVIDER_URN, null);
        this.mManager.cancel(flowID);
    }

    @Test
    public void specifyDefaultLogLevel() throws Exception {
        MockConfigProvider prov = this.configProviderWithURLValue(DEFAULT_URL);
        prov.addDefault(ReceiverFactory.INSTANCE_URN, "LogLevel", "DEBUG");
        this.initManager(prov);
        ReceiverModuleMXBean bean = JMX.newMXBeanProxy(ReceiverTest.getMBeanServer(), ReceiverFactory.INSTANCE_URN.toObjectName(), ReceiverModuleMXBean.class);
        this.assertLogLevel(bean, LogEventLevel.DEBUG);
    }

    @After
    public void stopManager() throws Exception {
        if (this.mManager != null) {
            this.mManager.stop();
            this.mManager = null;
        }
        this.mLogAssist.resetAppender();
    }

    @Before
    public void resetJAASConfig() {
        Configuration.setConfiguration(null);
    }

    private void verifyConnectToReceiver() throws IOException {
        new Socket(DEFAULT_HOST, 61617).close();
    }

    private void verifyNoConnectToReceiver() throws Exception {
        new ExpectedFailure<ConnectException>(){

            protected void run() throws Exception {
                ReceiverTest.this.verifyConnectToReceiver();
            }
        };
    }

    private void verifyDataFlow() throws Exception {
        Object[] objs = new Object[]{Integer.MAX_VALUE, BigInteger.TEN, BigDecimal.TEN, new LinkedList(), new HashMap()};
        CopierModule.SynchronousRequest req = new CopierModule.SynchronousRequest((Object)objs);
        req.semaphore.acquire();
        DataFlowID flowID = this.mManager.createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)req), new DataRequest(ReceiverFactory.PROVIDER_URN)});
        req.semaphore.acquire();
        DataFlowInfo flowInfo = this.mManager.getDataFlowInfo(flowID);
        ReceiverTest.assertFlowInfo((DataFlowInfo)flowInfo, (DataFlowID)flowID, (int)2, (boolean)true, (boolean)false, null, null);
        ReceiverTest.assertFlowStep((DataFlowStep)flowInfo.getFlowSteps()[0], (ModuleURN)CopierModuleFactory.INSTANCE_URN, (boolean)true, (int)5, (int)0, null, (boolean)false, (int)0, (int)0, null, (ModuleURN)CopierModuleFactory.INSTANCE_URN, (Object)req.toString());
        ReceiverTest.assertFlowStep((DataFlowStep)flowInfo.getFlowSteps()[1], (ModuleURN)ReceiverFactory.INSTANCE_URN, (boolean)false, (int)0, (int)0, null, (boolean)true, (int)5, (int)0, null, (ModuleURN)ReceiverFactory.PROVIDER_URN, null);
    }

    private void verifyLogLevels(ReceiverModuleMXBean inBean) {
        for (LogEventLevel level : LogEventLevel.values()) {
            inBean.setLogLevel(level);
            this.assertLogLevel(inBean, level);
        }
    }

    private void assertLogLevel(ReceiverModuleMXBean inMBean, LogEventLevel inLogLevel) {
        Assert.assertEquals((Object)inLogLevel, (Object)inMBean.getLogLevel());
        Level level = LogManager.getLogger((String)"user.messages").getLevel();
        Assert.assertNotNull((Object)level);
        Assert.assertEquals((Object)inLogLevel.toString(), (Object)level.toString());
    }

    private void initManager() throws Exception {
        MockConfigProvider prov = this.configProviderWithURLValue(DEFAULT_URL);
        this.initManager(prov);
    }

    private void initManager(MockConfigProvider inProvider) throws Exception {
        this.mManager = new ModuleManager();
        this.mManager.setConfigurationProvider((ModuleConfigurationProvider)inProvider);
        this.mManager.init();
    }

    private MockConfigProvider configProviderWithURLValue(String inUrl) {
        MockConfigProvider prov = new MockConfigProvider();
        prov.addDefault(ReceiverFactory.INSTANCE_URN, "URL", inUrl);
        return prov;
    }
}

