/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.remote.receiver;

import java.util.Arrays;
import java.util.UUID;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.client.ClientManager;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: ClientLoginHelper.java 16154 2012-07-14 16:34:05Z colin $")
abstract class ClientLoginHelper {
    static final ClientLoginHelper DEFAULT_HELPER;
    private static ClientLoginHelper mCurrentHelper;
    private static String sUsername;
    private static String sPassword;

    ClientLoginHelper() {
    }

    public static boolean isValidCredentials(String inUsername, char[] inPassword) throws ClientInitException {
        return ClientLoginHelper.getUserName().equals(inUsername) && Arrays.equals(ClientLoginHelper.getPassword().toCharArray(), inPassword) || mCurrentHelper.validateCredentials(inUsername, inPassword);
    }

    static String getUserName() {
        return sUsername;
    }

    static String getPassword() {
        return sPassword;
    }

    static void setCurrentHelper(ClientLoginHelper inHelper) {
        if (inHelper == null) {
            throw new NullPointerException();
        }
        mCurrentHelper = inHelper;
    }

    protected abstract boolean validateCredentials(String var1, char[] var2) throws ClientInitException;

    static {
        mCurrentHelper = DEFAULT_HELPER = new DefaultHelper();
        sUsername = "internal-" + UUID.randomUUID().toString();
        sPassword = UUID.randomUUID().toString();
    }

    private static class DefaultHelper
    extends ClientLoginHelper {
        private DefaultHelper() {
        }

        @Override
        protected boolean validateCredentials(String inUsername, char[] inPassword) throws ClientInitException {
            return ClientManager.getInstance().isCredentialsMatch(inUsername, inPassword);
        }
    }
}

