/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.remote.receiver;

import com.sun.security.auth.UserPrincipal;
import java.io.IOException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AccountNotFoundException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.marketcetera.client.ClientInitException;
import org.marketcetera.core.ClassVersion;
import org.marketcetera.modules.remote.receiver.ClientLoginHelper;
import org.marketcetera.modules.remote.receiver.Messages;
import org.marketcetera.util.log.SLF4JLoggerProxy;

@ClassVersion(value="$Id: ClientLoginModule.java 16154 2012-07-14 16:34:05Z colin $")
public class ClientLoginModule
implements LoginModule {
    private Subject mSubject;
    private CallbackHandler mCallback;
    private Set<Principal> mPrincipals = new HashSet<Principal>();
    private String mUsername;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.mSubject = subject;
        this.mCallback = callbackHandler;
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback(Messages.PROMPT_USERNAME.getText()), new PasswordCallback(Messages.PROMPT_PASSWORD.getText(), false)};
        try {
            this.mCallback.handle(callbacks);
        }
        catch (UnsupportedCallbackException e) {
            FailedLoginException ex = new FailedLoginException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        catch (IOException e) {
            FailedLoginException ex = new FailedLoginException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
        this.mUsername = ((NameCallback)callbacks[0]).getName();
        if (this.mUsername == null || this.mUsername.trim().length() == 0) {
            throw new AccountNotFoundException(Messages.EMPTY_USERNAME.getText());
        }
        char[] password = ((PasswordCallback)callbacks[1]).getPassword();
        try {
            if (!ClientLoginHelper.isValidCredentials(this.mUsername, password)) {
                Messages.USER_LOGIN_ERROR_LOG.warn((Object)this, (Object)this.mUsername);
                throw new FailedLoginException(Messages.USER_LOGIN_FAIL.getText((Object)this.mUsername));
            }
        }
        catch (ClientInitException e) {
            Messages.USER_LOGIN_ERROR_LOG.warn((Object)this, (Throwable)e, (Object)this.mUsername);
            FailedLoginException exception = new FailedLoginException(Messages.USER_LOGIN_ERROR.getText());
            exception.initCause(e);
            throw exception;
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"login done for user {}", (Object[])new Object[]{this.mUsername});
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.mPrincipals.add(new UserPrincipal(this.mUsername));
        this.mSubject.getPrincipals().addAll(this.mPrincipals);
        Messages.USER_LOGIN_LOG.info((Object)this, (Object)this.mUsername);
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        SLF4JLoggerProxy.debug((Object)this, (String)"Aborting login for user {}", (Object[])new Object[]{this.mUsername});
        this.clear();
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.mSubject.getPrincipals().removeAll(this.mPrincipals);
        this.mPrincipals.clear();
        Messages.USER_LOGOUT_LOG.info((Object)this, (Object)this.mUsername);
        this.clear();
        return true;
    }

    private void clear() {
        this.mUsername = null;
    }
}

