/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.modules.remote.receiver;

import java.io.Serializable;
import java.util.EnumSet;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.marketcetera.event.LogEvent;
import org.marketcetera.event.LogEventLevel;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataReceiver;
import org.marketcetera.module.Module;
import org.marketcetera.module.ModuleException;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.module.ReceiveDataException;
import org.marketcetera.modules.remote.receiver.ClientLoginHelper;
import org.marketcetera.modules.remote.receiver.JaasConfiguration;
import org.marketcetera.modules.remote.receiver.Messages;
import org.marketcetera.modules.remote.receiver.ReceiverModuleMXBean;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.spring.SpringUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.context.support.StaticApplicationContext;
import org.springframework.jms.JmsException;
import org.springframework.jms.core.JmsTemplate;

@ClassVersion(value="$Id: ReceiverModule.java 16154 2012-07-14 16:34:05Z colin $")
public class ReceiverModule
extends Module
implements DataReceiver,
ReceiverModuleMXBean {
    private volatile String mURL;
    private volatile ClassPathXmlApplicationContext mContext;
    private volatile JmsTemplate mSender;
    private volatile LogEventLevel mLogLevel;
    private volatile boolean mSkipJAASConfiguration = false;
    private volatile boolean mDoneJaasConfiguration;

    ReceiverModule(ModuleURN inURN) {
        super(inURN, true);
        this.setLogLevel(LogEventLevel.WARN);
    }

    protected void preStart() throws ModuleException {
        String url = this.getURL();
        if (url == null || url.trim().isEmpty()) {
            Messages.NO_URL_SPECIFIED_LOG.info((Object)this);
            return;
        }
        if (!this.mSkipJAASConfiguration) {
            JaasConfiguration.setup();
            this.mDoneJaasConfiguration = true;
        }
        try {
            StaticApplicationContext parent = new StaticApplicationContext();
            SpringUtils.addStringBean((GenericApplicationContext)parent, (String)"brokerURI", (String)url);
            SpringUtils.addStringBean((GenericApplicationContext)parent, (String)"userName", (String)ClientLoginHelper.getUserName());
            SpringUtils.addStringBean((GenericApplicationContext)parent, (String)"password", (String)ClientLoginHelper.getPassword());
            parent.refresh();
            this.mContext = new ClassPathXmlApplicationContext(new String[]{"remoting_server.xml"}, (ApplicationContext)parent);
            this.mContext.start();
            this.mSender = (JmsTemplate)this.mContext.getBean("sender", JmsTemplate.class);
            Messages.RECIEVER_REMOTING_CONFIGURED.info((Object)this, (Object)url);
        }
        catch (Exception e) {
            throw new ModuleException((Throwable)e, (I18NBoundMessage)Messages.ERROR_STARTING_MODULE);
        }
    }

    protected void preStop() throws ModuleException {
        if (this.mContext != null) {
            try {
                this.mContext.close();
                this.mContext = null;
            }
            catch (Exception e) {
                Messages.ERROR_STOPPING_MODULE_LOG.warn((Object)this, (Throwable)e);
            }
        }
        this.mSender = null;
    }

    public void receiveData(DataFlowID inFlowID, Object inData) throws ReceiveDataException {
        if (this.mSender != null && inData != null) {
            if (inData instanceof LogEvent && ((LogEvent)inData).getLevel().ordinal() < this.mLogLevel.ordinal()) {
                return;
            }
            try {
                this.mSender.convertAndSend(inData);
            }
            catch (JmsException e) {
                throw new ReceiveDataException((Throwable)e, (I18NBoundMessage)new I18NBoundMessage1P(Messages.ERROR_WHEN_TRANSMITTING, (Serializable)((Object)String.valueOf(inData))));
            }
        }
    }

    @Override
    public String getURL() {
        return this.mURL;
    }

    @Override
    public void setURL(String inURL) {
        this.failIfStarted(Messages.ILLEGAL_STATE_SET_URL);
        this.mURL = inURL;
    }

    @Override
    public LogEventLevel getLogLevel() {
        return this.mLogLevel;
    }

    @Override
    public void setLogLevel(LogEventLevel inLevel) {
        if (inLevel == null) {
            throw new IllegalArgumentException(Messages.NULL_LEVEL_VALUE.getText(EnumSet.allOf(LogEventLevel.class)));
        }
        this.getLogger().setLevel(Level.toLevel((String)inLevel.name(), null));
        this.mLogLevel = inLevel;
    }

    @Override
    public boolean isSkipJAASConfiguration() {
        return this.mSkipJAASConfiguration;
    }

    @Override
    public void setSkipJAASConfiguration(boolean inSkipJAASConfiguration) {
        if (this.mDoneJaasConfiguration) {
            throw new IllegalArgumentException(Messages.ILLEGAL_STATE_SET_SKIP_JAAS.getText());
        }
        this.mSkipJAASConfiguration = inSkipJAASConfiguration;
    }

    private Logger getLogger() {
        return LogManager.getLogger((String)"user.messages");
    }

    private void failIfStarted(I18NMessage0P inMessage) {
        if (this.getState().isStarted()) {
            throw new IllegalStateException(inMessage.getText());
        }
    }
}

