/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.util.Collections;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.client.ClientManager;
import org.marketcetera.client.ClientParameters;
import org.marketcetera.client.MockLoginModule;
import org.marketcetera.client.MockServer;
import org.marketcetera.module.MockConfigProvider;
import org.marketcetera.module.ModuleConfigurationProvider;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.modules.remote.receiver.ClientLoginModule;
import org.marketcetera.modules.remote.receiver.ReceiverFactory;
import org.marketcetera.saclient.ConnectionException;
import org.marketcetera.saclient.MockSAServiceImpl;
import org.marketcetera.saclient.MockSessionFactory;
import org.marketcetera.saclient.SAClient;
import org.marketcetera.saclient.SAClientFactory;
import org.marketcetera.saclient.SAClientParameters;
import org.marketcetera.saclient.SAService;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateful.Server;
import org.marketcetera.util.ws.stateful.SessionFactory;
import org.marketcetera.util.ws.stateful.SessionManager;
import org.marketcetera.util.ws.stateless.ServiceInterface;
import org.marketcetera.util.ws.stateless.StatelessClientContext;
import org.marketcetera.util.ws.stateless.StatelessServiceBase;

@ClassVersion(value="$Id: MockStrategyAgent.java 16154 2012-07-14 16:34:05Z colin $")
class MockStrategyAgent {
    public static final String WS_HOSTNAME = "localhost";
    public static final int WS_PORT = 9001;
    public static final String DEFAULT_URL = "tcp://localhost:61617";
    static final String USER_CREDS = "blue";
    static final SAClientParameters DEFAULT_PARAMETERS = new SAClientParameters("blue", "blue".toCharArray(), "tcp://localhost:61617", "localhost", 9001);
    private static volatile MockServer sMockServer;
    private volatile Server<Object> mServer;
    private volatile ModuleManager mManager = new ModuleManager();
    private volatile ServiceInterface mRemoteService;
    private final MockSAServiceImpl mService;
    private static Class<?>[] contextClasses;

    MockStrategyAgent() throws Exception {
        MockConfigProvider provider = new MockConfigProvider();
        provider.addDefault(ReceiverFactory.INSTANCE_URN, "URL", DEFAULT_URL);
        provider.addDefault(ReceiverFactory.INSTANCE_URN, "SkipJAASConfiguration", String.valueOf(true));
        this.mManager.setConfigurationProvider((ModuleConfigurationProvider)provider);
        this.mManager.init();
        SessionManager sessionManager = new SessionManager((SessionFactory)new MockSessionFactory(), -1L);
        this.mServer = new Server(WS_HOSTNAME, 9001, new Authenticator(){

            public boolean shouldAllow(StatelessClientContext context, String user, char[] password) throws I18NException {
                return ObjectUtils.equals((Object)user, (Object)String.valueOf(password));
            }
        }, sessionManager, (Class[])contextClasses);
        this.mService = new MockSAServiceImpl((SessionManager<Object>)sessionManager);
        this.mRemoteService = this.mServer.publish((StatelessServiceBase)this.mService, SAService.class);
    }

    public static Class<?>[] getContextClasses() {
        return contextClasses;
    }

    public static void setContextClasses(Class<?> ... inContextClasses) {
        contextClasses = inContextClasses;
    }

    ModuleManager getManager() {
        return this.mManager;
    }

    void close() throws Exception {
        this.mManager.stop();
        if (this.mRemoteService != null) {
            this.mRemoteService.stop();
        }
        this.mServer.stop();
    }

    MockSAServiceImpl getService() {
        return this.mService;
    }

    static void startServerAndClient() throws Exception {
        MockStrategyAgent.setupConfiguration();
        sMockServer = new MockServer();
        ClientManager.init((ClientParameters)new ClientParameters(USER_CREDS, USER_CREDS.toCharArray(), "tcp://localhost:61616", WS_HOSTNAME, 9000));
    }

    static void closeServerAndClient() throws Exception {
        if (ClientManager.isInitialized()) {
            ClientManager.getInstance().close();
        }
        if (sMockServer != null) {
            sMockServer.close();
            sMockServer = null;
        }
    }

    static SAClient connectTo() throws ConnectionException {
        return MockStrategyAgent.connectTo(DEFAULT_PARAMETERS);
    }

    static SAClient connectTo(SAClientParameters inParameters) throws ConnectionException {
        return SAClientFactory.getInstance().create(inParameters);
    }

    private static void setupConfiguration() {
        Configuration.setConfiguration(new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String inName) {
                if ("remoting-amq-domain".equals(inName)) {
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(ClientLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.unmodifiableMap(new HashMap()))};
                }
                if ("test-amq-domain".equals(inName)) {
                    return new AppConfigurationEntry[]{new AppConfigurationEntry(MockLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Collections.unmodifiableMap(new HashMap()))};
                }
                return null;
            }
        });
    }
}

