/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlMimeType;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: CreateStrategyParameters.java 16154 2012-07-14 16:34:05Z colin $")
@XmlAccessorType(value=XmlAccessType.FIELD)
public final class CreateStrategyParameters
implements Serializable {
    private final String mInstanceName;
    private final String mStrategyName;
    private final String mLanguage;
    private final String mParameters;
    private final boolean mRouteOrdersToServer;
    @XmlMimeType(value="application/octet-stream")
    private final DataHandler mStrategySource;
    private static final long serialVersionUID = 1L;

    public CreateStrategyParameters(String inInstanceName, String inStrategyName, String inLanguage, File inStrategySource, String inParameters, boolean inRouteOrdersToServer) throws FileNotFoundException {
        if (inStrategyName == null) {
            throw new NullPointerException();
        }
        if (inLanguage == null) {
            throw new NullPointerException();
        }
        if (inStrategySource == null) {
            throw new NullPointerException();
        }
        if (!inStrategySource.isFile() || !inStrategySource.canRead()) {
            throw new FileNotFoundException(inStrategySource.getAbsolutePath());
        }
        this.mInstanceName = inInstanceName;
        this.mStrategyName = inStrategyName;
        this.mLanguage = inLanguage;
        this.mStrategySource = new DataHandler((DataSource)new FileDataSource(inStrategySource));
        this.mParameters = inParameters;
        this.mRouteOrdersToServer = inRouteOrdersToServer;
    }

    public String getInstanceName() {
        return this.mInstanceName;
    }

    public String getStrategyName() {
        return this.mStrategyName;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public InputStream getStrategySource() throws IOException {
        return this.mStrategySource.getInputStream();
    }

    public String getParameters() {
        return this.mParameters;
    }

    public boolean isRouteOrdersToServer() {
        return this.mRouteOrdersToServer;
    }

    private CreateStrategyParameters() {
        this.mInstanceName = null;
        this.mStrategyName = null;
        this.mLanguage = null;
        this.mStrategySource = null;
        this.mParameters = null;
        this.mRouteOrdersToServer = false;
    }
}

