/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.marketcetera.module.ModuleInfo;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.modules.remote.emitter.EmitterAdapter;
import org.marketcetera.modules.remote.emitter.RemoteDataEmitter;
import org.marketcetera.saclient.ConnectionException;
import org.marketcetera.saclient.ConnectionStatusListener;
import org.marketcetera.saclient.CreateStrategyParameters;
import org.marketcetera.saclient.DataReceiver;
import org.marketcetera.saclient.Messages;
import org.marketcetera.saclient.SAClient;
import org.marketcetera.saclient.SAClientParameters;
import org.marketcetera.saclient.SAClientVersion;
import org.marketcetera.saclient.SAService;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.Client;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.wrappers.MapWrapper;
import org.marketcetera.util.ws.wrappers.RemoteException;

@ClassVersion(value="$Id: SAClientImpl.java 16154 2012-07-14 16:34:05Z colin $")
class SAClientImpl
implements SAClient,
EmitterAdapter {
    private final Deque<DataReceiver> mReceivers = new LinkedList<DataReceiver>();
    private final Deque<ConnectionStatusListener> mListeners = new LinkedList<ConnectionStatusListener>();
    private final Client mServiceClient;
    private final RemoteDataEmitter mEmitter;
    private final SAService mSAService;
    private final SAClientParameters mParameters;
    private volatile boolean mClosed = false;
    private volatile boolean mConnected;

    @Override
    public List<ModuleURN> getProviders() throws ConnectionException {
        this.failIfDisconnected();
        try {
            ArrayList list = this.mSAService.getProviders(this.getServiceContext());
            return list != null ? list : new ArrayList();
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public List<ModuleURN> getInstances(ModuleURN inProviderURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            ArrayList list = this.mSAService.getInstances(this.getServiceContext(), inProviderURN);
            return list != null ? list : new ArrayList();
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public ModuleInfo getModuleInfo(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            return this.mSAService.getModuleInfo(this.getServiceContext(), inURN);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public void start(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            this.mSAService.start(this.getServiceContext(), inURN);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public void stop(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            this.mSAService.stop(this.getServiceContext(), inURN);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public void delete(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            this.mSAService.delete(this.getServiceContext(), inURN);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public Map<String, Object> getProperties(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            MapWrapper<String, Object> value = this.mSAService.getProperties(this.getServiceContext(), inURN);
            return value == null ? null : value.getMap();
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public Map<String, Object> setProperties(ModuleURN inURN, Map<String, Object> inProperties) throws ConnectionException {
        this.failIfDisconnected();
        try {
            MapWrapper<String, Object> map = this.mSAService.setProperties(this.getServiceContext(), inURN, (MapWrapper<String, Object>)new MapWrapper(inProperties));
            return map == null ? null : map.getMap();
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public ModuleURN createStrategy(CreateStrategyParameters inParameters) throws ConnectionException {
        this.failIfDisconnected();
        try {
            return this.mSAService.createStrategy(this.getServiceContext(), inParameters);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public CreateStrategyParameters getStrategyCreateParms(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            return this.mSAService.getStrategyCreateParms(this.getServiceContext(), inURN);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public void sendData(Object inData) throws ConnectionException {
        this.failIfDisconnected();
        try {
            this.mSAService.sendData(this.getServiceContext(), inData);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataReceiver(DataReceiver inReceiver) {
        if (inReceiver == null) {
            throw new NullPointerException();
        }
        this.failIfClosed();
        Deque<DataReceiver> deque = this.mReceivers;
        synchronized (deque) {
            this.mReceivers.addFirst(inReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataReciever(DataReceiver inReceiver) {
        if (inReceiver == null) {
            throw new NullPointerException();
        }
        this.failIfClosed();
        Deque<DataReceiver> deque = this.mReceivers;
        synchronized (deque) {
            this.mReceivers.removeFirstOccurrence(inReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionStatusListener(ConnectionStatusListener inListener) {
        if (inListener == null) {
            throw new NullPointerException();
        }
        this.failIfClosed();
        Deque<ConnectionStatusListener> deque = this.mListeners;
        synchronized (deque) {
            this.mListeners.addFirst(inListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionStatusListener(ConnectionStatusListener inListener) {
        if (inListener == null) {
            throw new NullPointerException();
        }
        this.failIfClosed();
        Deque<ConnectionStatusListener> deque = this.mListeners;
        synchronized (deque) {
            this.mListeners.removeFirstOccurrence(inListener);
        }
    }

    @Override
    public SAClientParameters getParameters() {
        return new SAClientParameters(this.mParameters.getUsername(), "*****".toCharArray(), this.mParameters.getURL(), this.mParameters.getHostname(), this.mParameters.getPort());
    }

    @Override
    public synchronized void close() {
        if (this.mClosed) {
            return;
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"Closing Strategy Agent Client");
        try {
            this.mServiceClient.logout();
        }
        catch (Exception e) {
            SLF4JLoggerProxy.debug((Object)this, (String)"Ignoring error when closing the web service connection.", (Throwable)e);
            ExceptUtils.interrupt((Throwable)e);
        }
        this.mEmitter.close();
        this.mClosed = true;
        SLF4JLoggerProxy.debug((Object)this, (String)"Closed Strategy Agent Client");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveData(Object inObject) {
        Deque<DataReceiver> deque = this.mReceivers;
        synchronized (deque) {
            for (DataReceiver receiver : this.mReceivers) {
                try {
                    receiver.receiveData(inObject);
                }
                catch (Exception e) {
                    Messages.LOG_ERROR_RECEIVE_DATA.warn((Object)this, (Throwable)e, inObject);
                    ExceptUtils.interrupt((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionStatusChanged(boolean inOldStatus, boolean inNewStatus) {
        this.mConnected = inNewStatus;
        Deque<ConnectionStatusListener> deque = this.mListeners;
        synchronized (deque) {
            for (ConnectionStatusListener listener : this.mListeners) {
                try {
                    listener.receiveConnectionStatus(inNewStatus);
                }
                catch (Exception e) {
                    Messages.LOG_ERROR_RECEIVE_CONNECT_STATUS.warn((Object)this, (Throwable)e, (Object)inNewStatus);
                    ExceptUtils.interrupt((Throwable)e);
                }
            }
        }
    }

    SAClientImpl(SAClientParameters inParameters) throws ConnectionException {
        if (inParameters == null) {
            throw new NullPointerException();
        }
        this.mParameters = inParameters;
        try {
            this.mServiceClient = new Client(inParameters.getHostname(), inParameters.getPort(), SAClientVersion.APP_ID, (Class[])inParameters.getContextClasses());
            this.mServiceClient.login(inParameters.getUsername(), inParameters.getPassword());
            this.mSAService = (SAService)this.mServiceClient.getService(SAService.class);
        }
        catch (Exception e) {
            throw new ConnectionException(e, (I18NBoundMessage)new I18NBoundMessage3P(Messages.ERROR_WS_CONNECT, (Serializable)((Object)inParameters.getHostname()), (Serializable)((Object)String.valueOf(inParameters.getPort())), (Serializable)((Object)inParameters.getUsername())));
        }
        boolean isJMSFailed = true;
        try {
            this.mEmitter = new RemoteDataEmitter(inParameters.getURL(), inParameters.getUsername(), String.valueOf(inParameters.getPassword()), (EmitterAdapter)this);
            isJMSFailed = false;
        }
        catch (Exception e) {
            throw new ConnectionException(e, (I18NBoundMessage)new I18NBoundMessage2P(Messages.ERROR_JMS_CONNECT, (Serializable)((Object)inParameters.getURL()), (Serializable)((Object)inParameters.getUsername())));
        }
        finally {
            if (isJMSFailed) {
                try {
                    this.mServiceClient.logout();
                }
                catch (RemoteException e) {
                    SLF4JLoggerProxy.debug((Object)this, (String)"Ignoring failure when logging out", (Throwable)e);
                }
            }
        }
    }

    private ConnectionException wrapRemoteFailure(Exception inFailure) {
        Throwable cause = inFailure instanceof RemoteException ? (inFailure.getCause() != null ? inFailure.getCause() : inFailure) : inFailure;
        return new ConnectionException(cause, (I18NBoundMessage)new I18NBoundMessage1P(Messages.ERROR_WS_OPERATION, (Serializable)((Object)cause.getLocalizedMessage())));
    }

    private ClientContext getServiceContext() {
        return this.mServiceClient.getContext();
    }

    private void failIfDisconnected() throws ConnectionException {
        this.failIfClosed();
        if (!this.mConnected) {
            throw new ConnectionException((I18NBoundMessage)Messages.CLIENT_DISCONNECTED);
        }
    }

    private void failIfClosed() throws IllegalStateException {
        if (this.mClosed) {
            throw new IllegalStateException(Messages.CLIENT_CLOSED.getText());
        }
    }
}

