/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: SAClientParameters.java 16154 2012-07-14 16:34:05Z colin $")
public class SAClientParameters {
    private final String mUsername;
    private final char[] mPassword;
    private final String mHostname;
    private final int mPort;
    private final String mURL;
    private final Class<?>[] contextClasses;

    public String getUsername() {
        return this.mUsername;
    }

    public char[] getPassword() {
        return this.mPassword == null ? null : Arrays.copyOf(this.mPassword, this.mPassword.length);
    }

    public String getURL() {
        return this.mURL;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public Class<?>[] getContextClasses() {
        return this.contextClasses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAClientParameters that = (SAClientParameters)o;
        return ObjectUtils.equals((Object)this.mPort, (Object)that.mPort) && Arrays.equals(this.mPassword, that.mPassword) && Arrays.equals(this.contextClasses, that.contextClasses) && ObjectUtils.equals((Object)this.mURL, (Object)that.mURL) && ObjectUtils.equals((Object)this.mUsername, (Object)that.mUsername) && ObjectUtils.equals((Object)this.mHostname, (Object)that.mHostname);
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.mUsername) + Arrays.hashCode(this.mPassword) + Arrays.hashCode(this.contextClasses) + ObjectUtils.hashCode((Object)this.mHostname) + ObjectUtils.hashCode((Object)this.mPort) + ObjectUtils.hashCode((Object)this.mURL);
    }

    @ConstructorProperties(value={"username", "password", "URL", "hostname", "port"})
    public SAClientParameters(String inUsername, char[] inPassword, String inURL, String inHostname, int inPort) {
        this(inUsername, inPassword, inURL, inHostname, inPort, null);
    }

    @ConstructorProperties(value={"username", "password", "URL", "hostname", "port", "contextClasses"})
    public SAClientParameters(String inUsername, char[] inPassword, String inURL, String inHostname, int inPort, Class<?> ... inContextClasses) {
        this.mUsername = inUsername;
        this.mPassword = inPassword == null ? null : Arrays.copyOf(inPassword, inPassword.length);
        this.mURL = inURL;
        this.mHostname = inHostname;
        this.mPort = inPort;
        this.contextClasses = inContextClasses;
    }

    public String toString() {
        return "ClientParameters{Username='" + this.mUsername + '\'' + ", Password='*****'" + ", URL='" + this.mURL + '\'' + ", Hostname='" + this.mHostname + '\'' + ", Port='" + this.mPort + '\'' + '}';
    }
}

