/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.IOUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.ModuleInfo;
import org.marketcetera.module.ModuleState;
import org.marketcetera.module.ModuleTestBase;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.saclient.ConnectionException;
import org.marketcetera.saclient.CreateStrategyParameters;
import org.marketcetera.saclient.Messages;
import org.marketcetera.saclient.SAClientTestBase;
import org.marketcetera.util.except.I18NException;
import org.marketcetera.util.file.CopyCharsUtils;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NMessage0P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.ContextClassProvider;
import org.marketcetera.util.ws.wrappers.MapWrapper;

@ClassVersion(value="$Id: SAClientWSTest.java 16853 2014-03-06 02:10:11Z colin $")
public class SAClientWSTest
extends SAClientTestBase {
    @Override
    @Before
    public void before() throws Exception {
        super.before();
    }

    @Test
    public void getProviders() throws Exception {
        List<List> lists = Arrays.asList(Arrays.asList(new ModuleURN("test:prov:A"), new ModuleURN("test:prov:B")), new ArrayList());
        Iterator<List> i$ = lists.iterator();
        while (i$.hasNext()) {
            List list;
            final List urnList = list = i$.next();
            SAClientWSTest.testAPI(new WSTester<List<ModuleURN>>(){

                @Override
                protected List<ModuleURN> invokeApi(boolean isNullParams) throws Exception {
                    return SAClientTestBase.getClient().getProviders();
                }

                @Override
                protected List<ModuleURN> setReturnValue(boolean isNullParams) {
                    List moduleURNs = isNullParams ? null : urnList;
                    SAClientTestBase.getMockSAService().setURNList(moduleURNs);
                    return moduleURNs == null ? new ArrayList() : moduleURNs;
                }
            });
            SAClientWSTest.resetServiceParameters();
        }
    }

    @Test
    public void getInstances() throws Exception {
        List<List> lists = Arrays.asList(Arrays.asList(new ModuleURN("test:prov:me:A"), new ModuleURN("test:prov:me:B")), new ArrayList());
        final ModuleURN input = new ModuleURN("test:prov:me");
        Iterator<List> i$ = lists.iterator();
        while (i$.hasNext()) {
            List list;
            final List urnList = list = i$.next();
            SAClientWSTest.testAPI(new WSTester<List<ModuleURN>>(){

                @Override
                protected List<ModuleURN> invokeApi(boolean isNullParams) throws Exception {
                    return SAClientTestBase.getClient().getInstances(isNullParams ? null : input);
                }

                @Override
                protected List<ModuleURN> setReturnValue(boolean isNullParams) {
                    List moduleURNs = isNullParams ? null : urnList;
                    SAClientTestBase.getMockSAService().setURNList(moduleURNs);
                    return moduleURNs == null ? new ArrayList() : moduleURNs;
                }

                @Override
                protected void verifyInputParams(boolean isNullParams) {
                    Assert.assertEquals((Object)(isNullParams ? null : input), (Object)SAClientTestBase.getMockSAService().getURN());
                }
            });
            SAClientWSTest.resetServiceParameters();
        }
    }

    @Test
    public void getModuleInfo() throws Exception {
        final ModuleURN input = new ModuleURN("test:prov:me:A");
        final ModuleInfo output = new ModuleInfo(input, ModuleState.STARTED, null, null, new Date(), new Date(), null, false, false, false, false, false, null, null, 0, false, 0);
        SAClientWSTest.testAPI(new WSTester<ModuleInfo>(){

            @Override
            protected ModuleInfo invokeApi(boolean isNullParams) throws Exception {
                return SAClientTestBase.getClient().getModuleInfo(isNullParams ? null : input);
            }

            @Override
            protected ModuleInfo setReturnValue(boolean isNullParams) {
                ModuleInfo value = isNullParams ? null : output;
                SAClientTestBase.getMockSAService().setModuleInfo(value);
                return value;
            }

            @Override
            protected void verifyInputParams(boolean isNullParams) {
                Assert.assertEquals((Object)(isNullParams ? null : input), (Object)SAClientTestBase.getMockSAService().getURN());
            }
        });
    }

    @Test
    public void createStrategy() throws Exception {
        File f = File.createTempFile("strat", ".tst");
        f.deleteOnExit();
        CopyCharsUtils.copy((char[])"Test Strategy Contents".toCharArray(), (String)f.getAbsolutePath());
        final CreateStrategyParameters input = new CreateStrategyParameters("instance", "strategy", "java", f, "key=value", false);
        final ModuleURN output = new ModuleURN("test:prov:me:A");
        SAClientWSTest.testAPI(new WSTester<ModuleURN>(){

            @Override
            protected ModuleURN invokeApi(boolean isNullParams) throws Exception {
                return SAClientTestBase.getClient().createStrategy(isNullParams ? null : input);
            }

            @Override
            protected ModuleURN setReturnValue(boolean isNullParams) {
                ModuleURN value = isNullParams ? null : output;
                SAClientTestBase.getMockSAService().setURN(value);
                return value;
            }

            @Override
            protected void verifyInputParams(boolean isNullParams) throws Exception {
                SAClientWSTest.verifyEquals(isNullParams ? null : input, SAClientTestBase.getMockSAService().getCreateStrategyParameters());
            }
        });
        SAClientWSTest.resetServiceParameters();
        CreateStrategyParameters parms = new CreateStrategyParameters("instance", "strategy", "java", f, "key=value", false);
        Assert.assertTrue((boolean)f.delete());
        Assert.assertFalse((boolean)f.exists());
        SAClientWSTest.getClient().createStrategy(parms);
        InputStream file = SAClientWSTest.getMockSAService().getCreateStrategyParameters().getStrategySource();
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((long)0L, (long)IOUtils.toByteArray((InputStream)file).length);
    }

    @Test
    public void getStrategyCreateParameters() throws Exception {
        final ModuleURN input = new ModuleURN("test:prov:me:A");
        File f = File.createTempFile("strat", ".tst");
        f.deleteOnExit();
        CopyCharsUtils.copy((char[])"Test Strategy Contents".toCharArray(), (String)f.getAbsolutePath());
        final CreateStrategyParameters output = new CreateStrategyParameters("instance", "strategy", "java", f, "key=value", false);
        SAClientWSTest.testAPI(new WSTester<CreateStrategyParameters>(){

            @Override
            protected CreateStrategyParameters invokeApi(boolean isNullParams) throws Exception {
                return SAClientTestBase.getClient().getStrategyCreateParms(isNullParams ? null : input);
            }

            @Override
            protected CreateStrategyParameters setReturnValue(boolean isNullParams) {
                CreateStrategyParameters value = isNullParams ? null : output;
                SAClientTestBase.getMockSAService().setCreateStrategyParameters(value);
                return value;
            }
        });
        SAClientWSTest.resetServiceParameters();
        SAClientWSTest.getMockSAService().setCreateStrategyParameters(new CreateStrategyParameters("instance", "strategy", "java", f, "key=value", false));
        Assert.assertTrue((boolean)f.delete());
        Assert.assertFalse((boolean)f.exists());
        InputStream file = SAClientWSTest.getClient().getStrategyCreateParms(null).getStrategySource();
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((long)0L, (long)IOUtils.toByteArray((InputStream)file).length);
    }

    @Test
    public void start() throws Exception {
        final ModuleURN input = new ModuleURN("test:prov:me:A");
        SAClientWSTest.testAPI(new WSTester<Void>(){

            @Override
            protected Void invokeApi(boolean isNullParams) throws Exception {
                SAClientTestBase.getClient().start(isNullParams ? null : input);
                return null;
            }

            @Override
            protected void verifyInputParams(boolean isNullParams) {
                Assert.assertEquals((Object)(isNullParams ? null : input), (Object)SAClientTestBase.getMockSAService().getURN());
            }
        });
    }

    @Test
    public void stop() throws Exception {
        final ModuleURN input = new ModuleURN("test:prov:me:A");
        SAClientWSTest.testAPI(new WSTester<Void>(){

            @Override
            protected Void invokeApi(boolean isNullParams) throws Exception {
                SAClientTestBase.getClient().stop(isNullParams ? null : input);
                return null;
            }

            @Override
            protected void verifyInputParams(boolean isNullParams) {
                Assert.assertEquals((Object)(isNullParams ? null : input), (Object)SAClientTestBase.getMockSAService().getURN());
            }
        });
    }

    @Test
    public void sendData() throws Exception {
        final TestData data = new TestData();
        SAClientWSTest.testAPI(new WSTester<Void>(){

            @Override
            protected Void invokeApi(boolean isNullParams) throws Exception {
                SAClientTestBase.getClient().sendData((Object)(isNullParams ? null : data));
                return null;
            }

            @Override
            protected void verifyInputParams(boolean isNullParams) {
                Assert.assertEquals((Object)(isNullParams ? null : data), (Object)SAClientTestBase.getMockSAService().getData());
            }
        });
    }

    @Test
    public void delete() throws Exception {
        final ModuleURN input = new ModuleURN("test:prov:me:A");
        SAClientWSTest.testAPI(new WSTester<Void>(){

            @Override
            protected Void invokeApi(boolean isNullParams) throws Exception {
                SAClientTestBase.getClient().delete(isNullParams ? null : input);
                return null;
            }

            @Override
            protected void verifyInputParams(boolean isNullParams) {
                Assert.assertEquals((Object)(isNullParams ? null : input), (Object)SAClientTestBase.getMockSAService().getURN());
            }
        });
    }

    @Test
    public void getProperties() throws Exception {
        final ModuleURN input = new ModuleURN("test:prov:me:A");
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("first", BigDecimal.TEN);
        m.put("second", "next");
        m.put("third", 909);
        List<Map> maps = Arrays.asList(m, new HashMap());
        Iterator<Map> i$ = maps.iterator();
        while (i$.hasNext()) {
            Map map;
            final Map output = map = i$.next();
            SAClientWSTest.testAPI(new WSTester<Map<String, Object>>(){

                @Override
                protected Map<String, Object> invokeApi(boolean isNullParams) throws Exception {
                    return SAClientTestBase.getClient().getProperties(isNullParams ? null : input);
                }

                @Override
                protected Map<String, Object> setReturnValue(boolean isNullParams) {
                    SAClientTestBase.getMockSAService().setPropertiesOut((MapWrapper<String, Object>)(isNullParams ? null : new MapWrapper(output)));
                    return isNullParams ? null : output;
                }

                @Override
                protected void verifyInputParams(boolean isNullParams) throws Exception {
                    SAClientWSTest.verifyEquals(isNullParams ? null : input, SAClientTestBase.getMockSAService().getURN());
                }
            });
            SAClientWSTest.resetServiceParameters();
        }
    }

    @Test
    public void setProperties() throws Exception {
        final ModuleURN input1 = new ModuleURN("test:prov:me:A");
        HashMap<String, Object> i2 = new HashMap<String, Object>();
        i2.put("first", BigDecimal.ONE);
        i2.put("second", "mnext");
        i2.put("third", 999);
        List<Map> inputs = Arrays.asList(i2, new HashMap());
        HashMap<String, Object> out = new HashMap<String, Object>();
        out.put("first", BigDecimal.TEN);
        out.put("second", "next");
        out.put("third", 909);
        List<Map> outputs = Arrays.asList(out, new HashMap());
        for (int i = 0; i < inputs.size(); ++i) {
            final Map input2 = inputs.get(i);
            final Map output = outputs.get(i);
            SAClientWSTest.testAPI(new WSTester<Map<String, Object>>(){

                @Override
                protected Map<String, Object> invokeApi(boolean isNullParams) throws Exception {
                    return SAClientTestBase.getClient().setProperties(isNullParams ? null : input1, isNullParams ? null : input2);
                }

                @Override
                protected Map<String, Object> setReturnValue(boolean isNullParams) {
                    SAClientTestBase.getMockSAService().setPropertiesOut((MapWrapper<String, Object>)(isNullParams ? null : new MapWrapper(output)));
                    return isNullParams ? null : output;
                }

                @Override
                protected void verifyInputParams(boolean isNullParams) throws Exception {
                    Assert.assertEquals((Object)(isNullParams ? null : input1), (Object)SAClientTestBase.getMockSAService().getURN());
                    MapWrapper<String, Object> mapWrapper = SAClientTestBase.getMockSAService().getPropertiesIn();
                    SAClientWSTest.verifyEquals(isNullParams ? null : input2, mapWrapper == null ? null : mapWrapper.getMap());
                }
            });
            SAClientWSTest.resetServiceParameters();
        }
    }

    @After
    public void reset() {
        SAClientWSTest.resetServiceParameters();
    }

    @Override
    protected ContextClassProvider getContextClassProvider() {
        return new ContextClassProvider(){

            public Class<?>[] getContextClasses() {
                return new Class[]{TestData.class};
            }
        };
    }

    private static <R> void testAPI(final WSTester<R> inTester) throws Exception {
        R value = inTester.setReturnValue(false);
        SAClientWSTest.verifyEquals(value, inTester.invokeApi(false));
        inTester.verifyInputParams(false);
        SAClientWSTest.resetServiceParameters();
        value = inTester.setReturnValue(true);
        SAClientWSTest.verifyEquals(value, inTester.invokeApi(true));
        inTester.verifyInputParams(true);
        SAClientWSTest.resetServiceParameters();
        I18NException failure = new I18NException((I18NBoundMessage)new I18NMessage0P(Messages.LOGGER, "test"));
        SAClientWSTest.getMockSAService().setFailure((Exception)failure);
        inTester.setReturnValue(false);
        ConnectionException e = (ConnectionException)new ExpectedFailure<ConnectionException>(){

            protected void run() throws Exception {
                inTester.invokeApi(false);
            }
        }.getException();
        Assert.assertNotNull((Object)e.getCause());
        Assert.assertEquals((Object)failure, (Object)e.getCause());
        inTester.verifyInputParams(false);
        SAClientWSTest.verifyInvocationCannotBeInterrupted(inTester);
    }

    private static <R> void verifyInvocationCannotBeInterrupted(final WSTester<R> inTester) throws Exception {
        SAClientWSTest.resetServiceParameters();
        SAClientWSTest.getMockSAService().setSleep(true);
        inTester.setReturnValue(false);
        final Semaphore sema = new Semaphore(0);
        final AtomicReference interruptFailure = new AtomicReference();
        Thread t = new Thread(){

            @Override
            public void run() {
                sema.release();
                try {
                    inTester.invokeApi(false);
                }
                catch (Exception ex) {
                    interruptFailure.set(ex);
                }
            }
        };
        t.start();
        sema.acquire();
        t.interrupt();
        t.join();
        Assert.assertNull((String)"API invocation got interrupted!", interruptFailure.get());
    }

    private static void verifyEquals(Object inExpected, Object inActual) throws IOException {
        if (inExpected == null) {
            Assert.assertNull((Object)inActual);
        } else {
            Assert.assertNotNull((String)("Expected:" + inExpected), (Object)inActual);
            if (inExpected instanceof ModuleInfo) {
                ModuleInfo e = (ModuleInfo)inExpected;
                ModuleInfo a = (ModuleInfo)inActual;
                ModuleTestBase.assertModuleInfo((ModuleInfo)a, (ModuleURN)e.getURN(), (ModuleState)e.getState(), (DataFlowID[])e.getInitiatedDataFlows(), (DataFlowID[])e.getParticipatingDataFlows(), (boolean)e.isAutocreated(), (boolean)e.isAutostart(), (boolean)e.isReceiver(), (boolean)e.isEmitter(), (boolean)e.isFlowRequester());
                Assert.assertEquals((Object)e.getLastStartFailure(), (Object)a.getLastStartFailure());
                Assert.assertEquals((Object)e.getLastStopFailure(), (Object)a.getLastStopFailure());
                Assert.assertEquals((long)e.getLockQueueLength(), (long)a.getLockQueueLength());
                Assert.assertEquals((long)e.getReadLockCount(), (long)a.getReadLockCount());
                Assert.assertEquals((Object)e.isWriteLocked(), (Object)a.isWriteLocked());
            } else if (inExpected instanceof Map) {
                HashMap e = new HashMap((Map)inExpected);
                HashMap a = new HashMap((Map)inActual);
                Assert.assertEquals(e, a);
            } else if (inExpected instanceof CreateStrategyParameters) {
                CreateStrategyParameters e = (CreateStrategyParameters)inExpected;
                CreateStrategyParameters a = (CreateStrategyParameters)inActual;
                Assert.assertEquals((Object)e.getInstanceName(), (Object)a.getInstanceName());
                Assert.assertEquals((Object)e.getStrategyName(), (Object)a.getStrategyName());
                Assert.assertEquals((Object)e.getLanguage(), (Object)a.getLanguage());
                InputStream ein = e.getStrategySource();
                InputStream ain = a.getStrategySource();
                Assert.assertArrayEquals((byte[])IOUtils.toByteArray((InputStream)ein), (byte[])IOUtils.toByteArray((InputStream)ain));
                ein.close();
                ain.close();
            } else {
                Assert.assertEquals((Object)inExpected, (Object)inActual);
            }
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class TestData {
        private String attribute1;
        private long attribute2;
        private Date attribute3 = new Date();

        public TestData() {
            this.attribute2 = System.nanoTime();
            this.attribute1 = String.valueOf(this.attribute3) + " and " + String.valueOf(this.attribute2);
        }

        public String getAttribute1() {
            return this.attribute1;
        }

        public void setAttribute1(String inAttribute1) {
            this.attribute1 = inAttribute1;
        }

        public long getAttribute2() {
            return this.attribute2;
        }

        public void setAttribute2(long inAttribute2) {
            this.attribute2 = inAttribute2;
        }

        public Date getAttribute3() {
            return this.attribute3;
        }

        public void setAttribute3(Date inAttribute3) {
            this.attribute3 = inAttribute3;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.attribute1 == null ? 0 : this.attribute1.hashCode());
            result = 31 * result + (int)(this.attribute2 ^ this.attribute2 >>> 32);
            result = 31 * result + (this.attribute3 == null ? 0 : this.attribute3.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TestData other = (TestData)obj;
            if (this.attribute1 == null ? other.attribute1 != null : !this.attribute1.equals(other.attribute1)) {
                return false;
            }
            if (this.attribute2 != other.attribute2) {
                return false;
            }
            return !(this.attribute3 == null ? other.attribute3 != null : !this.attribute3.equals(other.attribute3));
        }

        public String toString() {
            return "TestData [attribute1=" + this.attribute1 + ", attribute2=" + this.attribute2 + ", attribute3=" + this.attribute3 + "]";
        }
    }

    private static abstract class WSTester<R> {
        private WSTester() {
        }

        protected R setReturnValue(boolean isNullParams) {
            return null;
        }

        protected abstract R invokeApi(boolean var1) throws Exception;

        protected void verifyInputParams(boolean isNullParams) throws Exception {
        }
    }
}

