/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.io.Serializable;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.marketcetera.modules.remote.emitter.EmitterAdapter;
import org.marketcetera.modules.remote.emitter.RemoteDataEmitter;
import org.marketcetera.saclient.ConnectionException;
import org.marketcetera.saclient.ConnectionStatusListener;
import org.marketcetera.saclient.DataReceiver;
import org.marketcetera.saclient.Messages;
import org.marketcetera.saclient.SAClient;
import org.marketcetera.saclient.SAClientParameters;
import org.marketcetera.util.except.ExceptUtils;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage1P;
import org.marketcetera.util.log.I18NBoundMessage2P;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.wrappers.RemoteException;
import org.springframework.context.Lifecycle;

@ClassVersion(value="$Id: SAClientImpl.java 16853 2014-03-06 02:10:11Z colin $")
public abstract class AbstractSAClient
implements SAClient,
EmitterAdapter,
Lifecycle {
    private RemoteDataEmitter emitter;
    private final Deque<DataReceiver> receivers = new LinkedList<DataReceiver>();
    private final Deque<ConnectionStatusListener> listeners = new LinkedList<ConnectionStatusListener>();
    protected final SAClientParameters parameters;
    protected final AtomicBoolean running = new AtomicBoolean(false);

    public boolean isRunning() {
        return this.running.get();
    }

    public final synchronized void start() {
        this.doStart();
        if (this.parameters.getUseJms()) {
            try {
                this.emitter = new RemoteDataEmitter(this.parameters.getURL(), this.parameters.getUsername(), String.valueOf(this.parameters.getPassword()), (EmitterAdapter)this);
            }
            catch (Exception e) {
                throw new ConnectionException(e, (I18NBoundMessage)new I18NBoundMessage2P(Messages.ERROR_JMS_CONNECT, (Serializable)((Object)this.parameters.getURL()), (Serializable)((Object)this.parameters.getUsername())));
            }
        } else {
            this.emitter = null;
        }
        this.running.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void stop() {
        SLF4JLoggerProxy.debug((Object)this, (String)"Closing Strategy Agent Client");
        try {
            try {
                this.doStop();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            try {
                if (this.emitter != null) {
                    this.emitter.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            this.emitter = null;
            this.running.set(false);
            SLF4JLoggerProxy.debug((Object)this, (String)"Closed Strategy Agent Client");
        }
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected AbstractSAClient(SAClientParameters inParameters) {
        if (inParameters == null) {
            throw new NullPointerException();
        }
        this.parameters = inParameters;
    }

    @Override
    public final synchronized void close() {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDataReceiver(DataReceiver inReceiver) {
        if (inReceiver == null) {
            throw new NullPointerException();
        }
        Deque<DataReceiver> deque = this.receivers;
        synchronized (deque) {
            this.receivers.addFirst(inReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDataReciever(DataReceiver inReceiver) {
        if (inReceiver == null) {
            throw new NullPointerException();
        }
        Deque<DataReceiver> deque = this.receivers;
        synchronized (deque) {
            this.receivers.removeFirstOccurrence(inReceiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionStatusListener(ConnectionStatusListener inListener) {
        if (inListener == null) {
            throw new NullPointerException();
        }
        Deque<ConnectionStatusListener> deque = this.listeners;
        synchronized (deque) {
            this.listeners.addFirst(inListener);
        }
        inListener.receiveConnectionStatus(this.isRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionStatusListener(ConnectionStatusListener inListener) {
        if (inListener == null) {
            throw new NullPointerException();
        }
        Deque<ConnectionStatusListener> deque = this.listeners;
        synchronized (deque) {
            this.listeners.removeFirstOccurrence(inListener);
        }
    }

    @Override
    public SAClientParameters getParameters() {
        return new SAClientParameters(this.parameters.getUsername(), "*****".toCharArray(), this.parameters.getURL(), this.parameters.getHostname(), this.parameters.getPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveData(Object inObject) {
        Deque<DataReceiver> deque = this.receivers;
        synchronized (deque) {
            for (DataReceiver receiver : this.receivers) {
                try {
                    receiver.receiveData(inObject);
                }
                catch (Exception e) {
                    Messages.LOG_ERROR_RECEIVE_DATA.warn((Object)this, (Throwable)e, inObject);
                    ExceptUtils.interrupt((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionStatusChanged(boolean inOldStatus, boolean inNewStatus) {
        if (inOldStatus == inNewStatus) {
            return;
        }
        this.running.set(inNewStatus);
        Deque<ConnectionStatusListener> deque = this.listeners;
        synchronized (deque) {
            for (ConnectionStatusListener listener : this.listeners) {
                try {
                    listener.receiveConnectionStatus(inNewStatus);
                }
                catch (Exception e) {
                    Messages.LOG_ERROR_RECEIVE_CONNECT_STATUS.warn((Object)this, (Throwable)e, (Object)inNewStatus);
                    ExceptUtils.interrupt((Throwable)e);
                }
            }
        }
    }

    protected void failIfDisconnected() throws ConnectionException {
        if (!this.isRunning()) {
            throw new ConnectionException((I18NBoundMessage)Messages.CLIENT_DISCONNECTED);
        }
    }

    protected void failIfClosed() throws IllegalStateException {
        if (!this.isRunning()) {
            throw new IllegalStateException(Messages.CLIENT_CLOSED.getText());
        }
    }

    protected ConnectionException wrapRemoteFailure(Exception inFailure) {
        Throwable cause = inFailure instanceof RemoteException ? (inFailure.getCause() != null ? inFailure.getCause() : inFailure) : inFailure;
        return new ConnectionException(cause, (I18NBoundMessage)new I18NBoundMessage1P(Messages.ERROR_WS_OPERATION, (Serializable)((Object)cause.getLocalizedMessage())));
    }
}

