/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.beans.ConstructorProperties;
import java.util.Arrays;
import org.apache.commons.lang.ObjectUtils;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.ContextClassProvider;

@ClassVersion(value="$Id: SAClientParameters.java 16879 2014-04-15 21:40:25Z colin $")
public class SAClientParameters {
    private final boolean useJms;
    private final String mUsername;
    private final char[] mPassword;
    private final String mHostname;
    private final int mPort;
    private final String mURL;
    private final ContextClassProvider contextClassProvider;

    public String getUsername() {
        return this.mUsername;
    }

    public char[] getPassword() {
        return this.mPassword == null ? null : Arrays.copyOf(this.mPassword, this.mPassword.length);
    }

    public String getURL() {
        return this.mURL;
    }

    public int getPort() {
        return this.mPort;
    }

    public String getHostname() {
        return this.mHostname;
    }

    public ContextClassProvider getContextClassProvider() {
        return this.contextClassProvider;
    }

    public boolean getUseJms() {
        return this.useJms;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAClientParameters that = (SAClientParameters)o;
        return ObjectUtils.equals((Object)this.mPort, (Object)that.mPort) && Arrays.equals(this.mPassword, that.mPassword) && ObjectUtils.equals((Object)this.contextClassProvider, (Object)that.contextClassProvider) && ObjectUtils.equals((Object)this.mURL, (Object)that.mURL) && ObjectUtils.equals((Object)this.mUsername, (Object)that.mUsername) && ObjectUtils.equals((Object)this.mHostname, (Object)that.mHostname);
    }

    public int hashCode() {
        return ObjectUtils.hashCode((Object)this.mUsername) + Arrays.hashCode(this.mPassword) + ObjectUtils.hashCode((Object)this.contextClassProvider) + ObjectUtils.hashCode((Object)this.mHostname) + ObjectUtils.hashCode((Object)this.mPort) + ObjectUtils.hashCode((Object)this.mURL);
    }

    @ConstructorProperties(value={"username", "password", "URL", "hostname", "port"})
    public SAClientParameters(String inUsername, char[] inPassword, String inURL, String inHostname, int inPort) {
        this(inUsername, inPassword, inURL, inHostname, inPort, null);
    }

    @ConstructorProperties(value={"username", "password", "URL", "hostname", "port", "contextClasses"})
    public SAClientParameters(String inUsername, char[] inPassword, String inURL, String inHostname, int inPort, ContextClassProvider inContextClassProvider) {
        this(inUsername, inPassword, inURL, inHostname, inPort, inContextClassProvider, true);
    }

    @ConstructorProperties(value={"username", "password", "URL", "hostname", "port", "contextClasses", "useJms"})
    public SAClientParameters(String inUsername, char[] inPassword, String inURL, String inHostname, int inPort, ContextClassProvider inContextClassProvider, boolean inUseJms) {
        this.mUsername = inUsername;
        this.mPassword = inPassword == null ? null : Arrays.copyOf(inPassword, inPassword.length);
        this.mURL = inURL;
        this.mHostname = inHostname;
        this.mPort = inPort;
        this.contextClassProvider = inContextClassProvider;
        this.useJms = inUseJms;
    }

    public String toString() {
        return "ClientParameters{Username='" + this.mUsername + '\'' + ", Password='*****'" + ", URL='" + this.mURL + '\'' + ", Hostname='" + this.mHostname + '\'' + ", Port='" + this.mPort + '\'' + '}';
    }
}

