/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient.rpc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import com.googlecode.protobuf.pro.duplex.PeerInfo;
import com.googlecode.protobuf.pro.duplex.RpcClientChannel;
import com.googlecode.protobuf.pro.duplex.client.DuplexTcpClientPipelineFactory;
import com.googlecode.protobuf.pro.duplex.execute.RpcServerCallExecutor;
import com.googlecode.protobuf.pro.duplex.execute.ThreadPoolCallExecutor;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.marketcetera.core.CloseableLock;
import org.marketcetera.module.ModuleInfo;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.saclient.AbstractSAClient;
import org.marketcetera.saclient.ConnectionException;
import org.marketcetera.saclient.CreateStrategyParameters;
import org.marketcetera.saclient.SAClientParameters;
import org.marketcetera.saclient.SAClientVersion;
import org.marketcetera.saclient.rpc.RpcSAClient;
import org.marketcetera.saclient.rpc.XmlValue;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.ContextClassProvider;
import org.marketcetera.util.ws.tags.NodeId;
import org.marketcetera.util.ws.tags.SessionId;

@ClassVersion(value="$Id$")
public class RpcSAClientImpl
extends AbstractSAClient {
    private final ReadWriteLock serviceLock = new ReentrantReadWriteLock();
    private RpcSAClient.RpcSAClientService.BlockingInterface clientService;
    private RpcServerCallExecutor executor;
    private RpcClientChannel channel;
    private RpcController controller;
    private final Object contextLock = new Object();
    @GuardedBy(value="contextLock")
    private JAXBContext context;
    @GuardedBy(value="contextLock")
    private Marshaller marshaller;
    @GuardedBy(value="contextLock")
    private Unmarshaller unmarshaller;
    private ContextClassProvider contextClassProvider;
    private SessionId sessionId;
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);
    private ScheduledFuture<?> heartbeatFuture;
    private long heartbeatInterval = 10000L;
    private final ScheduledExecutorService heartbeatService = Executors.newScheduledThreadPool(1);

    RpcSAClientImpl(SAClientParameters inParameters) {
        super(inParameters);
        this.contextClassProvider = inParameters.getContextClassProvider();
    }

    @Override
    public List<ModuleURN> getProviders() throws ConnectionException {
        this.failIfDisconnected();
        try {
            RpcSAClient.ProvidersResponse response = this.clientService.getProviders(this.controller, RpcSAClient.ProvidersRequest.newBuilder().setSessionId(this.sessionId.getValue()).build());
            ArrayList providers = Lists.newArrayList();
            for (RpcSAClient.ModuleURN provider : response.getProviderList()) {
                providers.add(new ModuleURN(provider.getValue()));
            }
            return providers;
        }
        catch (ServiceException e) {
            throw this.wrapRemoteFailure((Exception)((Object)e));
        }
    }

    @Override
    public List<ModuleURN> getInstances(ModuleURN inProviderURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            RpcSAClient.InstancesResponse response = this.clientService.getInstances(this.controller, RpcSAClient.InstancesRequest.newBuilder().setSessionId(this.sessionId.getValue()).setProvider(RpcSAClient.ModuleURN.newBuilder().setValue(inProviderURN.getValue())).build());
            ArrayList instances = Lists.newArrayList();
            for (RpcSAClient.ModuleURN instance : response.getInstanceList()) {
                instances.add(new ModuleURN(instance.getValue()));
            }
            return instances;
        }
        catch (ServiceException e) {
            throw this.wrapRemoteFailure((Exception)((Object)e));
        }
    }

    @Override
    public ModuleInfo getModuleInfo(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            RpcSAClient.ModuleInfoResponse response = this.clientService.getModuleInfo(this.controller, RpcSAClient.ModuleInfoRequest.newBuilder().setSessionId(this.sessionId.getValue()).setInstance(RpcSAClient.ModuleURN.newBuilder().setValue(inURN.getValue())).build());
            ModuleInfo info = null;
            if (response.hasInfo()) {
                info = (ModuleInfo)this.unmarshal(response.getInfo().getPayload());
            }
            return info;
        }
        catch (ServiceException | JAXBException e) {
            throw this.wrapRemoteFailure((Exception)e);
        }
    }

    @Override
    public void start(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            this.clientService.start(this.controller, RpcSAClient.StartRequest.newBuilder().setSessionId(this.sessionId.getValue()).setInstance(RpcSAClient.ModuleURN.newBuilder().setValue(inURN.getValue())).build());
            return;
        }
        catch (ServiceException e) {
            throw this.wrapRemoteFailure((Exception)((Object)e));
        }
    }

    @Override
    public void stop(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            this.clientService.stop(this.controller, RpcSAClient.StopRequest.newBuilder().setSessionId(this.sessionId.getValue()).setInstance(RpcSAClient.ModuleURN.newBuilder().setValue(inURN.getValue())).build());
            return;
        }
        catch (ServiceException e) {
            throw this.wrapRemoteFailure((Exception)((Object)e));
        }
    }

    @Override
    public void delete(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            this.clientService.delete(this.controller, RpcSAClient.DeleteRequest.newBuilder().setSessionId(this.sessionId.getValue()).setInstance(RpcSAClient.ModuleURN.newBuilder().setValue(inURN.getValue())).build());
            return;
        }
        catch (ServiceException e) {
            throw this.wrapRemoteFailure((Exception)((Object)e));
        }
    }

    @Override
    public Map<String, Object> getProperties(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            RpcSAClient.GetPropertiesResponse response = this.clientService.getProperties(this.controller, RpcSAClient.GetPropertiesRequest.newBuilder().setSessionId(this.sessionId.getValue()).setInstance(RpcSAClient.ModuleURN.newBuilder().setValue(inURN.getValue())).build());
            HashMap properties = Maps.newHashMap();
            for (RpcSAClient.Entry entry : response.getProperties().getEntryList()) {
                String key = entry.getKey();
                Object value = ((XmlValue)this.unmarshal(entry.getValue())).getValue();
                properties.put(key, value);
            }
            return properties;
        }
        catch (ServiceException | JAXBException e) {
            throw this.wrapRemoteFailure((Exception)e);
        }
    }

    @Override
    public Map<String, Object> setProperties(ModuleURN inURN, Map<String, Object> inProperties) throws ConnectionException {
        this.failIfDisconnected();
        try {
            RpcSAClient.Properties.Builder propertiesBuilder = RpcSAClient.Properties.newBuilder();
            for (Map.Entry<String, Object> entry : inProperties.entrySet()) {
                RpcSAClient.Entry.Builder entryBuilder = RpcSAClient.Entry.newBuilder();
                entryBuilder.setKey(entry.getKey());
                try {
                    entryBuilder.setValue(this.marshal(new XmlValue(entry.getValue())));
                }
                catch (JAXBException e) {
                    throw new ServiceException((Throwable)e);
                }
                propertiesBuilder.addEntry(entryBuilder.build());
            }
            RpcSAClient.SetPropertiesResponse response = this.clientService.setProperties(this.controller, RpcSAClient.SetPropertiesRequest.newBuilder().setSessionId(this.sessionId.getValue()).setInstance(RpcSAClient.ModuleURN.newBuilder().setValue(inURN.getValue())).setProperties(propertiesBuilder.build()).build());
            HashMap properties = Maps.newHashMap();
            for (RpcSAClient.Entry entry : response.getProperties().getEntryList()) {
                String key = entry.getKey();
                Object value = ((XmlValue)this.unmarshal(entry.getValue())).getValue();
                properties.put(key, value);
            }
            return properties;
        }
        catch (ServiceException | JAXBException e) {
            throw this.wrapRemoteFailure((Exception)e);
        }
    }

    @Override
    public ModuleURN createStrategy(CreateStrategyParameters inParameters) throws ConnectionException {
        this.failIfDisconnected();
        try {
            RpcSAClient.CreateStrategyResponse response = this.clientService.createStrategy(this.controller, RpcSAClient.CreateStrategyRequest.newBuilder().setSessionId(this.sessionId.getValue()).setCreateStrategyParameters(RpcSAClient.CreateStrategyParameters.newBuilder().setPayload(this.marshal(inParameters)).build()).build());
            ModuleURN instance = new ModuleURN(response.getInstance().getValue());
            return instance;
        }
        catch (ServiceException | JAXBException e) {
            throw this.wrapRemoteFailure((Exception)e);
        }
    }

    @Override
    public CreateStrategyParameters getStrategyCreateParms(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            RpcSAClient.StrategyCreateParmsResponse response = this.clientService.getStrategyCreateParms(this.controller, RpcSAClient.StrategyCreateParmsRequest.newBuilder().setSessionId(this.sessionId.getValue()).setInstance(RpcSAClient.ModuleURN.newBuilder().setValue(inURN.getValue())).build());
            CreateStrategyParameters params = (CreateStrategyParameters)this.unmarshal(response.getCreateStrategyParameters().getPayload());
            return params;
        }
        catch (ServiceException | JAXBException e) {
            throw this.wrapRemoteFailure((Exception)e);
        }
    }

    @Override
    public void sendData(Object inData) throws ConnectionException {
        this.failIfDisconnected();
        try {
            this.clientService.sendData(this.controller, RpcSAClient.SendDataRequest.newBuilder().setSessionId(this.sessionId.getValue()).setPayload(this.marshal(new XmlValue(inData))).build());
            return;
        }
        catch (ServiceException | JAXBException e) {
            throw this.wrapRemoteFailure((Exception)e);
        }
    }

    public ContextClassProvider getContextClassProvider() {
        return this.contextClassProvider;
    }

    public void setContextClassProvider(ContextClassProvider inContextClassProvider) {
        this.contextClassProvider = inContextClassProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        try {
            Object object = this.contextLock;
            synchronized (object) {
                this.context = JAXBContext.newInstance((Class[])(this.contextClassProvider == null ? new Class[]{} : this.contextClassProvider.getContextClasses()));
                this.marshaller = this.context.createMarshaller();
                this.unmarshaller = this.context.createUnmarshaller();
            }
            this.startService();
            this.heartbeatFuture = this.heartbeatService.scheduleAtFixedRate(new HeartbeatMonitor(), this.heartbeatInterval, this.heartbeatInterval, TimeUnit.MILLISECONDS);
        }
        catch (ServiceException | IOException | JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void doStop() {
        if (this.heartbeatFuture != null) {
            try {
                this.heartbeatFuture.cancel(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void startService() throws IOException, ServiceException {
        try (CloseableLock startLock = CloseableLock.create((Lock)this.serviceLock.writeLock());){
            startLock.lock();
            SLF4JLoggerProxy.debug((Object)this, (String)"Connecting to RPC server at {}:{}", (Object[])new Object[]{this.parameters.getHostname(), this.parameters.getPort()});
            PeerInfo server = new PeerInfo(this.parameters.getHostname(), this.parameters.getPort());
            DuplexTcpClientPipelineFactory clientFactory = new DuplexTcpClientPipelineFactory();
            this.executor = new ThreadPoolCallExecutor(1, 10);
            clientFactory.setRpcServerCallExecutor(this.executor);
            clientFactory.setConnectResponseTimeoutMillis(10000L);
            clientFactory.setCompression(true);
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.group((EventLoopGroup)new NioEventLoopGroup());
            bootstrap.handler((ChannelHandler)clientFactory);
            bootstrap.channel(NioSocketChannel.class);
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
            bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
            bootstrap.option(ChannelOption.SO_SNDBUF, (Object)0x100000);
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)0x100000);
            this.channel = clientFactory.peerWith(server, bootstrap);
            this.clientService = RpcSAClient.RpcSAClientService.newBlockingStub((BlockingRpcChannel)this.channel);
            this.controller = this.channel.newRpcController();
            Locale currentLocale = Locale.getDefault();
            RpcSAClient.LoginRequest loginRequest = RpcSAClient.LoginRequest.newBuilder().setAppId(SAClientVersion.APP_ID.getValue()).setVersionId(SAClientVersion.APP_ID_VERSION.getVersionInfo()).setClientId(NodeId.generate().getValue()).setLocale(RpcSAClient.Locale.newBuilder().setCountry(currentLocale.getCountry() == null ? "" : currentLocale.getCountry()).setLanguage(currentLocale.getLanguage() == null ? "" : currentLocale.getLanguage()).setVariant(currentLocale.getVariant() == null ? "" : currentLocale.getVariant()).build()).setUsername(this.parameters.getUsername()).setPassword(new String(this.parameters.getPassword())).build();
            RpcSAClient.LoginResponse loginResponse = this.clientService.login(this.controller, loginRequest);
            this.sessionId = new SessionId(loginResponse.getSessionId());
            this.connectionStatusChanged(this.isRunning(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopService() {
        try (CloseableLock stopLock = CloseableLock.create((Lock)this.serviceLock.writeLock());){
            stopLock.lock();
            try {
                this.clientService.logout(this.controller, RpcSAClient.LogoutRequest.newBuilder().setSessionId(this.sessionId.getValue()).build());
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (this.executor != null) {
                try {
                    this.executor.shutdownNow();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
        }
        finally {
            this.executor = null;
            this.controller = null;
            this.clientService = null;
            this.channel = null;
            this.sessionId = null;
            this.running.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String marshal(Object inObject) throws JAXBException {
        StringWriter output = new StringWriter();
        Object object = this.contextLock;
        synchronized (object) {
            this.marshaller.marshal(inObject, (Writer)output);
        }
        return output.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Clazz> Clazz unmarshal(String inData) throws JAXBException {
        Object object = this.contextLock;
        synchronized (object) {
            return (Clazz)this.unmarshaller.unmarshal((Reader)new StringReader(inData));
        }
    }

    @ClassVersion(value="$Id$")
    private class HeartbeatMonitor
    implements Runnable {
        private HeartbeatMonitor() {
        }

        @Override
        public void run() {
            if (!RpcSAClientImpl.this.isRunning() && !RpcSAClientImpl.this.shutdownRequested.get()) {
                try {
                    RpcSAClientImpl.this.stopService();
                    RpcSAClientImpl.this.startService();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            try (CloseableLock heartbeatLock = CloseableLock.create((Lock)RpcSAClientImpl.this.serviceLock.readLock());){
                heartbeatLock.lock();
                RpcSAClientImpl.this.clientService.heartbeat(RpcSAClientImpl.this.controller, RpcSAClient.HeartbeatRequest.newBuilder().setId(System.nanoTime()).build());
            }
            catch (Exception e) {
                SLF4JLoggerProxy.debug((Object)RpcSAClientImpl.this, (Throwable)e, (String)"Heartbeat failed", (Object[])new Object[0]);
                RpcSAClientImpl.this.connectionStatusChanged(RpcSAClientImpl.this.isRunning(), false);
            }
        }
    }
}

