/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.saclient.CreateStrategyParameters;
import org.marketcetera.util.file.CopyCharsUtils;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: CreateStrategyParametersTest.java 17591 2017-10-17 21:41:21Z colin $")
public class CreateStrategyParametersTest {
    @Test
    public void constructorChecks() throws Exception {
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new CreateStrategyParameters("blah", null, "JAVA", new File("dontmatter"), null, false);
            }
        };
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new CreateStrategyParameters("blah", "naah", null, new File("dontmatter"), null, false);
            }
        };
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                new CreateStrategyParameters("blah", "naah", "JAVA", null, null, false);
            }
        };
        final File source = new File("doesnotexist");
        new ExpectedFailure<FileNotFoundException>(source.getAbsolutePath()){

            protected void run() throws Exception {
                new CreateStrategyParameters("blah", "naah", "JAVA", source, null, false);
            }
        };
        final File unreadable = File.createTempFile("strat", "txt");
        unreadable.deleteOnExit();
        unreadable.setReadable(false);
        unreadable.setReadable(false, false);
        if (!unreadable.canRead()) {
            new ExpectedFailure<FileNotFoundException>(unreadable.getAbsolutePath()){

                protected void run() throws Exception {
                    new CreateStrategyParameters("blah", "naah", "JAVA", unreadable, null, false);
                }
            };
        } else {
            SLF4JLoggerProxy.info((Object)this, (String)"Cannot make a test file unreadable.");
        }
    }

    @Test
    public void constructAndGet() throws Exception {
        String instanceName = "myname";
        String strategyName = "name";
        String language = "JAVA";
        String parameters = "game=lame";
        File tmp = File.createTempFile("strat", ".tmp");
        tmp.deleteOnExit();
        CreateStrategyParameters csp = new CreateStrategyParameters(instanceName, strategyName, language, tmp, parameters, false);
        CreateStrategyParametersTest.assertCSP(csp, instanceName, strategyName, language, parameters, false);
        csp = new CreateStrategyParameters(null, strategyName, language, tmp, null, true);
        CreateStrategyParametersTest.assertCSP(csp, null, strategyName, language, null, true);
        csp = new CreateStrategyParameters("", "", "", tmp, "", true);
        CreateStrategyParametersTest.assertCSP(csp, "", "", "", "", true);
    }

    @Test
    public void fileHandling() throws Exception {
        File tmp = File.createTempFile("strat", ".tmp");
        tmp.deleteOnExit();
        String strategyContents = "Test strategy script";
        CopyCharsUtils.copy((char[])strategyContents.toCharArray(), (String)tmp.getAbsolutePath());
        CreateStrategyParameters csp = new CreateStrategyParameters(null, "mname", "JAVA", tmp, null, false);
        InputStream is = csp.getStrategySource();
        Assert.assertEquals((Object)strategyContents, (Object)IOUtils.toString((InputStream)is));
        is.close();
        CreateStrategyParameters csp2 = new CreateStrategyParameters(null, "mname", "JAVA", tmp, null, true);
        Assert.assertTrue((boolean)tmp.delete());
        Assert.assertFalse((boolean)tmp.exists());
        is = csp2.getStrategySource();
        Assert.assertEquals((Object)strategyContents, (Object)IOUtils.toString((InputStream)is));
        is.close();
    }

    private static void assertCSP(CreateStrategyParameters inParms, String inInstanceName, String inStrategyName, String inLanguage, String inParameters, boolean inRouteToServer) {
        Assert.assertEquals((Object)inInstanceName, (Object)inParms.getInstanceName());
        Assert.assertEquals((Object)inStrategyName, (Object)inParms.getStrategyName());
        Assert.assertEquals((Object)inLanguage, (Object)inParms.getLanguage());
        Assert.assertEquals((Object)inParameters, (Object)inParms.getParameters());
        Assert.assertEquals((Object)inRouteToServer, (Object)inParms.isRouteOrdersToServer());
    }
}

