/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.marketcetera.core.Util;
import org.marketcetera.core.VersionInfo;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.saclient.ConnectionException;
import org.marketcetera.saclient.ConnectionStatusListener;
import org.marketcetera.saclient.DataReceiver;
import org.marketcetera.saclient.Messages;
import org.marketcetera.saclient.MockStrategyAgent;
import org.marketcetera.saclient.SAClient;
import org.marketcetera.saclient.SAClientParameters;
import org.marketcetera.saclient.SAClientTestBase;
import org.marketcetera.saclient.SAClientVersion;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.tags.AppId;

@ClassVersion(value="$Id: SAClientConnectionTest.java 16994 2015-03-09 21:18:25Z colin $")
public class SAClientConnectionTest {
    private volatile MockStrategyAgent mAgent;

    @Test
    public void closedFailures() throws Exception {
        final SAClient saclient = MockStrategyAgent.connectTo();
        saclient.close();
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.createStrategy(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.delete(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.getInstances(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.getModuleInfo(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.getProperties(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.getProviders();
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.getStrategyCreateParms(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.setProperties(null, null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.start(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.stop(null);
            }
        };
        SAClientTestBase.MyConnectionStatusListener listener = new SAClientTestBase.MyConnectionStatusListener();
        saclient.addConnectionStatusListener((ConnectionStatusListener)listener);
        saclient.removeConnectionStatusListener((ConnectionStatusListener)listener);
        SAClientTestBase.MyDataReceiver receiver = new SAClientTestBase.MyDataReceiver();
        saclient.addDataReceiver((DataReceiver)receiver);
        saclient.removeDataReciever((DataReceiver)receiver);
        this.verifyParameters(MockStrategyAgent.DEFAULT_PARAMETERS, saclient.getParameters());
        saclient.close();
    }

    @Test
    public void disconnectedFailures() throws Exception {
        final SAClient saclient = MockStrategyAgent.connectTo();
        SAClientTestBase.MyConnectionStatusListener listener = new SAClientTestBase.MyConnectionStatusListener();
        saclient.addConnectionStatusListener((ConnectionStatusListener)listener);
        listener.reset();
        this.stopAgent();
        Assert.assertFalse((boolean)((Boolean)listener.getNext()));
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.createStrategy(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.delete(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.getInstances(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.getModuleInfo(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.getProperties(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.getProviders();
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.getStrategyCreateParms(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.setProperties(null, null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.start(null);
            }
        };
        new DisconnectedFailure(){

            protected void run() throws Exception {
                saclient.stop(null);
            }
        };
        saclient.addConnectionStatusListener((ConnectionStatusListener)listener);
        saclient.removeConnectionStatusListener((ConnectionStatusListener)listener);
        SAClientTestBase.MyDataReceiver receiver = new SAClientTestBase.MyDataReceiver();
        saclient.addDataReceiver((DataReceiver)receiver);
        saclient.removeDataReciever((DataReceiver)receiver);
        this.verifyParameters(MockStrategyAgent.DEFAULT_PARAMETERS, saclient.getParameters());
        saclient.close();
    }

    @Test
    public void nullListeners() throws Exception {
        final SAClient saclient = MockStrategyAgent.connectTo();
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                saclient.addConnectionStatusListener(null);
            }
        };
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                saclient.removeConnectionStatusListener(null);
            }
        };
        saclient.close();
    }

    @Test(timeout=100000L)
    public void connectionNotifications() throws Exception {
        SAClient client = MockStrategyAgent.connectTo();
        SAClientTestBase.MyConnectionStatusListener listener = new SAClientTestBase.MyConnectionStatusListener();
        client.addConnectionStatusListener((ConnectionStatusListener)listener);
        listener.reset();
        Assert.assertFalse((boolean)listener.hasData());
        client.close();
        Assert.assertFalse((boolean)((Boolean)listener.getNext()));
        Thread.sleep(1000L);
        Assert.assertFalse((boolean)listener.hasData());
        client = MockStrategyAgent.connectTo();
        client.addConnectionStatusListener((ConnectionStatusListener)listener);
        listener.reset();
        this.stopAgent();
        Assert.assertFalse((boolean)((Boolean)listener.getNext()));
        Thread.sleep(1000L);
        Assert.assertFalse((boolean)listener.hasData());
        client.close();
    }

    @Test(timeout=100000L)
    public void connectionListenerFailure() throws Exception {
        SAClient client = MockStrategyAgent.connectTo();
        final SAClientTestBase.MyConnectionStatusListener listener1 = new SAClientTestBase.MyConnectionStatusListener();
        SAClientTestBase.MyConnectionStatusListener listener2 = new SAClientTestBase.MyConnectionStatusListener();
        client.addConnectionStatusListener((ConnectionStatusListener)listener1);
        client.addConnectionStatusListener((ConnectionStatusListener)listener2);
        listener1.reset();
        listener2.reset();
        listener1.setFail(true);
        listener2.setFail(true);
        Assert.assertFalse((boolean)listener1.hasData());
        Assert.assertFalse((boolean)listener2.hasData());
        client.close();
        Assert.assertFalse((boolean)((Boolean)listener1.getNext()));
        Assert.assertFalse((boolean)((Boolean)listener2.getNext()));
        new ExpectedFailure<IllegalStateException>(){

            protected void run() throws Exception {
                listener1.receiveConnectionStatus(false);
            }
        };
    }

    @Test(timeout=100000L)
    public void listenerDuplicates() throws Exception {
        SAClient client = MockStrategyAgent.connectTo();
        SAClientTestBase.MyConnectionStatusListener listener = new SAClientTestBase.MyConnectionStatusListener();
        client.addConnectionStatusListener((ConnectionStatusListener)listener);
        client.addConnectionStatusListener((ConnectionStatusListener)listener);
        listener.reset();
        Assert.assertFalse((boolean)listener.hasData());
        client.close();
        Assert.assertFalse((boolean)((Boolean)listener.getNext()));
        Assert.assertFalse((boolean)((Boolean)listener.getNext()));
    }

    @Test(timeout=100000L)
    public void listenerOrder() throws Exception {
        SAClient client = MockStrategyAgent.connectTo();
        SAClientTestBase.MyConnectionStatusListener listener1 = new SAClientTestBase.MyConnectionStatusListener();
        SAClientTestBase.MyConnectionStatusListener listener2 = new SAClientTestBase.MyConnectionStatusListener();
        client.addConnectionStatusListener((ConnectionStatusListener)listener1);
        client.addConnectionStatusListener((ConnectionStatusListener)listener2);
        listener1.reset();
        listener2.reset();
        Assert.assertFalse((boolean)listener1.hasData());
        Assert.assertFalse((boolean)listener2.hasData());
        client.close();
        Assert.assertFalse((boolean)((Boolean)listener1.getNext()));
        Assert.assertFalse((boolean)((Boolean)listener2.getNext()));
        Assert.assertThat((Object)listener1.getLastAddTime(), (Matcher)Matchers.greaterThan((Comparable)listener2.getLastAddTime()));
    }

    @Test(timeout=100000L)
    public void listenerRemove() throws Exception {
        SAClient client = MockStrategyAgent.connectTo();
        SAClientTestBase.MyConnectionStatusListener listener1 = new SAClientTestBase.MyConnectionStatusListener();
        SAClientTestBase.MyConnectionStatusListener listener2 = new SAClientTestBase.MyConnectionStatusListener();
        client.addConnectionStatusListener((ConnectionStatusListener)listener1);
        client.addConnectionStatusListener((ConnectionStatusListener)listener2);
        listener1.reset();
        listener2.reset();
        Assert.assertFalse((boolean)listener1.hasData());
        Assert.assertFalse((boolean)listener2.hasData());
        client.removeConnectionStatusListener((ConnectionStatusListener)listener2);
        client.removeConnectionStatusListener((ConnectionStatusListener)new SAClientTestBase.MyConnectionStatusListener());
        client.close();
        Assert.assertFalse((boolean)((Boolean)listener1.getNext()));
        Assert.assertFalse((boolean)listener2.hasData());
        Assert.assertNull((Object)listener2.getLastAddTime());
    }

    @Test(timeout=100000L)
    public void duplicateListenerRemoveOrder() throws Exception {
        SAClient client = MockStrategyAgent.connectTo();
        SAClientTestBase.MyConnectionStatusListener listener0 = new SAClientTestBase.MyConnectionStatusListener();
        SAClientTestBase.MyConnectionStatusListener listener1 = new SAClientTestBase.MyConnectionStatusListener();
        SAClientTestBase.MyConnectionStatusListener listener2 = new SAClientTestBase.MyConnectionStatusListener();
        client.addConnectionStatusListener((ConnectionStatusListener)listener0);
        client.addConnectionStatusListener((ConnectionStatusListener)listener1);
        client.addConnectionStatusListener((ConnectionStatusListener)listener2);
        client.addConnectionStatusListener((ConnectionStatusListener)listener1);
        listener0.reset();
        listener1.reset();
        listener2.reset();
        Assert.assertFalse((boolean)listener0.hasData());
        Assert.assertFalse((boolean)listener1.hasData());
        Assert.assertFalse((boolean)listener2.hasData());
        client.removeConnectionStatusListener((ConnectionStatusListener)listener1);
        client.close();
        Assert.assertFalse((boolean)((Boolean)listener0.getNext()));
        Assert.assertFalse((boolean)((Boolean)listener1.getNext()));
        Assert.assertFalse((boolean)((Boolean)listener2.getNext()));
        Assert.assertFalse((boolean)listener1.hasData());
        Assert.assertThat((Object)listener1.getLastAddTime(), (Matcher)Matchers.greaterThan((Comparable)listener2.getLastAddTime()));
        Assert.assertThat((Object)listener0.getLastAddTime(), (Matcher)Matchers.greaterThan((Comparable)listener1.getLastAddTime()));
    }

    @Test
    public void versionTest() {
        Assert.assertEquals((Object)SAClientVersion.APP_ID_VERSION, (Object)new VersionInfo(Util.getVersion((AppId)SAClientVersion.APP_ID)));
    }

    @Before
    public void startAgent() throws Exception {
        this.mAgent = new MockStrategyAgent();
    }

    @After
    public void stopAgent() throws Exception {
        if (this.mAgent != null) {
            this.mAgent.close();
            this.mAgent = null;
        }
    }

    @BeforeClass
    public static void setup() throws Exception {
        MockStrategyAgent.startServerAndClient();
    }

    @AfterClass
    public static void teardown() throws Exception {
        MockStrategyAgent.closeServerAndClient();
    }

    private void verifyParameters(SAClientParameters inExpected, SAClientParameters inActual) {
        Assert.assertEquals((Object)inExpected.getURL(), (Object)inActual.getURL());
        Assert.assertEquals((Object)inExpected.getHostname(), (Object)inActual.getHostname());
        Assert.assertEquals((long)inExpected.getPort(), (long)inActual.getPort());
        Assert.assertEquals((Object)inExpected.getUsername(), (Object)inActual.getUsername());
        Assert.assertFalse((String)String.valueOf(inActual.getPassword()), (boolean)Arrays.equals(inExpected.getPassword(), inActual.getPassword()));
    }

    private static abstract class DisconnectedFailure
    extends ExpectedFailure<ConnectionException> {
        protected DisconnectedFailure() throws Exception {
            super((I18NBoundMessage)Messages.CLIENT_DISCONNECTED);
        }
    }
}

