/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.client.ClientManager;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.saclient.ConnectionException;
import org.marketcetera.saclient.Messages;
import org.marketcetera.saclient.MockStrategyAgent;
import org.marketcetera.saclient.SAClient;
import org.marketcetera.saclient.SAClientFactoryImpl;
import org.marketcetera.saclient.SAClientParameters;
import org.marketcetera.util.log.I18NMessage;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: SAClientFactoryTest.java 16994 2015-03-09 21:18:25Z colin $")
public class SAClientFactoryTest {
    @Test
    public void singleton() {
        Assert.assertNotNull((Object)SAClientFactoryImpl.getInstance());
        Assert.assertSame((Object)SAClientFactoryImpl.getInstance(), (Object)SAClientFactoryImpl.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void connect() throws Exception {
        String creds = "blue";
        MockStrategyAgent mockSA = new MockStrategyAgent();
        try {
            MockStrategyAgent.startServerAndClient();
            new ExpectedFailure<NullPointerException>(){

                protected void run() throws Exception {
                    SAClient client = SAClientFactoryImpl.getInstance().create(null);
                    client.start();
                }
            };
            new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_WS_CONNECT, new Object[]{"localhost", "9009", "blue"}){

                protected void run() throws Exception {
                    SAClient client = SAClientFactoryImpl.getInstance().create(new SAClientParameters("blue", "blue".toCharArray(), "tcp://localhost:61617", "localhost", 9009));
                    client.start();
                }
            };
            String url = "tcp://localhost:61619";
            new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_JMS_CONNECT, new Object[]{"tcp://localhost:61619", "blue"}){

                protected void run() throws Exception {
                    SAClient client = SAClientFactoryImpl.getInstance().create(new SAClientParameters("blue", "blue".toCharArray(), "tcp://localhost:61619", "localhost", 9001));
                    client.start();
                }
            };
            new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_WS_CONNECT, new Object[]{"localhost", String.valueOf(9001), "blue"}){

                protected void run() throws Exception {
                    SAClient client = SAClientFactoryImpl.getInstance().create(new SAClientParameters("blue", "bleh".toCharArray(), "tcp://localhost:61617", "localhost", 9001));
                    client.start();
                }
            };
            String username = "incorrect";
            new ExpectedFailure<ConnectionException>((I18NMessage)Messages.ERROR_JMS_CONNECT, new Object[]{"tcp://localhost:61619", "incorrect"}){

                protected void run() throws Exception {
                    SAClient client = SAClientFactoryImpl.getInstance().create(new SAClientParameters("incorrect", "incorrect".toCharArray(), "tcp://localhost:61619", "localhost", 9001));
                    client.start();
                }
            };
            Assert.assertTrue((boolean)ClientManager.getInstance().isCredentialsMatch("blue", "blue".toCharArray()));
            SAClient client = SAClientFactoryImpl.getInstance().create(new SAClientParameters("blue", "blue".toCharArray(), "tcp://localhost:61617", "localhost", 9001));
            client.start();
            client.close();
        }
        finally {
            MockStrategyAgent.closeServerAndClient();
            mockSA.close();
        }
    }
}

