/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.client.ClientTest;
import org.marketcetera.core.notifications.Notification;
import org.marketcetera.event.EventTestBase;
import org.marketcetera.module.CopierModuleFactory;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.DataRequest;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.modules.remote.receiver.ReceiverFactory;
import org.marketcetera.saclient.DataReceiver;
import org.marketcetera.saclient.SAClientTestBase;
import org.marketcetera.trade.Equity;
import org.marketcetera.trade.ExecutionReport;
import org.marketcetera.trade.FIXOrder;
import org.marketcetera.trade.OrderCancel;
import org.marketcetera.trade.OrderCancelReject;
import org.marketcetera.trade.OrderReplace;
import org.marketcetera.trade.OrderSingle;
import org.marketcetera.trade.TypesTestBase;
import org.marketcetera.util.misc.ClassVersion;

@ClassVersion(value="$Id: SAClientJMSTest.java 17821 2019-01-14 16:36:54Z colin $")
public class SAClientJMSTest
extends SAClientTestBase {
    private final SAClientTestBase.MyDataReceiver mReceiver1 = new SAClientTestBase.MyDataReceiver();
    private final SAClientTestBase.MyDataReceiver mReceiver2 = new SAClientTestBase.MyDataReceiver();

    @Test
    public void nullReceiver() throws Exception {
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                SAClientTestBase.getClient().addDataReceiver(null);
            }
        };
        new ExpectedFailure<NullPointerException>(){

            protected void run() throws Exception {
                SAClientTestBase.getClient().removeDataReciever(null);
            }
        };
    }

    @Test(timeout=1000000L)
    public void simpleReceive() throws Exception {
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver1);
        this.runTest(new TestVerifier(){

            @Override
            public void verifyExpected(Object inExpected) throws Exception {
                SAClientJMSTest.this.verifyEquals(inExpected, SAClientJMSTest.this.mReceiver1.getNext());
            }
        });
    }

    @Test(timeout=10000L)
    public void dualReceivers() throws Exception {
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver1);
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver2);
        this.runTest(new TestVerifier(){

            @Override
            public void verifyExpected(Object inExpected) throws Exception {
                SAClientJMSTest.this.verifyEquals(inExpected, SAClientJMSTest.this.mReceiver1.getNext());
                Assert.assertTrue((boolean)SAClientJMSTest.this.mReceiver2.hasData());
                SAClientJMSTest.this.verifyEquals(inExpected, SAClientJMSTest.this.mReceiver2.getNext());
            }
        });
        Assert.assertThat((Object)this.mReceiver1.getLastAddTime(), (Matcher)Matchers.greaterThan((Comparable)this.mReceiver2.getLastAddTime()));
    }

    @Test(timeout=10000L)
    public void receiverFailure() throws Exception {
        this.mReceiver1.setFail(true);
        this.mReceiver2.setFail(true);
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver1);
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver2);
        this.runTest(new TestVerifier(){

            @Override
            public void verifyExpected(Object inExpected) throws Exception {
                SAClientJMSTest.this.verifyEquals(inExpected, SAClientJMSTest.this.mReceiver1.getNext());
                Assert.assertTrue((boolean)SAClientJMSTest.this.mReceiver2.hasData());
                SAClientJMSTest.this.verifyEquals(inExpected, SAClientJMSTest.this.mReceiver2.getNext());
            }
        });
        new ExpectedFailure<IllegalStateException>(){

            protected void run() throws Exception {
                SAClientJMSTest.this.mReceiver1.receiveData(new Object());
            }
        };
    }

    @Test(timeout=10000L)
    public void noReceiveOnRemove() throws Exception {
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver1);
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver2);
        SAClientJMSTest.getClient().removeDataReciever((DataReceiver)this.mReceiver1);
        this.runTest(new TestVerifier(){

            @Override
            public void verifyExpected(Object inExpected) throws Exception {
                SAClientJMSTest.this.verifyEquals(inExpected, SAClientJMSTest.this.mReceiver2.getNext());
            }
        });
    }

    @Test(timeout=10000L)
    public void noReceivers() throws Exception {
        this.runTest(new TestVerifier(){

            @Override
            public void verifyExpected(Object inExpected) throws Exception {
                Thread.sleep(300L);
            }
        });
    }

    @Test(timeout=10000L)
    public void allReceiversRemoved() throws Exception {
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver1);
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver2);
        SAClientJMSTest.getClient().removeDataReciever((DataReceiver)this.mReceiver1);
        SAClientJMSTest.getClient().removeDataReciever((DataReceiver)this.mReceiver2);
        SAClientJMSTest.getClient().removeDataReciever((DataReceiver)new SAClientTestBase.MyDataReceiver());
        this.runTest(new TestVerifier(){

            @Override
            public void verifyExpected(Object inExpected) throws Exception {
                Thread.sleep(300L);
            }
        });
    }

    @Test(timeout=10000L)
    public void receiverAddedTwice() throws Exception {
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver1);
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver1);
        this.runTest(new TestVerifier(){

            @Override
            public void verifyExpected(Object inExpected) throws Exception {
                SAClientJMSTest.this.verifyEquals(inExpected, SAClientJMSTest.this.mReceiver1.getNext());
                SAClientJMSTest.this.verifyEquals(inExpected, SAClientJMSTest.this.mReceiver1.getNext());
            }
        });
    }

    @Test(timeout=10000L)
    public void duplicateReceiverRemove() throws Exception {
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver1);
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver2);
        SAClientJMSTest.getClient().addDataReceiver((DataReceiver)this.mReceiver1);
        SAClientJMSTest.getClient().removeDataReciever((DataReceiver)this.mReceiver1);
        this.runTest(new TestVerifier(){

            @Override
            public void verifyExpected(Object inExpected) throws Exception {
                SAClientJMSTest.this.verifyEquals(inExpected, SAClientJMSTest.this.mReceiver1.getNext());
                Assert.assertTrue((boolean)SAClientJMSTest.this.mReceiver2.hasData());
                SAClientJMSTest.this.verifyEquals(inExpected, SAClientJMSTest.this.mReceiver2.getNext());
            }
        });
        Assert.assertThat((Object)this.mReceiver1.getLastAddTime(), (Matcher)Matchers.greaterThan((Comparable)this.mReceiver2.getLastAddTime()));
    }

    @After
    public void resetReceivers() {
        SAClientJMSTest.getClient().removeDataReciever((DataReceiver)this.mReceiver1);
        SAClientJMSTest.getClient().removeDataReciever((DataReceiver)this.mReceiver2);
        this.mReceiver1.reset();
        this.mReceiver2.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(TestVerifier inVerifier) throws Exception {
        Object[] data = this.createTestObjects();
        this.assertReceiversHaveNoData();
        DataFlowID flowID = SAClientJMSTest.emitData(data);
        try {
            for (Object expected : data) {
                if (expected == null) continue;
                inVerifier.verifyExpected(expected);
            }
        }
        finally {
            if (flowID != null) {
                SAClientJMSTest.getMM().cancel(flowID);
            }
        }
        this.assertReceiversHaveNoData();
    }

    private void assertReceiversHaveNoData() {
        Assert.assertFalse((boolean)this.mReceiver1.hasData());
        Assert.assertFalse((boolean)this.mReceiver2.hasData());
    }

    private void verifyEquals(Object inExpected, Object inActual) {
        if (inExpected instanceof OrderSingle) {
            TypesTestBase.assertOrderSingleEquals((OrderSingle)((OrderSingle)inExpected), (OrderSingle)((OrderSingle)inActual));
        } else if (inExpected instanceof OrderReplace) {
            TypesTestBase.assertOrderReplaceEquals((OrderReplace)((OrderReplace)inExpected), (OrderReplace)((OrderReplace)inActual));
        } else if (inExpected instanceof OrderCancel) {
            TypesTestBase.assertOrderCancelEquals((OrderCancel)((OrderCancel)inExpected), (OrderCancel)((OrderCancel)inActual));
        } else if (inExpected instanceof FIXOrder) {
            TypesTestBase.assertOrderFIXEquals((FIXOrder)((FIXOrder)inExpected), (FIXOrder)((FIXOrder)inActual));
        } else if (inExpected instanceof OrderCancelReject) {
            TypesTestBase.assertCancelRejectEquals((OrderCancelReject)((OrderCancelReject)inExpected), (OrderCancelReject)((OrderCancelReject)inActual));
        } else if (inExpected instanceof ExecutionReport) {
            TypesTestBase.assertExecReportEquals((ExecutionReport)((ExecutionReport)inExpected), (ExecutionReport)((ExecutionReport)inActual));
        } else if (inExpected instanceof Notification) {
            Assert.assertEquals((Object)inExpected.toString(), (Object)inActual.toString());
        } else {
            Assert.assertEquals((Object)inExpected, (Object)inActual);
        }
    }

    private Object[] createTestObjects() throws Exception {
        return new Object[]{EventTestBase.generateEquityAskEvent((long)1L, (long)2L, (Equity)new Equity("asym"), (String)"ex", (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.TEN), EventTestBase.generateEquityBidEvent((long)3L, (long)4L, (Equity)new Equity("bsym"), (String)"ex", (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.TEN), EventTestBase.generateEquityTradeEvent((long)5L, (long)6L, (Equity)new Equity("csym"), (String)"ex", (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.TEN), ClientTest.createOrderSingle(), ClientTest.createOrderReplace(), ClientTest.createOrderCancel(), ClientTest.createOrderFIX(), ClientTest.createCancelReject(), ClientTest.createExecutionReport(), Notification.error((String)"Subject", (String)"body", (String)"test.notification"), BigInteger.ONE, null, "Test String"};
    }

    private static DataFlowID emitData(Object ... inData) throws Exception {
        return SAClientJMSTest.getMM().createDataFlow(new DataRequest[]{new DataRequest(CopierModuleFactory.INSTANCE_URN, (Object)inData), new DataRequest(ReceiverFactory.INSTANCE_URN)}, false);
    }

    private static interface TestVerifier {
        public void verifyExpected(Object var1) throws Exception;
    }
}

