/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import org.junit.Assert;
import org.junit.Test;
import org.marketcetera.saclient.SAClientParameters;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.test.EqualityAssert;

@ClassVersion(value="$Id: SAClientParametersTest.java 16154 2012-07-14 16:34:05Z colin $")
public class SAClientParametersTest {
    @Test
    public void constructAndGet() {
        SAClientParameters scp = new SAClientParameters(null, null, null, null, -1);
        SAClientParametersTest.assertParameters(scp, null, null, null, null, -1);
        scp = new SAClientParameters("", "".toCharArray(), "", "", 0);
        SAClientParametersTest.assertParameters(scp, "", "".toCharArray(), "", "", 0);
        String user = "you";
        char[] password = "nu".toCharArray();
        String url = "tcp://localghost:9001";
        String host = "localmost";
        int port = 61617;
        scp = new SAClientParameters(user, password, url, host, port);
        SAClientParametersTest.assertParameters(scp, user, password, url, host, port);
        char[] expectedPass = scp.getPassword();
        Assert.assertArrayEquals((char[])expectedPass, (char[])password);
        password[0] = 108;
        Assert.assertArrayEquals((char[])expectedPass, (char[])scp.getPassword());
        password = scp.getPassword();
        password[0] = 108;
        Assert.assertArrayEquals((char[])expectedPass, (char[])scp.getPassword());
    }

    @Test
    public void equality() {
        EqualityAssert.assertEquality((Object)new SAClientParameters("you", "nu".toCharArray(), "tcp://zoo:91", "ghost", 2001), (Object)new SAClientParameters("you", "nu".toCharArray(), "tcp://zoo:91", "ghost", 2001), (Object[])new Object[]{new SAClientParameters("your", "nu".toCharArray(), "tcp://zoo:91", "ghost", 2001), new SAClientParameters("you", "nul".toCharArray(), "tcp://zoo:91", "ghost", 2001), new SAClientParameters("you", "nu".toCharArray(), "tcp://zoo:919", "ghost", 2001), new SAClientParameters("you", "nu".toCharArray(), "tcp://zoo:91", "most", 2001), new SAClientParameters("you", "nu".toCharArray(), "tcp://zoo:91", "ghost", 2003), new SAClientParameters(null, null, null, null, -1)});
    }

    @Test
    public void string() {
        SAClientParameters parm = new SAClientParameters("you", "nu".toCharArray(), "tcp://zoo:91", "ghost", 2001);
        String string = parm.toString();
        Assert.assertTrue((String)string, (boolean)string.contains("you"));
        Assert.assertFalse((String)string, (boolean)string.contains("nu"));
        Assert.assertTrue((String)string, (boolean)string.contains("tcp://zoo:91"));
        Assert.assertTrue((String)string, (boolean)string.contains("ghost"));
        Assert.assertTrue((String)string, (boolean)string.contains("2001"));
    }

    private static void assertParameters(SAClientParameters inActual, String inExpectedUsername, char[] inExpectedPassword, String inExpectedURL, String inExpectedHostName, int inExpectedPort) {
        Assert.assertEquals((Object)inExpectedUsername, (Object)inActual.getUsername());
        Assert.assertArrayEquals((char[])inExpectedPassword, (char[])inActual.getPassword());
        Assert.assertEquals((Object)inExpectedURL, (Object)inActual.getURL());
        Assert.assertEquals((Object)inExpectedHostName, (Object)inActual.getHostname());
        Assert.assertEquals((long)inExpectedPort, (long)inActual.getPort());
    }
}

