/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.junit.After;
import org.junit.Before;
import org.marketcetera.module.ModuleManager;
import org.marketcetera.saclient.ConnectionStatusListener;
import org.marketcetera.saclient.DataReceiver;
import org.marketcetera.saclient.MockSAServiceImpl;
import org.marketcetera.saclient.MockStrategyAgent;
import org.marketcetera.saclient.SAClient;
import org.marketcetera.saclient.SAClientParameters;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.ContextClassProvider;

@ClassVersion(value="$Id: SAClientTestBase.java 16994 2015-03-09 21:18:25Z colin $")
public class SAClientTestBase {
    protected static volatile MockStrategyAgent sMockSA;
    protected static volatile SAClient sClient;

    @Before
    public void before() throws Exception {
        MockStrategyAgent.setContextClassProvider(this.getContextClassProvider());
        MockStrategyAgent.startServerAndClient();
        SAClientTestBase.startAgent();
        SAClientParameters defaultParams = MockStrategyAgent.DEFAULT_PARAMETERS;
        SAClientParameters modifiedParams = new SAClientParameters(defaultParams.getUsername(), defaultParams.getPassword(), defaultParams.getURL(), defaultParams.getHostname(), defaultParams.getPort(), this.getContextClassProvider());
        sClient = MockStrategyAgent.connectTo(modifiedParams);
    }

    @After
    public void teardown() throws Exception {
        if (sClient != null) {
            sClient.close();
            sClient = null;
        }
        SAClientTestBase.stopAgent();
        MockStrategyAgent.closeServerAndClient();
    }

    protected ContextClassProvider getContextClassProvider() {
        return null;
    }

    protected static void startAgent() throws Exception {
        sMockSA = new MockStrategyAgent();
    }

    protected static void stopAgent() throws Exception {
        if (sMockSA != null) {
            sMockSA.close();
            sMockSA = null;
        }
    }

    protected static void resetServiceParameters() {
        SAClientTestBase.getMockSAService().reset();
    }

    protected static SAClient getClient() {
        return sClient;
    }

    protected static ModuleManager getMM() {
        return sMockSA.getManager();
    }

    protected static MockSAServiceImpl getMockSAService() {
        return sMockSA.getService();
    }

    private static class ObjectQueue<T> {
        private volatile boolean mFail;
        private volatile Date mLastAdd;
        private final BlockingQueue<T> mData = new LinkedBlockingQueue<T>();

        private ObjectQueue() {
        }

        protected void add(T inValue) {
            this.mLastAdd = new Date();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mData.add(inValue);
            if (this.isFail()) {
                throw new IllegalStateException();
            }
        }

        public T getNext() throws InterruptedException {
            return this.mData.take();
        }

        public boolean hasData() {
            return !this.mData.isEmpty();
        }

        public boolean isFail() {
            return this.mFail;
        }

        public void setFail(boolean inFail) {
            this.mFail = inFail;
        }

        public Date getLastAddTime() {
            return this.mLastAdd;
        }

        public void reset() {
            this.setFail(false);
            this.mData.clear();
            this.mLastAdd = null;
        }
    }

    protected static class MyConnectionStatusListener
    extends ObjectQueue<Boolean>
    implements ConnectionStatusListener {
        protected MyConnectionStatusListener() {
        }

        public void receiveConnectionStatus(boolean inStatus) {
            this.add(inStatus);
        }
    }

    protected static class MyDataReceiver
    extends ObjectQueue<Object>
    implements DataReceiver {
        protected MyDataReceiver() {
        }

        public void receiveData(Object inObject) {
            this.add(inObject);
        }
    }
}

