/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient.rpc;

import java.io.File;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.marketcetera.marketdata.MarketDataFeedTestBase;
import org.marketcetera.module.DataFlowID;
import org.marketcetera.module.ExpectedFailure;
import org.marketcetera.module.ModuleInfo;
import org.marketcetera.module.ModuleState;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.saclient.ConnectionException;
import org.marketcetera.saclient.ConnectionStatusListener;
import org.marketcetera.saclient.CreateStrategyParameters;
import org.marketcetera.saclient.SAClientParameters;
import org.marketcetera.saclient.rpc.MockAuthenticator;
import org.marketcetera.saclient.rpc.MockSAClientServiceAdapter;
import org.marketcetera.saclient.rpc.MockSession;
import org.marketcetera.saclient.rpc.RpcSAClientFactory;
import org.marketcetera.saclient.rpc.RpcSAClientImpl;
import org.marketcetera.saclient.rpc.SAClientContextClassProvider;
import org.marketcetera.saclient.rpc.SAClientRpcService;
import org.marketcetera.saclient.rpc.SAServiceAdapter;
import org.marketcetera.trade.TradeContextClassProvider;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.rpc.RpcServer;
import org.marketcetera.util.ws.ContextClassProvider;
import org.marketcetera.util.ws.stateful.Authenticator;
import org.marketcetera.util.ws.stateful.SessionManager;

public class RpcSAClientImplTest {
    private MockSAClientServiceAdapter serviceAdapter;
    private MockAuthenticator authenticator;
    private SessionManager<MockSession> sessionManager;
    private String hostname;
    private int port;
    private static final int MIN_PORT_NUMBER = 10000;
    private static final int MAX_PORT_NUMBER = 65535;
    private RpcSAClientImpl client;
    private RpcServer<MockSession> server;

    @Before
    public void setup() throws Exception {
        this.stopClientServer();
        this.hostname = "127.0.0.1";
        this.port = -1;
        this.sessionManager = new SessionManager();
        this.authenticator = new MockAuthenticator();
        this.serviceAdapter = new MockSAClientServiceAdapter();
        this.startClientServer();
        Assert.assertTrue((boolean)this.server.isRunning());
        Assert.assertTrue((boolean)this.client.isRunning());
    }

    @After
    public void after() throws Exception {
        this.stopClientServer();
    }

    @Test
    public void testDisconnection() throws Exception {
        final AtomicBoolean status = new AtomicBoolean(false);
        ConnectionStatusListener statusListener = new ConnectionStatusListener(){

            public void receiveConnectionStatus(boolean inStatus) {
                status.set(inStatus);
            }
        };
        this.client.addConnectionStatusListener(statusListener);
        Assert.assertTrue((boolean)status.get());
        this.server.stop();
        Assert.assertFalse((boolean)this.server.isRunning());
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return !RpcSAClientImplTest.this.client.isRunning();
            }
        });
        Assert.assertFalse((boolean)status.get());
        this.server.start();
        Assert.assertTrue((boolean)this.server.isRunning());
        MarketDataFeedTestBase.wait((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return RpcSAClientImplTest.this.client.isRunning();
            }
        });
        Assert.assertTrue((boolean)status.get());
    }

    @Test
    public void testGetProviders() throws Exception {
        List<ModuleURN> providersToReturn = this.serviceAdapter.getProvidersToReturn();
        Assert.assertTrue((boolean)providersToReturn.isEmpty());
        Assert.assertEquals((long)0L, (long)this.serviceAdapter.getProvidersCount().get());
        List providers = this.client.getProviders();
        Assert.assertEquals(providersToReturn, (Object)providers);
        Assert.assertEquals((long)1L, (long)this.serviceAdapter.getProvidersCount().get());
        providersToReturn.add(new ModuleURN("this:is:provider"));
        providersToReturn.add(new ModuleURN("this:is:otherprovider"));
        providers = this.client.getProviders();
        Assert.assertEquals(providersToReturn, (Object)providers);
        Assert.assertEquals((long)2L, (long)this.serviceAdapter.getProvidersCount().get());
    }

    @Test
    public void testGetInstances() throws Exception {
        List<ModuleURN> instancesToReturn = this.serviceAdapter.getInstancesToReturn();
        Assert.assertTrue((boolean)instancesToReturn.isEmpty());
        Assert.assertTrue((boolean)this.serviceAdapter.getInstancesRequests().isEmpty());
        ModuleURN provider = new ModuleURN("this:is:provider");
        List instances = this.client.getInstances(provider);
        Assert.assertEquals(instancesToReturn, (Object)instances);
        Assert.assertEquals((long)1L, (long)this.serviceAdapter.getInstancesRequests().size());
        instancesToReturn.add(new ModuleURN("this:is:instance:first"));
        instancesToReturn.add(new ModuleURN("this:is:instance:second"));
        instances = this.client.getInstances(provider);
        Assert.assertEquals(instancesToReturn, (Object)instances);
        Assert.assertEquals((long)2L, (long)this.serviceAdapter.getInstancesRequests().size());
    }

    @Test
    public void testGetModuleInfo() throws Exception {
        Assert.assertNull((Object)this.serviceAdapter.getModuleInfoToReturn());
        Assert.assertTrue((boolean)this.serviceAdapter.getModuleInfoRequests().isEmpty());
        ModuleURN instance = new ModuleURN("this:is:instance:first");
        ModuleInfo info = this.client.getModuleInfo(instance);
        Assert.assertNull((Object)info);
        ModuleInfo infoToReturn = new ModuleInfo(instance, ModuleState.CREATED, new DataFlowID[0], new DataFlowID[]{new DataFlowID("some-data-flow-id"), new DataFlowID("some-other-data-flow-id")}, new Date(), new Date(), new Date(), true, false, true, false, true, null, "some failure", Integer.MAX_VALUE, true, 0);
        this.serviceAdapter.setModuleInfoToReturn(infoToReturn);
        ModuleInfo returnedInfo = this.client.getModuleInfo(instance);
        Assert.assertNotNull((Object)returnedInfo);
    }

    @Test
    public void testStart() throws Exception {
        Assert.assertTrue((boolean)this.serviceAdapter.getStartRequests().isEmpty());
        ModuleURN instance = new ModuleURN("this:is:instance:first");
        this.client.start(instance);
        Assert.assertEquals((long)1L, (long)this.serviceAdapter.getStartRequests().size());
    }

    @Test
    public void testStop() throws Exception {
        Assert.assertTrue((boolean)this.serviceAdapter.getStopRequests().isEmpty());
        ModuleURN instance = new ModuleURN("this:is:instance:first");
        this.client.stop(instance);
        Assert.assertEquals((long)1L, (long)this.serviceAdapter.getStopRequests().size());
    }

    @Test
    public void testDelete() throws Exception {
        Assert.assertTrue((boolean)this.serviceAdapter.getDeleteRequests().isEmpty());
        ModuleURN instance = new ModuleURN("this:is:instance:first");
        this.client.delete(instance);
        Assert.assertEquals((long)1L, (long)this.serviceAdapter.getDeleteRequests().size());
    }

    @Test
    public void testGetProperties() throws Exception {
        Map<String, Object> propertiesToReturn = this.serviceAdapter.getPropertiesToReturn();
        Assert.assertTrue((boolean)propertiesToReturn.isEmpty());
        ModuleURN instance = new ModuleURN("this:is:instance:first");
        Map returnedProperties = this.client.getProperties(instance);
        Assert.assertEquals(propertiesToReturn, (Object)returnedProperties);
        propertiesToReturn.put("key1", "value1");
        propertiesToReturn.put("key2", "value2");
        returnedProperties = this.client.getProperties(instance);
        Assert.assertEquals(propertiesToReturn, (Object)returnedProperties);
    }

    @Test
    public void testSetProperties() throws Exception {
        Map<String, Object> propertiesToReturn = this.serviceAdapter.getPropertiesToReturn();
        Assert.assertTrue((boolean)propertiesToReturn.isEmpty());
        ModuleURN instance = new ModuleURN("this:is:instance:first");
        Map returnedProperties = this.client.setProperties(instance, propertiesToReturn);
        Assert.assertEquals(propertiesToReturn, (Object)returnedProperties);
        propertiesToReturn.put("key1", "value1");
        propertiesToReturn.put("key2", "value2");
        returnedProperties = this.client.setProperties(instance, propertiesToReturn);
        Assert.assertEquals(propertiesToReturn, (Object)returnedProperties);
    }

    @Test
    public void testCreateStrategy() throws Exception {
        Assert.assertTrue((boolean)this.serviceAdapter.getCreateStrategyRequests().isEmpty());
        CreateStrategyParameters parameters = new CreateStrategyParameters("instance", "strategy", "language", this.generateStrategySource(), "key=value:key1=value1:key2=value2", true);
        ModuleURN instance = new ModuleURN("this:is:my:instance");
        this.serviceAdapter.setCreateModuleURNToReturn(instance);
        instance = this.client.createStrategy(parameters);
        Assert.assertNotNull((Object)instance);
    }

    @Test
    public void testGetStrategyCreateParms() throws Exception {
        ModuleURN instance = new ModuleURN("this:is:my:instance");
        CreateStrategyParameters parameters = new CreateStrategyParameters("instance", "strategy", "language", this.generateStrategySource(), "key=value:key1=value1:key2=value2", true);
        this.serviceAdapter.setParametersToReturn(parameters);
        parameters = this.client.getStrategyCreateParms(instance);
        Assert.assertNotNull((Object)parameters);
    }

    @Test
    public void testSendData() throws Exception {
        Assert.assertNull((Object)this.serviceAdapter.getSentData());
        new ExpectedFailure<ConnectionException>(){

            protected void run() throws Exception {
                RpcSAClientImplTest.this.client.sendData((Object)this);
            }
        };
        String data = "Lorum ipsum";
        this.client.sendData((Object)data);
        Assert.assertEquals((Object)data, (Object)this.serviceAdapter.getSentData());
    }

    private File generateStrategySource() throws IOException {
        File tmpFile = File.createTempFile("src", "txt");
        tmpFile.deleteOnExit();
        FileUtils.writeStringToFile((File)tmpFile, (String)"Lorum ipsum");
        return tmpFile;
    }

    private void stopClientServer() throws Exception {
        if (this.client != null && this.client.isRunning()) {
            try {
                this.client.stop();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
            }
        }
        this.client = null;
        if (this.server != null && this.server.isRunning()) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
            }
        }
        this.server = null;
    }

    private void startClientServer() throws Exception {
        this.server = new RpcServer();
        this.server.setHostname(this.hostname);
        if (this.port == -1) {
            this.port = this.assignPort();
        }
        this.server.setPort(this.port);
        this.server.setSessionManager(this.sessionManager);
        this.server.setAuthenticator((Authenticator)this.authenticator);
        this.server.setContextClassProvider((ContextClassProvider)TradeContextClassProvider.INSTANCE);
        SAClientRpcService service = new SAClientRpcService();
        this.server.getServiceSpecs().add(service);
        service.setServiceAdapter((SAServiceAdapter)this.serviceAdapter);
        this.server.setContextClassProvider((ContextClassProvider)SAClientContextClassProvider.INSTANCE);
        this.server.start();
        this.client = new RpcSAClientFactory().create(new SAClientParameters("username", "password".toCharArray(), "", this.hostname, this.port, null, false));
        this.client.setContextClassProvider((ContextClassProvider)SAClientContextClassProvider.INSTANCE);
        this.client.start();
    }

    /*
     * Loose catch block
     */
    private int assignPort() {
        int i = 10000;
        while (i <= 65535) {
            int n;
            Throwable throwable;
            DatagramSocket ds;
            Throwable throwable2;
            ServerSocket ss;
            block29: {
                block30: {
                    block27: {
                        block28: {
                            ss = new ServerSocket(i);
                            throwable2 = null;
                            ss.setReuseAddress(true);
                            ds = new DatagramSocket(i);
                            throwable = null;
                            ds.setReuseAddress(true);
                            n = i;
                            if (ds == null) break block27;
                            if (throwable == null) break block28;
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block27;
                        }
                        ds.close();
                    }
                    if (ss == null) break block29;
                    if (throwable2 == null) break block30;
                    try {
                        ss.close();
                    }
                    catch (Throwable throwable4) {
                        throwable2.addSuppressed(throwable4);
                    }
                    break block29;
                }
                ss.close();
            }
            return n;
            {
                catch (Throwable throwable5) {
                    try {
                        try {
                            try {
                                try {
                                    throwable = throwable5;
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    if (ds != null) {
                                        if (throwable != null) {
                                            try {
                                                ds.close();
                                            }
                                            catch (Throwable throwable7) {
                                                throwable.addSuppressed(throwable7);
                                            }
                                        } else {
                                            ds.close();
                                        }
                                    }
                                    throw throwable6;
                                }
                            }
                            catch (Throwable throwable8) {
                                throwable2 = throwable8;
                                throw throwable8;
                            }
                        }
                        catch (Throwable throwable9) {
                            if (ss != null) {
                                if (throwable2 != null) {
                                    try {
                                        ss.close();
                                    }
                                    catch (Throwable throwable10) {
                                        throwable2.addSuppressed(throwable10);
                                    }
                                } else {
                                    ss.close();
                                }
                            }
                            throw throwable9;
                        }
                    }
                    catch (IOException iOException) {
                        ++i;
                    }
                }
            }
        }
        throw new IllegalArgumentException("No available ports");
    }
}

