/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.IOUtils;
import org.marketcetera.util.misc.ClassVersion;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="createStrategyParameters")
@ClassVersion(value="$Id: CreateStrategyParameters.java 17591 2017-10-17 21:41:21Z colin $")
public final class CreateStrategyParameters
implements Serializable {
    private final String mInstanceName;
    private final String mStrategyName;
    private final String mLanguage;
    private final String mParameters;
    private final boolean mRouteOrdersToServer;
    private final String mStrategySource;
    private static final long serialVersionUID = -4937743911766362165L;

    public CreateStrategyParameters(String inInstanceName, String inStrategyName, String inLanguage, File inStrategySource, String inParameters, boolean inRouteOrdersToServer) throws IOException {
        if (inStrategyName == null) {
            throw new NullPointerException();
        }
        if (inLanguage == null) {
            throw new NullPointerException();
        }
        if (inStrategySource == null) {
            throw new NullPointerException();
        }
        if (!inStrategySource.isFile() || !inStrategySource.canRead()) {
            throw new FileNotFoundException(inStrategySource.getAbsolutePath());
        }
        this.mInstanceName = inInstanceName;
        this.mStrategyName = inStrategyName;
        this.mLanguage = inLanguage;
        this.mStrategySource = IOUtils.toString((InputStream)new FileInputStream(inStrategySource));
        this.mParameters = inParameters;
        this.mRouteOrdersToServer = inRouteOrdersToServer;
    }

    public String getInstanceName() {
        return this.mInstanceName;
    }

    public String getStrategyName() {
        return this.mStrategyName;
    }

    public String getLanguage() {
        return this.mLanguage;
    }

    public InputStream getStrategySource() throws IOException {
        return IOUtils.toInputStream((String)this.mStrategySource);
    }

    public String getParameters() {
        return this.mParameters;
    }

    public boolean isRouteOrdersToServer() {
        return this.mRouteOrdersToServer;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CreateStrategyParameters [mInstanceName=").append(this.mInstanceName).append(", mStrategyName=").append(this.mStrategyName).append(", mLanguage=").append(this.mLanguage).append(", mParameters=").append(this.mParameters).append(", mRouteOrdersToServer=").append(this.mRouteOrdersToServer).append(", mStrategySource=").append(this.mStrategySource).append("]");
        return builder.toString();
    }

    private CreateStrategyParameters() {
        this.mInstanceName = null;
        this.mStrategyName = null;
        this.mLanguage = null;
        this.mStrategySource = null;
        this.mParameters = null;
        this.mRouteOrdersToServer = false;
    }
}

