/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.marketcetera.module.ModuleInfo;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.saclient.AbstractSAClient;
import org.marketcetera.saclient.ConnectionException;
import org.marketcetera.saclient.CreateStrategyParameters;
import org.marketcetera.saclient.Messages;
import org.marketcetera.saclient.SAClientParameters;
import org.marketcetera.saclient.SAClientVersion;
import org.marketcetera.saclient.SAService;
import org.marketcetera.util.log.I18NBoundMessage;
import org.marketcetera.util.log.I18NBoundMessage3P;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.ws.stateful.Client;
import org.marketcetera.util.ws.stateful.ClientContext;
import org.marketcetera.util.ws.wrappers.MapWrapper;

@ClassVersion(value="$Id: SAClientImpl.java 16879 2014-04-15 21:40:25Z colin $")
class SAClientImpl
extends AbstractSAClient {
    private Client mServiceClient;
    private SAService mSAService;

    @Override
    public List<ModuleURN> getProviders() throws ConnectionException {
        this.failIfDisconnected();
        try {
            ArrayList list = this.mSAService.getProviders(this.getServiceContext());
            return list != null ? list : new ArrayList();
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public List<ModuleURN> getInstances(ModuleURN inProviderURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            ArrayList list = this.mSAService.getInstances(this.getServiceContext(), inProviderURN);
            return list != null ? list : new ArrayList();
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public ModuleInfo getModuleInfo(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            return this.mSAService.getModuleInfo(this.getServiceContext(), inURN);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public void start(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            this.mSAService.start(this.getServiceContext(), inURN);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public void stop(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            this.mSAService.stop(this.getServiceContext(), inURN);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public void delete(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            this.mSAService.delete(this.getServiceContext(), inURN);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public Map<String, Object> getProperties(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            MapWrapper<String, Object> value = this.mSAService.getProperties(this.getServiceContext(), inURN);
            return value == null ? null : value.getMap();
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public Map<String, Object> setProperties(ModuleURN inURN, Map<String, Object> inProperties) throws ConnectionException {
        this.failIfDisconnected();
        try {
            MapWrapper<String, Object> map = this.mSAService.setProperties(this.getServiceContext(), inURN, (MapWrapper<String, Object>)new MapWrapper(inProperties));
            return map == null ? null : map.getMap();
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public ModuleURN createStrategy(CreateStrategyParameters inParameters) throws ConnectionException {
        this.failIfDisconnected();
        try {
            return this.mSAService.createStrategy(this.getServiceContext(), inParameters);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public CreateStrategyParameters getStrategyCreateParms(ModuleURN inURN) throws ConnectionException {
        this.failIfDisconnected();
        try {
            return this.mSAService.getStrategyCreateParms(this.getServiceContext(), inURN);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    @Override
    public void sendData(Object inData) throws ConnectionException {
        this.failIfDisconnected();
        try {
            this.mSAService.sendData(this.getServiceContext(), inData);
        }
        catch (Exception e) {
            throw this.wrapRemoteFailure(e);
        }
    }

    SAClientImpl(SAClientParameters inParameters) throws ConnectionException {
        super(inParameters);
    }

    @Override
    protected void doStop() {
        try {
            if (this.mServiceClient != null) {
                this.mServiceClient.logout();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.mServiceClient = null;
        }
    }

    @Override
    protected void doStart() {
        try {
            this.mServiceClient = new Client(this.parameters.getHostname(), this.parameters.getPort(), SAClientVersion.APP_ID, this.parameters.getContextClassProvider());
            this.mServiceClient.login(this.parameters.getUsername(), this.parameters.getPassword());
            this.mSAService = (SAService)this.mServiceClient.getService(SAService.class);
        }
        catch (Exception e) {
            throw new ConnectionException(e, (I18NBoundMessage)new I18NBoundMessage3P(Messages.ERROR_WS_CONNECT, (Serializable)((Object)this.parameters.getHostname()), (Serializable)((Object)String.valueOf(this.parameters.getPort())), (Serializable)((Object)this.parameters.getUsername())));
        }
    }

    private ClientContext getServiceContext() {
        return this.mServiceClient.getContext();
    }
}

