/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.saclient.rpc;

import com.google.common.collect.Maps;
import com.google.protobuf.BlockingService;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.marketcetera.module.ModuleInfo;
import org.marketcetera.module.ModuleURN;
import org.marketcetera.saclient.CreateStrategyParameters;
import org.marketcetera.saclient.rpc.RpcSAClient;
import org.marketcetera.saclient.rpc.SAServiceAdapter;
import org.marketcetera.saclient.rpc.XmlValue;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.misc.ClassVersion;
import org.marketcetera.util.rpc.RpcCredentials;
import org.marketcetera.util.rpc.RpcServerServices;
import org.marketcetera.util.rpc.RpcServiceSpec;
import org.marketcetera.util.ws.tags.SessionId;

@ClassVersion(value="$Id: SAClientRpcService.java 16901 2014-05-11 16:14:11Z colin $")
public class SAClientRpcService<SessionClazz>
implements RpcServiceSpec<SessionClazz>,
RpcSAClient.RpcSAClientService.BlockingInterface {
    private SAServiceAdapter serviceAdapter;
    private RpcServerServices<SessionClazz> serverServices;
    private static final String DESCRIPTION = "MATP Strategy Engine RPC Service";

    @Override
    public RpcSAClient.LoginResponse login(RpcController inController, RpcSAClient.LoginRequest inRequest) throws ServiceException {
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received authentication request for {}", (Object[])new Object[]{DESCRIPTION, inRequest.getUsername()});
        try {
            SessionId sessionId = this.serverServices.login(new RpcCredentials(inRequest.getUsername(), inRequest.getPassword(), inRequest.getAppId(), inRequest.getClientId(), inRequest.getVersionId(), new Locale(inRequest.getLocale().getLanguage(), inRequest.getLocale().getCountry(), inRequest.getLocale().getVariant())));
            return RpcSAClient.LoginResponse.newBuilder().setSessionId(sessionId.getValue()).build();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public RpcSAClient.LogoutResponse logout(RpcController inController, RpcSAClient.LogoutRequest inRequest) throws ServiceException {
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received logout request for {}", (Object[])new Object[]{DESCRIPTION, inRequest.getSessionId()});
        this.serverServices.logout(inRequest.getSessionId());
        return RpcSAClient.LogoutResponse.newBuilder().setStatus(true).build();
    }

    @Override
    public RpcSAClient.HeartbeatResponse heartbeat(RpcController inController, RpcSAClient.HeartbeatRequest inRequest) throws ServiceException {
        return RpcSAClient.HeartbeatResponse.newBuilder().setId(inRequest.getId()).build();
    }

    @Override
    public RpcSAClient.ProvidersResponse getProviders(RpcController inController, RpcSAClient.ProvidersRequest inRequest) throws ServiceException {
        this.serverServices.validateAndReturnSession(inRequest.getSessionId());
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received getProviders request", (Object[])new Object[]{DESCRIPTION});
        List<ModuleURN> providers = this.serviceAdapter.getProviders();
        RpcSAClient.ProvidersResponse.Builder responseBuilder = RpcSAClient.ProvidersResponse.newBuilder();
        if (providers != null) {
            for (ModuleURN provider : providers) {
                responseBuilder.addProvider(RpcSAClient.ModuleURN.newBuilder().setValue(provider.getValue()).build());
            }
        }
        RpcSAClient.ProvidersResponse response = responseBuilder.build();
        SLF4JLoggerProxy.debug((Object)this, (String)"{} returning {}", (Object[])new Object[]{DESCRIPTION, providers});
        return response;
    }

    @Override
    public RpcSAClient.InstancesResponse getInstances(RpcController inController, RpcSAClient.InstancesRequest inRequest) throws ServiceException {
        this.serverServices.validateAndReturnSession(inRequest.getSessionId());
        ModuleURN provider = new ModuleURN(inRequest.getProvider().getValue());
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received getInstances for {} request", (Object[])new Object[]{DESCRIPTION, provider});
        List<ModuleURN> instances = this.serviceAdapter.getInstances(provider);
        RpcSAClient.InstancesResponse.Builder responseBuilder = RpcSAClient.InstancesResponse.newBuilder();
        if (instances != null) {
            for (ModuleURN instance : instances) {
                responseBuilder.addInstance(RpcSAClient.ModuleURN.newBuilder().setValue(instance.getValue()).build());
            }
        }
        RpcSAClient.InstancesResponse response = responseBuilder.build();
        SLF4JLoggerProxy.debug((Object)this, (String)"{} returning {}", (Object[])new Object[]{DESCRIPTION, instances});
        return response;
    }

    @Override
    public RpcSAClient.ModuleInfoResponse getModuleInfo(RpcController inController, RpcSAClient.ModuleInfoRequest inRequest) throws ServiceException {
        this.serverServices.validateAndReturnSession(inRequest.getSessionId());
        ModuleURN instance = new ModuleURN(inRequest.getInstance().getValue());
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received getModuleInfo for {} request", (Object[])new Object[]{DESCRIPTION, instance});
        ModuleInfo info = this.serviceAdapter.getModuleInfo(instance);
        RpcSAClient.ModuleInfoResponse.Builder responseBuilder = RpcSAClient.ModuleInfoResponse.newBuilder();
        if (info != null) {
            try {
                responseBuilder.setInfo(RpcSAClient.ModuleInfo.newBuilder().setPayload(this.serverServices.marshal((Object)info)));
            }
            catch (JAXBException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        RpcSAClient.ModuleInfoResponse response = responseBuilder.build();
        SLF4JLoggerProxy.debug((Object)this, (String)"{} returning {}", (Object[])new Object[]{DESCRIPTION, info});
        return response;
    }

    @Override
    public RpcSAClient.StartResponse start(RpcController inController, RpcSAClient.StartRequest inRequest) throws ServiceException {
        this.serverServices.validateAndReturnSession(inRequest.getSessionId());
        ModuleURN instance = new ModuleURN(inRequest.getInstance().getValue());
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received start for {} request", (Object[])new Object[]{DESCRIPTION, instance});
        RpcSAClient.StartResponse.Builder responseBuilder = RpcSAClient.StartResponse.newBuilder();
        this.serviceAdapter.start(instance);
        SLF4JLoggerProxy.debug((Object)this, (String)"{} returning from start call", (Object[])new Object[]{DESCRIPTION});
        return responseBuilder.build();
    }

    @Override
    public RpcSAClient.StopResponse stop(RpcController inController, RpcSAClient.StopRequest inRequest) throws ServiceException {
        this.serverServices.validateAndReturnSession(inRequest.getSessionId());
        ModuleURN instance = new ModuleURN(inRequest.getInstance().getValue());
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received stop for {} request", (Object[])new Object[]{DESCRIPTION, instance});
        RpcSAClient.StopResponse.Builder responseBuilder = RpcSAClient.StopResponse.newBuilder();
        this.serviceAdapter.stop(instance);
        SLF4JLoggerProxy.debug((Object)this, (String)"{} returning from stop call", (Object[])new Object[]{DESCRIPTION});
        return responseBuilder.build();
    }

    @Override
    public RpcSAClient.DeleteResponse delete(RpcController inController, RpcSAClient.DeleteRequest inRequest) throws ServiceException {
        this.serverServices.validateAndReturnSession(inRequest.getSessionId());
        ModuleURN instance = new ModuleURN(inRequest.getInstance().getValue());
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received delete for {} request", (Object[])new Object[]{DESCRIPTION, instance});
        RpcSAClient.DeleteResponse.Builder responseBuilder = RpcSAClient.DeleteResponse.newBuilder();
        this.serviceAdapter.delete(instance);
        SLF4JLoggerProxy.debug((Object)this, (String)"{} returning from delete call", (Object[])new Object[]{DESCRIPTION});
        return responseBuilder.build();
    }

    @Override
    public RpcSAClient.GetPropertiesResponse getProperties(RpcController inController, RpcSAClient.GetPropertiesRequest inRequest) throws ServiceException {
        this.serverServices.validateAndReturnSession(inRequest.getSessionId());
        ModuleURN instance = new ModuleURN(inRequest.getInstance().getValue());
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received getProperties for {} request", (Object[])new Object[]{DESCRIPTION, instance});
        Map<String, Object> properties = this.serviceAdapter.getProperties(instance);
        RpcSAClient.GetPropertiesResponse.Builder responseBuilder = RpcSAClient.GetPropertiesResponse.newBuilder();
        RpcSAClient.Properties.Builder propertiesBuilder = RpcSAClient.Properties.newBuilder();
        if (properties != null) {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                RpcSAClient.Entry.Builder entryBuilder = RpcSAClient.Entry.newBuilder();
                entryBuilder.setKey(entry.getKey());
                try {
                    entryBuilder.setValue(this.serverServices.marshal((Object)new XmlValue(entry.getValue())));
                }
                catch (JAXBException e) {
                    throw new ServiceException((Throwable)e);
                }
                propertiesBuilder.addEntry(entryBuilder.build());
            }
        }
        responseBuilder.setProperties(propertiesBuilder.build());
        RpcSAClient.GetPropertiesResponse response = responseBuilder.build();
        SLF4JLoggerProxy.debug((Object)this, (String)"{} returning {}", (Object[])new Object[]{DESCRIPTION, properties});
        return response;
    }

    @Override
    public RpcSAClient.SetPropertiesResponse setProperties(RpcController inController, RpcSAClient.SetPropertiesRequest inRequest) throws ServiceException {
        this.serverServices.validateAndReturnSession(inRequest.getSessionId());
        ModuleURN instance = new ModuleURN(inRequest.getInstance().getValue());
        Map<Object, Object> properties = Maps.newHashMap();
        for (RpcSAClient.Entry entry : inRequest.getProperties().getEntryList()) {
            try {
                properties.put(entry.getKey(), ((XmlValue)this.serverServices.unmarshall(entry.getValue())).getValue());
            }
            catch (JAXBException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received setProperties to {} for {} request", (Object[])new Object[]{DESCRIPTION, properties, instance});
        properties = this.serviceAdapter.setProperties(instance, (Map<String, Object>)properties);
        RpcSAClient.SetPropertiesResponse.Builder responseBuilder = RpcSAClient.SetPropertiesResponse.newBuilder();
        RpcSAClient.Properties.Builder propertiesBuilder = RpcSAClient.Properties.newBuilder();
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                RpcSAClient.Entry.Builder entryBuilder = RpcSAClient.Entry.newBuilder();
                entryBuilder.setKey((String)entry.getKey());
                try {
                    entryBuilder.setValue(this.serverServices.marshal((Object)new XmlValue(entry.getValue())));
                }
                catch (JAXBException e) {
                    throw new ServiceException((Throwable)e);
                }
                propertiesBuilder.addEntry(entryBuilder.build());
            }
        }
        responseBuilder.setProperties(propertiesBuilder.build());
        RpcSAClient.SetPropertiesResponse response = responseBuilder.build();
        SLF4JLoggerProxy.debug((Object)this, (String)"{} returning {}", (Object[])new Object[]{DESCRIPTION, properties});
        return response;
    }

    @Override
    public RpcSAClient.CreateStrategyResponse createStrategy(RpcController inController, RpcSAClient.CreateStrategyRequest inRequest) throws ServiceException {
        CreateStrategyParameters parameters;
        this.serverServices.validateAndReturnSession(inRequest.getSessionId());
        try {
            parameters = (CreateStrategyParameters)this.serverServices.unmarshall(inRequest.getCreateStrategyParameters().getPayload());
        }
        catch (JAXBException e) {
            throw new ServiceException((Throwable)e);
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received createStrategy with {} request", (Object[])new Object[]{DESCRIPTION, parameters});
        ModuleURN instance = this.serviceAdapter.createStrategy(parameters);
        RpcSAClient.CreateStrategyResponse.Builder responseBuilder = RpcSAClient.CreateStrategyResponse.newBuilder();
        responseBuilder.setInstance(RpcSAClient.ModuleURN.newBuilder().setValue(instance.getValue()));
        RpcSAClient.CreateStrategyResponse response = responseBuilder.build();
        SLF4JLoggerProxy.debug((Object)this, (String)"{} returning {}", (Object[])new Object[]{DESCRIPTION, instance});
        return response;
    }

    @Override
    public RpcSAClient.StrategyCreateParmsResponse getStrategyCreateParms(RpcController inController, RpcSAClient.StrategyCreateParmsRequest inRequest) throws ServiceException {
        this.serverServices.validateAndReturnSession(inRequest.getSessionId());
        ModuleURN instance = new ModuleURN(inRequest.getInstance().getValue());
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received createStrategy with {} request", (Object[])new Object[]{DESCRIPTION, instance});
        CreateStrategyParameters parameters = this.serviceAdapter.getStrategyCreateParms(instance);
        RpcSAClient.StrategyCreateParmsResponse.Builder responseBuilder = RpcSAClient.StrategyCreateParmsResponse.newBuilder();
        try {
            responseBuilder.setCreateStrategyParameters(RpcSAClient.CreateStrategyParameters.newBuilder().setPayload(this.serverServices.marshal((Object)parameters)));
        }
        catch (JAXBException e) {
            throw new ServiceException((Throwable)e);
        }
        RpcSAClient.StrategyCreateParmsResponse response = responseBuilder.build();
        SLF4JLoggerProxy.debug((Object)this, (String)"{} returning {}", (Object[])new Object[]{DESCRIPTION, parameters});
        return response;
    }

    @Override
    public RpcSAClient.SendDataResponse sendData(RpcController inController, RpcSAClient.SendDataRequest inRequest) throws ServiceException {
        Object data;
        this.serverServices.validateAndReturnSession(inRequest.getSessionId());
        try {
            data = ((XmlValue)this.serverServices.unmarshall(inRequest.getPayload())).getValue();
        }
        catch (JAXBException e) {
            throw new ServiceException((Throwable)e);
        }
        SLF4JLoggerProxy.debug((Object)this, (String)"{} received sendData for {} request", (Object[])new Object[]{DESCRIPTION, data});
        RpcSAClient.SendDataResponse.Builder responseBuilder = RpcSAClient.SendDataResponse.newBuilder();
        this.serviceAdapter.sendData(data);
        SLF4JLoggerProxy.debug((Object)this, (String)"{} returning from sendData call", (Object[])new Object[]{DESCRIPTION});
        return responseBuilder.build();
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public BlockingService generateService() {
        return RpcSAClient.RpcSAClientService.newReflectiveBlockingService(this);
    }

    public void setRpcServerServices(RpcServerServices<SessionClazz> inServerServices) {
        this.serverServices = inServerServices;
    }

    public void setServiceAdapter(SAServiceAdapter inServiceAdapter) {
        this.serviceAdapter = inServiceAdapter;
    }
}

