/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.marketcetera.admin.AdminRpc;
import org.marketcetera.admin.User;
import org.marketcetera.admin.UserFactory;
import org.marketcetera.admin.rpc.AdminRpcUtil;
import org.marketcetera.core.ApplicationVersion;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.core.Preserve;
import org.marketcetera.core.Util;
import org.marketcetera.core.VersionInfo;
import org.marketcetera.core.notifications.INotification;
import org.marketcetera.core.time.TimeFactoryImpl;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.PageRequest;
import org.marketcetera.rpc.base.BaseRpc;
import org.marketcetera.rpc.base.BaseRpcUtil;
import org.marketcetera.rpc.client.AbstractRpcClient;
import org.marketcetera.rpc.client.RpcClientParameters;
import org.marketcetera.rpc.paging.PagingRpc;
import org.marketcetera.rpc.paging.PagingRpcUtil;
import org.marketcetera.strategy.FileUploadRequest;
import org.marketcetera.strategy.FileUploadStatus;
import org.marketcetera.strategy.StrategyClient;
import org.marketcetera.strategy.StrategyEventListener;
import org.marketcetera.strategy.StrategyInstance;
import org.marketcetera.strategy.StrategyInstanceFactory;
import org.marketcetera.strategy.StrategyInstanceHolder;
import org.marketcetera.strategy.StrategyMessage;
import org.marketcetera.strategy.StrategyMessageFactory;
import org.marketcetera.strategy.StrategyRpc;
import org.marketcetera.strategy.StrategyRpcClientParameters;
import org.marketcetera.strategy.StrategyRpcServiceGrpc;
import org.marketcetera.strategy.StrategyRpcUtil;
import org.marketcetera.strategy.StrategyStatus;
import org.marketcetera.strategy.StrategyTypesRpc;
import org.marketcetera.strategy.events.StrategyEvent;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.marketcetera.util.ws.tags.AppId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Preserve
public class StrategyRpcClient
extends AbstractRpcClient<StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub, StrategyRpcServiceGrpc.StrategyRpcServiceStub, StrategyRpcClientParameters>
implements StrategyClient {
    private final Cache<String, BaseRpcUtil.AbstractClientListenerProxy<?, ?, ?>> listenerProxiesById = CacheBuilder.newBuilder().build();
    private final LoadingCache<Object, BaseRpcUtil.AbstractClientListenerProxy<?, ?, ?>> listenerProxies = CacheBuilder.newBuilder().build(new CacheLoader<Object, BaseRpcUtil.AbstractClientListenerProxy<?, ?, ?>>(){

        public BaseRpcUtil.AbstractClientListenerProxy<?, ?, ?> load(Object inKey) throws Exception {
            BaseRpcUtil.AbstractClientListenerProxy<?, ?, ?> proxy = StrategyRpcClient.this.getListenerFor(inKey);
            StrategyRpcClient.this.listenerProxiesById.put((Object)proxy.getId(), proxy);
            return proxy;
        }
    });
    @Autowired(required=false)
    private StrategyInstanceHolder strategyInstanceHolder;
    @Autowired
    private StrategyMessageFactory strategyMessageFactory;
    @Autowired
    private StrategyInstanceFactory strategyInstanceFactory;
    @Autowired
    private UserFactory userFactory;
    public static final String APP_ID_NAME = "StrategyRpc";
    public static final VersionInfo APP_ID_VERSION = ApplicationVersion.getVersion(StrategyClient.class);
    public static final AppId APP_ID = Util.getAppId((String)"StrategyRpc", (String)APP_ID_VERSION.getVersionInfo());

    public Optional<? extends StrategyInstance> findByName(final String inName) {
        return (Optional)this.executeCall(new Callable<Optional<? extends StrategyInstance>>(){

            @Override
            public Optional<? extends StrategyInstance> call() throws Exception {
                StrategyRpc.FindStrategyInstanceByNameRequest.Builder requestBuilder = StrategyRpc.FindStrategyInstanceByNameRequest.newBuilder();
                requestBuilder.setSessionId(StrategyRpcClient.this.getSessionId().getValue());
                requestBuilder.setName(inName);
                StrategyRpc.FindStrategyInstanceByNameRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), request});
                StrategyRpc.FindStrategyInstanceByNameResponse response = ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)StrategyRpcClient.this.getBlockingStub()).findByName(request);
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} received {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), response});
                if (response.hasStrategyInstance()) {
                    return StrategyRpcUtil.getStrategyInstance((StrategyTypesRpc.StrategyInstance)response.getStrategyInstance(), (StrategyInstanceFactory)StrategyRpcClient.this.strategyInstanceFactory, (UserFactory)StrategyRpcClient.this.userFactory);
                }
                return Optional.empty();
            }
        });
    }

    public Collection<? extends StrategyInstance> getStrategyInstances() {
        return (Collection)this.executeCall(new Callable<Collection<? extends StrategyInstance>>(){

            @Override
            public Collection<? extends StrategyInstance> call() throws Exception {
                StrategyRpc.ReadStrategyInstancesRequest.Builder requestBuilder = StrategyRpc.ReadStrategyInstancesRequest.newBuilder();
                requestBuilder.setSessionId(StrategyRpcClient.this.getSessionId().getValue());
                StrategyRpc.ReadStrategyInstancesRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), request});
                StrategyRpc.ReadStrategyInstancesResponse response = ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)StrategyRpcClient.this.getBlockingStub()).getStrategyInstances(request);
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} received {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), response});
                ArrayList results = Lists.newArrayList();
                response.getStrategyInstancesList().forEach(rpcStrategyInstance -> StrategyRpcUtil.getStrategyInstance((StrategyTypesRpc.StrategyInstance)rpcStrategyInstance, (StrategyInstanceFactory)StrategyRpcClient.this.strategyInstanceFactory, (UserFactory)StrategyRpcClient.this.userFactory).ifPresent(strategyInstance -> results.add(strategyInstance)));
                return results;
            }
        });
    }

    public CollectionPageResponse<? extends StrategyMessage> getStrategyMessages(final String inStrategyName, final INotification.Severity inSeverity, final PageRequest inPageRequest) {
        return (CollectionPageResponse)this.executeCall(new Callable<CollectionPageResponse<? extends StrategyMessage>>(){

            @Override
            public CollectionPageResponse<? extends StrategyMessage> call() throws Exception {
                StrategyRpc.ReadStrategyMessagesRequest.Builder requestBuilder = StrategyRpc.ReadStrategyMessagesRequest.newBuilder();
                requestBuilder.setSessionId(StrategyRpcClient.this.getSessionId().getValue());
                if (inStrategyName != null) {
                    requestBuilder.setStrategyName(inStrategyName);
                }
                StrategyRpcUtil.getRpcStrategyMessageSeverity((INotification.Severity)inSeverity).ifPresent(rpcSeverity -> requestBuilder.setSeverity(rpcSeverity));
                requestBuilder.setPageRequest(PagingRpcUtil.buildPageRequest((PageRequest)inPageRequest));
                StrategyRpc.ReadStrategyMessagesRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), request});
                StrategyRpc.ReadStrategyMessagesResponse response = ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)StrategyRpcClient.this.getBlockingStub()).getStrategyMessages(request);
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} received {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), response});
                CollectionPageResponse results = new CollectionPageResponse();
                response.getStrategyMessagesList().forEach(rpcStrategyMessage -> StrategyRpcUtil.getStrategyMessage((StrategyTypesRpc.StrategyMessage)rpcStrategyMessage, (StrategyMessageFactory)StrategyRpcClient.this.strategyMessageFactory, (StrategyInstanceFactory)StrategyRpcClient.this.strategyInstanceFactory, (UserFactory)StrategyRpcClient.this.userFactory).ifPresent(strategyMessage -> results.getElements().add(strategyMessage)));
                PagingRpcUtil.setPageResponse((PageRequest)inPageRequest, (PagingRpc.PageResponse)response.getPageResponse(), (CollectionPageResponse)results);
                return results;
            }
        });
    }

    public void unloadStrategyInstance(final String inStrategyInstanceName) {
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                StrategyRpc.UnloadStrategyInstanceRequest.Builder requestBuilder = StrategyRpc.UnloadStrategyInstanceRequest.newBuilder();
                requestBuilder.setSessionId(StrategyRpcClient.this.getSessionId().getValue());
                requestBuilder.setName(inStrategyInstanceName);
                StrategyRpc.UnloadStrategyInstanceRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), request});
                StrategyRpc.UnloadStrategyInstanceResponse response = ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)StrategyRpcClient.this.getBlockingStub()).unloadStrategyInstance(request);
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} received {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), response});
                return null;
            }
        });
    }

    public StrategyStatus loadStrategyInstance(final StrategyInstance inStrategyInstance) {
        return (StrategyStatus)this.executeCall(new Callable<StrategyStatus>(){

            @Override
            public StrategyStatus call() throws Exception {
                StrategyRpc.LoadStrategyInstanceRequest.Builder requestBuilder = StrategyRpc.LoadStrategyInstanceRequest.newBuilder();
                requestBuilder.setSessionId(StrategyRpcClient.this.getSessionId().getValue());
                StrategyRpcUtil.getRpcStrategyInstance((StrategyInstance)inStrategyInstance).ifPresent(rpcValue -> requestBuilder.setStrategyInstance(rpcValue));
                StrategyRpc.LoadStrategyInstanceRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), request});
                StrategyRpc.LoadStrategyInstanceResponse response = ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)StrategyRpcClient.this.getBlockingStub()).loadStrategyInstance(request);
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} received {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), response});
                return StrategyRpcUtil.getStrategyStatus((StrategyTypesRpc.StrategyStatus)response.getStatus()).orElse(null);
            }
        });
    }

    public void startStrategyInstance(final String inStrategyInstanceName) {
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                StrategyRpc.StartStrategyInstanceRequest.Builder requestBuilder = StrategyRpc.StartStrategyInstanceRequest.newBuilder();
                requestBuilder.setSessionId(StrategyRpcClient.this.getSessionId().getValue());
                requestBuilder.setName(inStrategyInstanceName);
                StrategyRpc.StartStrategyInstanceRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), request});
                StrategyRpc.StartStrategyInstanceResponse response = ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)StrategyRpcClient.this.getBlockingStub()).startStrategyInstance(request);
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} received {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), response});
                return null;
            }
        });
    }

    public void stopStrategyInstance(final String inStrategyInstanceName) {
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                StrategyRpc.StopStrategyInstanceRequest.Builder requestBuilder = StrategyRpc.StopStrategyInstanceRequest.newBuilder();
                requestBuilder.setSessionId(StrategyRpcClient.this.getSessionId().getValue());
                requestBuilder.setName(inStrategyInstanceName);
                StrategyRpc.StopStrategyInstanceRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), request});
                StrategyRpc.StopStrategyInstanceResponse response = ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)StrategyRpcClient.this.getBlockingStub()).stopStrategyInstance(request);
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} received {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), response});
                return null;
            }
        });
    }

    public void uploadFile(FileUploadRequest inRequest) throws IOException, NoSuchAlgorithmException {
        int size;
        SLF4JLoggerProxy.trace((Object)((Object)this), (String)"Preparing {}", (Object[])new Object[]{inRequest});
        FileUploadObserver fileUploadObserver = new FileUploadObserver(inRequest);
        StreamObserver streamObserver = ((StrategyRpcServiceGrpc.StrategyRpcServiceStub)this.getAsyncStub()).uploadFile((StreamObserver)fileUploadObserver);
        File uploadFile = new File(inRequest.getFilePath());
        Validate.isTrue((boolean)uploadFile.canRead());
        String fileHash = PlatformServices.getFileChecksum((File)uploadFile);
        StrategyInstance newStrategyInstance = this.strategyInstanceFactory.create();
        newStrategyInstance.setFilename(uploadFile.getPath());
        newStrategyInstance.setHash(fileHash);
        newStrategyInstance.setName(inRequest.getName());
        newStrategyInstance.setUser(inRequest.getOwner());
        newStrategyInstance.setNonce(inRequest.getNonce());
        this.loadStrategyInstance(newStrategyInstance);
        StrategyRpc.FileUploadRequest requestMetadata = StrategyRpc.FileUploadRequest.newBuilder().setMetadata(StrategyTypesRpc.FileUploadMetaData.newBuilder().setName(inRequest.getName()).setFilename(inRequest.getFilePath()).setHash(fileHash).setNonce(inRequest.getNonce()).setOwner((AdminRpc.User)AdminRpcUtil.getRpcUser((User)inRequest.getOwner()).get()).setRequestTimestamp((Timestamp)BaseRpcUtil.getTimestampValue((Date)new Date()).get()).build()).build();
        SLF4JLoggerProxy.trace((Object)((Object)this), (String)"Submitting {}", (Object[])new Object[]{requestMetadata});
        long startTimeMillis = System.currentTimeMillis();
        streamObserver.onNext((Object)requestMetadata);
        Path filePath = Paths.get(inRequest.getFilePath(), new String[0]);
        long fileSize = Files.size(filePath);
        fileUploadObserver.setFileSize(fileSize);
        InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);
        byte[] bytes = new byte[4096];
        while ((size = inputStream.read(bytes)) > 0) {
            StrategyRpc.FileUploadRequest uploadRequest = StrategyRpc.FileUploadRequest.newBuilder().setFile(StrategyTypesRpc.UploadFile.newBuilder().setContent(ByteString.copyFrom((byte[])bytes, (int)0, (int)size)).build()).build();
            streamObserver.onNext((Object)uploadRequest);
            fileUploadObserver.incrementBytesUploaded(size);
        }
        inputStream.close();
        streamObserver.onCompleted();
        long endTimeMillis = System.currentTimeMillis();
        long elapsedTimeMillis = endTimeMillis - startTimeMillis;
        Period fileUploadPeriod = new Period(elapsedTimeMillis);
        SLF4JLoggerProxy.trace((Object)((Object)this), (String)"File upload completed in {}, status: {}", (Object[])new Object[]{TimeFactoryImpl.periodFormatter.print((ReadablePeriod)fileUploadPeriod), fileUploadObserver.currentStatus});
    }

    public void addStrategyEventListener(StrategyEventListener inListener) {
        if (this.listenerProxies.asMap().containsKey(inListener)) {
            return;
        }
        final BaseRpcUtil.AbstractClientListenerProxy listener = (BaseRpcUtil.AbstractClientListenerProxy)this.listenerProxies.getUnchecked((Object)inListener);
        if (listener == null) {
            return;
        }
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} adding strategy event listener", (Object[])new Object[]{StrategyRpcClient.this.getSessionId()});
                StrategyRpc.AddStrategyEventListenerRequest.Builder requestBuilder = StrategyRpc.AddStrategyEventListenerRequest.newBuilder();
                requestBuilder.setSessionId(StrategyRpcClient.this.getSessionId().getValue());
                requestBuilder.setListenerId(listener.getId());
                StrategyRpc.AddStrategyEventListenerRequest addStrategyEventListenerRequest = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), addStrategyEventListenerRequest});
                ((StrategyRpcServiceGrpc.StrategyRpcServiceStub)StrategyRpcClient.this.getAsyncStub()).addStrategyEventListener(addStrategyEventListenerRequest, (StreamObserver)((StrategyEventListenerProxy)listener));
                return null;
            }
        });
    }

    public void removeStrategyEventListener(StrategyEventListener inListener) {
        final BaseRpcUtil.AbstractClientListenerProxy proxy = (BaseRpcUtil.AbstractClientListenerProxy)this.listenerProxies.getIfPresent((Object)inListener);
        this.listenerProxies.invalidate((Object)inListener);
        if (proxy == null) {
            return;
        }
        this.listenerProxiesById.invalidate((Object)proxy.getId());
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} removing report listener", (Object[])new Object[]{StrategyRpcClient.this.getSessionId()});
                StrategyRpc.RemoveStrategyEventListenerRequest.Builder requestBuilder = StrategyRpc.RemoveStrategyEventListenerRequest.newBuilder();
                requestBuilder.setSessionId(StrategyRpcClient.this.getSessionId().getValue());
                requestBuilder.setListenerId(proxy.getId());
                StrategyRpc.RemoveStrategyEventListenerRequest removeStrategyEventListenerRequest = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), removeStrategyEventListenerRequest});
                StrategyRpc.RemoveStrategyEventListenerResponse response = ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)StrategyRpcClient.this.getBlockingStub()).removeStrategyEventListener(removeStrategyEventListenerRequest);
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} received {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), response});
                return null;
            }
        });
    }

    public void emitMessage(final INotification.Severity inSeverity, final String inMessage) {
        if (this.strategyInstanceHolder == null) {
            throw new UnsupportedOperationException("No strategy instance holder provided");
        }
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                StrategyRpc.CreateStrategyMessageRequest.Builder requestBuilder = StrategyRpc.CreateStrategyMessageRequest.newBuilder();
                requestBuilder.setSessionId(StrategyRpcClient.this.getSessionId().getValue());
                StrategyTypesRpc.StrategyMessage.Builder strategyMessageBuilder = StrategyTypesRpc.StrategyMessage.newBuilder();
                StrategyRpcUtil.getRpcStrategyInstance((StrategyInstance)StrategyRpcClient.this.strategyInstanceHolder.getStrategyInstance()).ifPresent(rpcStrategyInstance -> strategyMessageBuilder.setStrategyInstance(rpcStrategyInstance));
                StrategyRpcUtil.getRpcStrategyMessageSeverity((INotification.Severity)inSeverity).ifPresent(rpcSeverity -> strategyMessageBuilder.setSeverity(rpcSeverity));
                String message = StringUtils.trimToNull((String)inMessage);
                if (message != null) {
                    strategyMessageBuilder.setMessage(message);
                }
                requestBuilder.setStrategyMessage(strategyMessageBuilder.build());
                StrategyRpc.CreateStrategyMessageRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), request});
                StrategyRpc.CreateStrategyMessageResponse response = ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)StrategyRpcClient.this.getBlockingStub()).createStrategyMessage(request);
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} received {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), response});
                return null;
            }
        });
    }

    public void deleteStrategyMessage(final long inStrategyMessageId) {
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                StrategyRpc.DeleteStrategyMessageRequest.Builder requestBuilder = StrategyRpc.DeleteStrategyMessageRequest.newBuilder();
                requestBuilder.setSessionId(StrategyRpcClient.this.getSessionId().getValue());
                requestBuilder.setStrategyMessageId(inStrategyMessageId);
                StrategyRpc.DeleteStrategyMessageRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), request});
                StrategyRpc.DeleteStrategyMessageResponse response = ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)StrategyRpcClient.this.getBlockingStub()).deleteStrategyMessage(request);
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} received {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), response});
                return null;
            }
        });
    }

    public void deleteAllStrategyMessages(final String inStrategyInstanceName) {
        this.executeCall(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                StrategyRpc.DeleteAllStrategyMessagesRequest.Builder requestBuilder = StrategyRpc.DeleteAllStrategyMessagesRequest.newBuilder();
                requestBuilder.setSessionId(StrategyRpcClient.this.getSessionId().getValue());
                requestBuilder.setStrategyInstanceName(inStrategyInstanceName);
                StrategyRpc.DeleteAllStrategyMessagesRequest request = requestBuilder.build();
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} sending {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), request});
                StrategyRpc.DeleteAllStrategyMessagesResponse response = ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)StrategyRpcClient.this.getBlockingStub()).deleteAllStrategyMessages(request);
                SLF4JLoggerProxy.trace((Object)((Object)StrategyRpcClient.this), (String)"{} received {}", (Object[])new Object[]{StrategyRpcClient.this.getSessionId(), response});
                return null;
            }
        });
    }

    protected StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub getBlockingStub(Channel inChannel) {
        return StrategyRpcServiceGrpc.newBlockingStub((Channel)inChannel);
    }

    protected StrategyRpcServiceGrpc.StrategyRpcServiceStub getAsyncStub(Channel inChannel) {
        return StrategyRpcServiceGrpc.newStub((Channel)inChannel);
    }

    protected BaseRpc.LoginResponse executeLogin(BaseRpc.LoginRequest inRequest) {
        return ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)this.getBlockingStub()).login(inRequest);
    }

    protected BaseRpc.LogoutResponse executeLogout(BaseRpc.LogoutRequest inRequest) {
        return ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)this.getBlockingStub()).logout(inRequest);
    }

    protected BaseRpc.HeartbeatResponse executeHeartbeat(BaseRpc.HeartbeatRequest inRequest) {
        return ((StrategyRpcServiceGrpc.StrategyRpcServiceBlockingStub)this.getBlockingStub()).heartbeat(inRequest);
    }

    protected AppId getAppId() {
        return APP_ID;
    }

    protected VersionInfo getVersionInfo() {
        return APP_ID_VERSION;
    }

    protected StrategyRpcClient(StrategyRpcClientParameters inParameters) {
        super((RpcClientParameters)inParameters);
    }

    private BaseRpcUtil.AbstractClientListenerProxy<?, ?, ?> getListenerFor(Object inListener) {
        if (inListener instanceof StrategyEventListener) {
            return new StrategyEventListenerProxy((StrategyEventListener)inListener);
        }
        throw new UnsupportedOperationException();
    }

    private static class FileUploadObserver
    implements StreamObserver<StrategyRpc.FileUploadResponse> {
        private double bytesUploaded = 0.0;
        private double fileSize;
        private final FileUploadRequest request;
        private boolean completed = false;
        private Throwable uploadError;
        private StrategyTypesRpc.FileUploadStatus currentStatus = StrategyTypesRpc.FileUploadStatus.UNRECOGNIZED;

        public FileUploadObserver(FileUploadRequest inRequest) {
            this.request = inRequest;
        }

        public void incrementBytesUploaded(int inSize) {
            this.bytesUploaded += (double)inSize;
            double percentComplete = this.bytesUploaded / this.fileSize;
            this.request.onProgress(percentComplete);
        }

        private void setFileSize(long inFileSize) {
            this.fileSize = inFileSize;
        }

        public void onNext(StrategyRpc.FileUploadResponse inFileUploadResponse) {
            this.currentStatus = inFileUploadResponse.getStatus();
            SLF4JLoggerProxy.trace(StrategyRpcClient.class, (String)"File upload status: {}", (Object[])new Object[]{this.currentStatus});
        }

        public void onError(Throwable inError) {
            this.request.onError(inError);
            this.request.onStatus(FileUploadStatus.FAILED);
        }

        public void onCompleted() {
            this.completed = true;
            SLF4JLoggerProxy.trace(StrategyRpcClient.class, (String)"File upload completed, status is: {}, error is: {}", (Object[])new Object[]{this.currentStatus, this.uploadError});
            this.request.onStatus(this.uploadError == null ? FileUploadStatus.SUCCESS : FileUploadStatus.FAILED);
        }
    }

    private class StrategyEventListenerProxy
    extends BaseRpcUtil.AbstractClientListenerProxy<StrategyRpc.StrategyEventListenerResponse, StrategyEvent, StrategyEventListener> {
        protected StrategyEvent translateMessage(StrategyRpc.StrategyEventListenerResponse inResponse) {
            return StrategyRpcUtil.getStrategyEvent((StrategyRpc.StrategyEventListenerResponse)inResponse, (StrategyInstanceFactory)StrategyRpcClient.this.strategyInstanceFactory, (UserFactory)StrategyRpcClient.this.userFactory);
        }

        protected void sendMessage(StrategyEventListener inMessageListener, StrategyEvent inMessage) {
            inMessageListener.receiveStrategyEvent(inMessage);
        }

        protected StrategyEventListenerProxy(StrategyEventListener inStrategyEventListener) {
            super((Object)inStrategyEventListener);
        }
    }
}

