//
// this file is automatically generated
//
package org.marketcetera.strategy.dao;

import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.apache.commons.lang3.StringUtils;
import org.marketcetera.core.Preserve;
import org.marketcetera.core.notifications.INotification;
import org.marketcetera.strategy.HasStrategyInstance;
import org.marketcetera.strategy.StrategyInstance;
import org.marketcetera.strategy.StrategyMessage;

/* $License$ */

/**
 * Represents a message emitted by a strategy.
 *
 * @author <a href="mailto:colin@marketcetera.com">Colin DuPlantis</a>
 * @version $Id$
 * @since $Release$
 */
@Preserve
@Entity(name="StrategyMessage")
@Table(name="metc_strategy_messages")
public class PersistentStrategyMessage
        extends org.marketcetera.persist.EntityBase
        implements StrategyMessage,HasStrategyInstance
{
    /**
     * Create a new PersistentStrategyMessage instance.
     */
    public PersistentStrategyMessage()
    {
        setStrategyMessageId(strategyMessageIdCounter.incrementAndGet());
    }
    /**
     * Create a new PersistentStrategyMessage instance.
     *
     * @param inStrategyMessage a <code>StrategyMessage</code> value
     */
    public PersistentStrategyMessage(StrategyMessage inStrategyMessage)
    {
        setStrategyInstance(inStrategyMessage.getStrategyInstance());
        setStrategyMessageId(inStrategyMessage.getStrategyMessageId());
        setMessageTimestamp(inStrategyMessage.getMessageTimestamp());
        setSeverity(inStrategyMessage.getSeverity());
        setMessage(inStrategyMessage.getMessage());
    }
    /**
     * Get the strategyInstance value.
     *
     * @return an <code>StrategyInstance</code> value
     */
    @Override
    public StrategyInstance getStrategyInstance()
    {
        return strategyInstance;
    }
    /**
     * Set the strategyInstance value.
     *
     * @param inStrategyInstance an <code>StrategyInstance</code> value
     */
    @Override
    public void setStrategyInstance(StrategyInstance inStrategyInstance)
    {
        strategyInstance = (PersistentStrategyInstance)inStrategyInstance;
    }
    /**
     * Get the messageTimestamp value.
     *
     * @return a <code>Date</code> value
     */
    @Override
    public Date getMessageTimestamp()
    {
        return messageTimestamp;
    }
    /**
     * Set the messageTimestamp value.
     *
     * @param inMessageTimestamp a <code>Date</code> value
     */
    @Override
    public void setMessageTimestamp(Date inMessageTimestamp)
    {
        messageTimestamp = inMessageTimestamp;
    }
    /**
     * Get the severity value.
     *
     * @return an <code>INotification.Severity</code> value
     */
    @Override
    public INotification.Severity getSeverity()
    {
        return severity;
    }
    /**
     * Set the severity value.
     *
     * @param inSeverity an <code>INotification.Severity</code> value
     */
    @Override
    public void setSeverity(INotification.Severity inSeverity)
    {
        severity = inSeverity;
    }
    /**
     * Get the message value.
     *
     * @return a <code>String</code> value
     */
    @Override
    public String getMessage()
    {
        return message;
    }
    /**
     * Set the message value.
     *
     * @param inMessage a <code>String</code> value
     */
    @Override
    public void setMessage(String inMessage)
    {
        message = StringUtils.trimToNull(inMessage);
    }
    /* (non-Javadoc)
     * @see StrategyMessage#getStrategyMessageId()
     */
    @Override
    public long getStrategyMessageId()
    {
        return strategyMessageId;
    }
    /**
     * Sets the strategyMessageId value.
     *
     * @param inStrategyMessageId a <code>long</code> value
     */
    public void setStrategyMessageId(long inStrategyMessageId)
    {
        strategyMessageId = inStrategyMessageId;
    }
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder();
        builder.append("StrategyMessage [")
            .append("strategyMessageId=").append(getId())
            .append(", strategyInstance=").append(strategyInstance)
            .append(", messageTimestamp=").append(messageTimestamp)
            .append(", severity=").append(severity)
            .append(", message=").append(message).append("]");
        return builder.toString();
    }
    /**
     * provides a source for unique message ids
     */
    private static final AtomicLong strategyMessageIdCounter = new AtomicLong(System.currentTimeMillis());
    /**
     * unique identifies the strategy message
     */
    @Column(name="strategy_message_id",nullable=false,unique=true)
    private long strategyMessageId;
    /**
     * strategy which created this message
     */
    @ManyToOne
    @JoinColumn(name="strategy_instance_id",nullable=true)
    private PersistentStrategyInstance strategyInstance;
    /**
     * date message was created
     */
    @Column(name="message_timestamp",nullable=true,unique=false)
    private Date messageTimestamp;
    /**
     * strategy message severity
     */
    @Enumerated(EnumType.STRING)
    @Column(name="severity",nullable=true,unique=false)
    private INotification.Severity severity;
    /**
     * message from the strategy
     */
    @Column(name="message",nullable=true,unique=false)
    private String message;
    private static final long serialVersionUID = 1444495066L;
}
