//
// this file is automatically generated
//
package org.marketcetera.strategy.dao;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;

import org.marketcetera.core.Preserve;
import org.marketcetera.strategy.StrategyStatus;

/* $License$ */

/**
 * Identifies a unique strategy instance.
 *
 * @author <a href="mailto:colin@marketcetera.com">Colin DuPlantis</a>
 * @version $Id$
 * @since $Release$
 */
@Preserve
public interface StrategyInstanceDao
        extends org.springframework.data.jpa.repository.JpaRepository<PersistentStrategyInstance,Long>,org.springframework.data.querydsl.QuerydslPredicateExecutor<PersistentStrategyInstance>
{
    /**
     * Find the strategy instance with the given name, if it exists.
     *
     * @param inName a <code>String</code> value
     * @return an <code>Optional&lt;PersistentStrategyInstance&gt;</code> value
     */
    Optional<PersistentStrategyInstance> findByName(String inName);
    /**
     * Find the strategy instance with the given nonce, if it exists.
     *
     * @param inNonce a <code>String</code> value
     * @return an <code>Optional&lt;PersistentStrategyInstance&gt;</code> value
     */
    Optional<PersistentStrategyInstance> findByNonce(String inNonce);
    /**
     * Find the strategy instances with status values in the given values.
     *
     * @param inStatus a <code>Set&lt;StrategyStatus&gt;</code> value
     * @return a <code>Collection&lt;PersistentStrategyInstance&gt;</code> value
     */
    Collection<PersistentStrategyInstance> findAllByStatusIn(Set<StrategyStatus> inStatus);
}
