/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Predicate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.marketcetera.admin.HasCurrentUser;
import org.marketcetera.admin.User;
import org.marketcetera.admin.dao.UserDao;
import org.marketcetera.admin.user.PersistentUser;
import org.marketcetera.cluster.ClusterData;
import org.marketcetera.cluster.service.ClusterService;
import org.marketcetera.core.BatchQueueProcessor;
import org.marketcetera.core.PlatformServices;
import org.marketcetera.core.Preserve;
import org.marketcetera.core.file.DirectoryWatcherImpl;
import org.marketcetera.core.file.DirectoryWatcherSubscriber;
import org.marketcetera.core.notifications.INotification;
import org.marketcetera.eventbus.EventBusService;
import org.marketcetera.persist.CollectionPageResponse;
import org.marketcetera.persist.Sort;
import org.marketcetera.strategy.DirectStrategyClient;
import org.marketcetera.strategy.StrategyClient;
import org.marketcetera.strategy.StrategyEventListener;
import org.marketcetera.strategy.StrategyInstance;
import org.marketcetera.strategy.StrategyInstanceHolder;
import org.marketcetera.strategy.StrategyMessage;
import org.marketcetera.strategy.StrategyService;
import org.marketcetera.strategy.StrategyStatus;
import org.marketcetera.strategy.dao.PersistentStrategyInstance;
import org.marketcetera.strategy.dao.PersistentStrategyMessage;
import org.marketcetera.strategy.dao.QPersistentStrategyMessage;
import org.marketcetera.strategy.dao.StrategyInstanceDao;
import org.marketcetera.strategy.dao.StrategyMessageDao;
import org.marketcetera.strategy.events.SimpleStrategyMessageEvent;
import org.marketcetera.strategy.events.SimpleStrategyStartFailedEvent;
import org.marketcetera.strategy.events.SimpleStrategyStartedEvent;
import org.marketcetera.strategy.events.SimpleStrategyStatusChangedEvent;
import org.marketcetera.strategy.events.SimpleStrategyStoppedEvent;
import org.marketcetera.strategy.events.SimpleStrategyUnloadedEvent;
import org.marketcetera.strategy.events.SimpleStrategyUploadFailedEvent;
import org.marketcetera.strategy.events.SimpleStrategyUploadSucceededEvent;
import org.marketcetera.strategy.events.StrategyEvent;
import org.marketcetera.trade.client.DirectTradeClient;
import org.marketcetera.util.log.SLF4JLoggerProxy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
@AutoConfiguration
@Preserve
public class StrategyServiceImpl
implements StrategyService,
DirectoryWatcherSubscriber {
    private StrategyMessageQueueProcessor strategyMessageQueueProcessor;
    @Autowired
    private StrategyMessageDao strategyMessageDao;
    private final Cache<String, RunningStrategy> strategiesByName = CacheBuilder.newBuilder().build();
    private Path incomingStrategyDirectoryPath;
    private Path temporaryStrategyDirectoryPath;
    private Path storageStrategyDirectoryPath;
    @Autowired
    private ApplicationContext applicationContext;
    @Value(value="${metc.strategy.incoming.directory.polling.intervalms:5000}")
    private long pollingInterval;
    @Value(value="${metc.strategy.storage.directory}")
    private String strategyStorageDirectoryName;
    @Value(value="${metc.strategy.incoming.directory}")
    private String strategyIncomingDirectoryName;
    @Value(value="${metc.strategy.temporary.directory}")
    private String strategyTemporaryDirectoryName;
    private String serviceName;
    private DirectoryWatcherImpl strategyWatcher;
    @Autowired
    private JpaTransactionManager txManager;
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private EventBusService eventBusService;
    private ClusterData clusterData;
    @Autowired
    private UserDao userDao;
    @Autowired
    private StrategyInstanceDao strategyInstanceDao;
    private final Set<StrategyEventListener> strategyEventListeners = Sets.newConcurrentHashSet();

    @PostConstruct
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void start() throws IOException {
        this.serviceName = PlatformServices.getServiceName(this.getClass());
        SLF4JLoggerProxy.info((Object)this, (String)"{} starting", (Object[])new Object[]{this.serviceName});
        this.strategyMessageQueueProcessor = new StrategyMessageQueueProcessor();
        this.strategyMessageQueueProcessor.start();
        this.clusterData = this.clusterService.getInstanceData();
        this.strategyIncomingDirectoryName = this.strategyIncomingDirectoryName + this.clusterData.getInstanceNumber();
        this.incomingStrategyDirectoryPath = Paths.get(this.strategyIncomingDirectoryName, new String[0]);
        this.storageStrategyDirectoryPath = Paths.get(this.strategyStorageDirectoryName, new String[0]);
        this.temporaryStrategyDirectoryPath = Paths.get(this.strategyTemporaryDirectoryName, new String[0]);
        FileUtils.createParentDirectories((File)this.storageStrategyDirectoryPath.toFile());
        SLF4JLoggerProxy.info((Object)this, (String)"{} monitoring {} for uploaded strategies, storing strategies in {}", (Object[])new Object[]{this.serviceName, this.strategyIncomingDirectoryName, this.strategyStorageDirectoryName});
        this.strategyWatcher = new DirectoryWatcherImpl();
        this.strategyWatcher.setCreateDirectoriesOnStart(true);
        this.strategyWatcher.setDirectoriesToWatch((List)Lists.newArrayList((Object[])new File[]{new File(this.strategyIncomingDirectoryName)}));
        this.strategyWatcher.setPollingInterval(this.pollingInterval);
        this.strategyWatcher.addWatcher((DirectoryWatcherSubscriber)this);
        this.strategyWatcher.start();
        this.eventBusService.register((Object)this);
        for (PersistentStrategyInstance existingStrategyInstance : this.strategyInstanceDao.findAll()) {
            Path fullStrategyPath = this.storageStrategyDirectoryPath.resolve(existingStrategyInstance.getFilename());
            if (fullStrategyPath.toFile().canRead()) continue;
            SLF4JLoggerProxy.warn((Object)this, (String)"{} is unreadable, unloading", (Object[])new Object[]{fullStrategyPath});
            BooleanBuilder where = new BooleanBuilder();
            where = where.and((Predicate)QPersistentStrategyMessage.persistentStrategyMessage.strategyInstance.eq((Object)existingStrategyInstance));
            this.strategyMessageDao.deleteAll(this.strategyMessageDao.findAll((Predicate)where));
            this.strategyInstanceDao.delete((Object)existingStrategyInstance);
        }
    }

    @PreDestroy
    public void stop() {
        this.strategyMessageQueueProcessor.stop();
        this.eventBusService.unregister((Object)this);
        if (this.strategyWatcher != null) {
            try {
                this.strategyWatcher.stop();
            }
            catch (Exception exception) {
            }
            finally {
                this.strategyWatcher = null;
            }
        }
        SLF4JLoggerProxy.info((Object)this, (String)"{} stopped", (Object[])new Object[]{this.serviceName});
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public Collection<? extends StrategyInstance> getStrategyInstances(String inCurrentUserName) {
        return this.strategyInstanceDao.findAll();
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public CollectionPageResponse<? extends StrategyMessage> getStrategyMessages(String inStrategyName, INotification.Severity inSeverity, org.marketcetera.persist.PageRequest inPageRequest) {
        Page pageResponse;
        org.springframework.data.domain.Sort sort = this.buildSort(inPageRequest, org.springframework.data.domain.Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, QPersistentStrategyMessage.persistentStrategyMessage.messageTimestamp.getMetadata().getName()), new Sort.Order(Sort.Direction.DESC, QPersistentStrategyMessage.persistentStrategyMessage.severity.getMetadata().getName())}));
        SLF4JLoggerProxy.debug((Object)this, (String)"getStrategyMessages sort order is {} renders: {} with strategy name {} and severity {}", (Object[])new Object[]{inPageRequest.getSortOrder(), sort, inStrategyName, inSeverity});
        PageRequest pageRequest = PageRequest.of((int)inPageRequest.getPageNumber(), (int)inPageRequest.getPageSize(), (org.springframework.data.domain.Sort)sort);
        inStrategyName = StringUtils.trimToNull((String)inStrategyName);
        BooleanBuilder where = null;
        if (inStrategyName != null || inSeverity != null) {
            where = new BooleanBuilder();
            if (inStrategyName != null) {
                where = where.and((Predicate)QPersistentStrategyMessage.persistentStrategyMessage.strategyInstance.name.eq((Object)inStrategyName));
            }
            if (inSeverity != null) {
                BooleanBuilder severityBuilder = new BooleanBuilder();
                switch (inSeverity) {
                    case DEBUG: {
                        severityBuilder = severityBuilder.or((Predicate)QPersistentStrategyMessage.persistentStrategyMessage.severity.eq((Object)INotification.Severity.DEBUG));
                    }
                    case INFO: {
                        severityBuilder = severityBuilder.or((Predicate)QPersistentStrategyMessage.persistentStrategyMessage.severity.eq((Object)INotification.Severity.INFO));
                    }
                    case WARN: {
                        severityBuilder = severityBuilder.or((Predicate)QPersistentStrategyMessage.persistentStrategyMessage.severity.eq((Object)INotification.Severity.WARN));
                    }
                    case ERROR: {
                        severityBuilder = severityBuilder.or((Predicate)QPersistentStrategyMessage.persistentStrategyMessage.severity.eq((Object)INotification.Severity.ERROR));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unexpected severity: " + inSeverity);
                    }
                }
                where = where.and((Predicate)severityBuilder);
            }
        }
        if (where == null) {
            pageResponse = this.strategyMessageDao.findAll((Pageable)pageRequest);
        } else {
            SLF4JLoggerProxy.debug((Object)this, (String)"Selecting strategy messages with: {}", (Object[])new Object[]{where});
            pageResponse = this.strategyMessageDao.findAll((Predicate)where, (Pageable)pageRequest);
        }
        return new CollectionPageResponse(pageResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void startStrategyInstance(String inStrategyInstanceName) {
        PersistentStrategyInstance strategyInstance;
        StrategyStatus oldStatus;
        StrategyStatus newStatus;
        Object errorMessage;
        boolean success;
        block20: {
            success = true;
            errorMessage = null;
            newStatus = null;
            oldStatus = null;
            strategyInstance = null;
            try {
                Optional<PersistentStrategyInstance> strategyInstanceOption = this.strategyInstanceDao.findByName(inStrategyInstanceName);
                if (strategyInstanceOption.isEmpty()) {
                    success = false;
                    newStatus = StrategyStatus.ERROR;
                } else {
                    strategyInstance = strategyInstanceOption.get();
                    oldStatus = strategyInstance.getStatus();
                    if (strategyInstance.getStatus().isRunnable()) {
                        Path strategySource = Paths.get(this.strategyStorageDirectoryName, strategyInstance.getFilename());
                        if (strategySource.toFile().canRead()) {
                            success = true;
                            RunningStrategy runningStrategy = new RunningStrategy(strategyInstance, strategySource.toFile());
                            runningStrategy.start();
                            strategyInstance.setStarted(new Date());
                            this.strategiesByName.put((Object)strategyInstance.getName(), (Object)runningStrategy);
                            newStatus = StrategyStatus.RUNNING;
                        } else {
                            success = false;
                            errorMessage = "Unable to read cached strategy with name '" + inStrategyInstanceName + "'";
                            newStatus = StrategyStatus.ERROR;
                            SLF4JLoggerProxy.warn((Object)this, (String)"Unable to read cached strategy '{}' with filename {}", (Object[])new Object[]{inStrategyInstanceName, strategySource});
                        }
                    } else {
                        success = false;
                        errorMessage = "Strategy '" + inStrategyInstanceName + "' at status " + oldStatus.name() + " cannot be started";
                        newStatus = oldStatus;
                        SLF4JLoggerProxy.warn((Object)this, (String)"Unable to start strategy '{}' at status {}", (Object[])new Object[]{inStrategyInstanceName, oldStatus});
                    }
                }
                if (strategyInstance == null) break block20;
                strategyInstance.setStatus(newStatus);
            }
            catch (Throwable e) {
                block21: {
                    try {
                        errorMessage = PlatformServices.getMessage((Throwable)e);
                        SLF4JLoggerProxy.warn((Object)this, (Throwable)e, (String)"Unable to start strategy '{}': {}", (Object[])new Object[]{inStrategyInstanceName, errorMessage});
                        success = false;
                        newStatus = StrategyStatus.ERROR;
                        if (strategyInstance == null) break block21;
                        strategyInstance.setStatus(newStatus);
                    }
                    catch (Throwable throwable) {
                        if (strategyInstance != null) {
                            strategyInstance.setStatus(newStatus);
                            strategyInstance = (PersistentStrategyInstance)((Object)this.strategyInstanceDao.save((Object)strategyInstance));
                        }
                        if (success) {
                            this.eventBusService.post((Object)new SimpleStrategyStartedEvent((StrategyInstance)strategyInstance));
                        } else {
                            this.eventBusService.post((Object)new SimpleStrategyStartFailedEvent((StrategyInstance)strategyInstance, (String)errorMessage));
                            PersistentStrategyMessage errorMessageEvent = new PersistentStrategyMessage();
                            errorMessageEvent.setMessage((String)errorMessage);
                            errorMessageEvent.setMessageTimestamp(new Date());
                            errorMessageEvent.setSeverity(INotification.Severity.ERROR);
                            errorMessageEvent.setStrategyInstance(strategyInstance);
                            this.strategyMessageDao.save((Object)errorMessageEvent);
                        }
                        if (oldStatus != newStatus) {
                            this.eventBusService.post((Object)new SimpleStrategyStatusChangedEvent((StrategyInstance)strategyInstance, oldStatus, newStatus));
                        }
                        throw throwable;
                    }
                    strategyInstance = (PersistentStrategyInstance)((Object)this.strategyInstanceDao.save((Object)strategyInstance));
                }
                if (success) {
                    this.eventBusService.post((Object)new SimpleStrategyStartedEvent((StrategyInstance)strategyInstance));
                } else {
                    this.eventBusService.post((Object)new SimpleStrategyStartFailedEvent((StrategyInstance)strategyInstance, (String)errorMessage));
                    PersistentStrategyMessage errorMessageEvent = new PersistentStrategyMessage();
                    errorMessageEvent.setMessage((String)errorMessage);
                    errorMessageEvent.setMessageTimestamp(new Date());
                    errorMessageEvent.setSeverity(INotification.Severity.ERROR);
                    errorMessageEvent.setStrategyInstance(strategyInstance);
                    this.strategyMessageDao.save((Object)errorMessageEvent);
                }
                if (oldStatus != newStatus) {
                    this.eventBusService.post((Object)new SimpleStrategyStatusChangedEvent((StrategyInstance)strategyInstance, oldStatus, newStatus));
                }
            }
            strategyInstance = (PersistentStrategyInstance)((Object)this.strategyInstanceDao.save((Object)strategyInstance));
        }
        if (success) {
            this.eventBusService.post((Object)new SimpleStrategyStartedEvent((StrategyInstance)strategyInstance));
        } else {
            this.eventBusService.post((Object)new SimpleStrategyStartFailedEvent((StrategyInstance)strategyInstance, (String)errorMessage));
            PersistentStrategyMessage errorMessageEvent = new PersistentStrategyMessage();
            errorMessageEvent.setMessage((String)errorMessage);
            errorMessageEvent.setMessageTimestamp(new Date());
            errorMessageEvent.setSeverity(INotification.Severity.ERROR);
            errorMessageEvent.setStrategyInstance(strategyInstance);
            this.strategyMessageDao.save((Object)errorMessageEvent);
        }
        if (oldStatus != newStatus) {
            this.eventBusService.post((Object)new SimpleStrategyStatusChangedEvent((StrategyInstance)strategyInstance, oldStatus, newStatus));
        }
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void stopStrategyInstance(String inStrategyInstanceName) {
        Optional<PersistentStrategyInstance> strategyInstanceOption = this.strategyInstanceDao.findByName(inStrategyInstanceName);
        Validate.isTrue((boolean)strategyInstanceOption.isPresent(), (String)("No strategy by name '" + inStrategyInstanceName + "'"), (Object[])new Object[0]);
        PersistentStrategyInstance strategyInstance = strategyInstanceOption.get();
        Validate.isTrue((boolean)strategyInstance.getStatus().isRunning(), (String)("Strategy '" + inStrategyInstanceName + "' is not running"), (Object[])new Object[0]);
        RunningStrategy runningStrategy = (RunningStrategy)this.strategiesByName.getIfPresent((Object)inStrategyInstanceName);
        StrategyStatus oldStatus = strategyInstance.getStatus();
        StrategyStatus newStatus = StrategyStatus.STOPPED;
        strategyInstance.setStarted(new Date(0L));
        if (runningStrategy == null) {
            SLF4JLoggerProxy.warn((Object)this, (String)"No running strategy found for '{}'", (Object[])new Object[]{inStrategyInstanceName});
        } else {
            this.strategiesByName.invalidate((Object)inStrategyInstanceName);
            try {
                runningStrategy.stop();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
            }
        }
        strategyInstance.setStatus(newStatus);
        strategyInstance = (PersistentStrategyInstance)((Object)this.strategyInstanceDao.save((Object)strategyInstance));
        this.eventBusService.post((Object)new SimpleStrategyStoppedEvent((StrategyInstance)strategyInstance));
        if (oldStatus != newStatus) {
            this.eventBusService.post((Object)new SimpleStrategyStatusChangedEvent((StrategyInstance)strategyInstance, oldStatus, newStatus));
        }
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void unloadStrategyInstance(String inStrategyInstanceName) {
        Validate.notNull((Object)inStrategyInstanceName, (String)"Strategy instance name required", (Object[])new Object[0]);
        Optional<PersistentStrategyInstance> strategyInstanceOption = this.strategyInstanceDao.findByName(inStrategyInstanceName);
        Validate.isTrue((boolean)strategyInstanceOption.isPresent(), (String)("No strategy instance by name '" + inStrategyInstanceName + "'"), (Object[])new Object[0]);
        PersistentStrategyInstance strategyInstance = strategyInstanceOption.get();
        Validate.isTrue((boolean)strategyInstance.getStatus().isUnloadable(), (String)("Strategy '" + strategyInstance.getName() + "' cannot be unloaded at status '" + strategyInstance.getStatus() + "'"), (Object[])new Object[0]);
        Path strategyTarget = Paths.get(this.strategyStorageDirectoryName, strategyInstance.getFilename());
        FileUtils.deleteQuietly((File)strategyTarget.toFile());
        this.deleteAllMessagesFor(strategyInstance);
        this.strategyInstanceDao.delete((Object)strategyInstance);
        this.eventBusService.post((Object)new SimpleStrategyUnloadedEvent((StrategyInstance)strategyInstance));
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void deleteStrategyMessage(long inStrategyMessageId) {
        SLF4JLoggerProxy.debug((Object)this, (String)"Deleting strategy message with id {}", (Object[])new Object[]{inStrategyMessageId});
        Optional<PersistentStrategyMessage> strategyMessageOption = this.strategyMessageDao.findByStrategyMessageId(inStrategyMessageId);
        Validate.isTrue((boolean)strategyMessageOption.isPresent(), (String)("No strategy message with id '" + inStrategyMessageId + "'"), (Object[])new Object[0]);
        this.strategyMessageDao.delete((Object)strategyMessageOption.get());
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void deleteAllStrategyMessages(String inStrategyInstanceName) {
        Validate.notNull((Object)inStrategyInstanceName, (String)"Strategy instance name required", (Object[])new Object[0]);
        Optional<PersistentStrategyInstance> strategyInstanceOption = this.strategyInstanceDao.findByName(inStrategyInstanceName);
        Validate.isTrue((boolean)strategyInstanceOption.isPresent(), (String)("No strategy instance by name '" + inStrategyInstanceName + "'"), (Object[])new Object[0]);
        PersistentStrategyInstance strategyInstance = strategyInstanceOption.get();
        this.deleteAllMessagesFor(strategyInstance);
    }

    public Path getIncomingStrategyDirectory() {
        return this.incomingStrategyDirectoryPath;
    }

    public Path getTemporaryStrategyDirectory() {
        return this.temporaryStrategyDirectoryPath;
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public void received(File inFile, String inOriginalFileName) {
        SLF4JLoggerProxy.debug((Object)this, (String)"Received incoming strategy file '{}'", (Object[])new Object[]{inOriginalFileName});
        PersistentStrategyInstance strategyInstance = null;
        try {
            String nonce = FilenameUtils.getBaseName((String)inOriginalFileName);
            Optional<PersistentStrategyInstance> strategyInstanceOption = this.strategyInstanceDao.findByNonce(nonce);
            SLF4JLoggerProxy.debug((Object)this, (String)"Received uploaded file with nonce: '{}' found: {}", (Object[])new Object[]{nonce, strategyInstanceOption});
            Validate.isTrue((boolean)strategyInstanceOption.isPresent(), (String)("No strategy instance with nonce: '" + nonce + "'"), (Object[])new Object[0]);
            strategyInstance = strategyInstanceOption.get();
            String finalStrategyFilename = nonce + ".jar";
            strategyInstance.setFilename(finalStrategyFilename);
            Path strategyTarget = Paths.get(this.strategyStorageDirectoryName, finalStrategyFilename);
            FileUtils.moveFile((File)inFile, (File)strategyTarget.toFile());
            StrategyStatus oldStatus = strategyInstance.getStatus();
            strategyInstance.setStatus(StrategyStatus.STOPPED);
            strategyInstance = (PersistentStrategyInstance)((Object)this.strategyInstanceDao.save((Object)strategyInstance));
            this.eventBusService.post((Object)new SimpleStrategyUploadSucceededEvent((StrategyInstance)strategyInstance));
            this.eventBusService.post((Object)new SimpleStrategyStatusChangedEvent((StrategyInstance)strategyInstance, oldStatus, strategyInstance.getStatus()));
        }
        catch (Exception e) {
            SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
            if (strategyInstance != null) {
                strategyInstance.setStatus(StrategyStatus.ERROR);
                strategyInstance = (PersistentStrategyInstance)((Object)this.strategyInstanceDao.save((Object)strategyInstance));
            }
            this.eventBusService.post((Object)new SimpleStrategyUploadFailedEvent((StrategyInstance)strategyInstance, PlatformServices.getMessage((Throwable)e)));
        }
    }

    @Transactional(readOnly=false, propagation=Propagation.REQUIRED)
    public StrategyStatus loadStrategyInstance(StrategyInstance inStrategyInstance) {
        if (!(inStrategyInstance instanceof PersistentStrategyInstance)) {
            throw new UnsupportedOperationException("Need to create persistent instance");
        }
        PersistentStrategyInstance pInstance = (PersistentStrategyInstance)inStrategyInstance;
        pInstance.setStatus(StrategyStatus.LOADING);
        PersistentUser user = this.userDao.findByName(inStrategyInstance.getUser().getName());
        Validate.notNull((Object)user, (String)("No user for name '" + inStrategyInstance.getUser().getName() + "'"), (Object[])new Object[0]);
        pInstance.setUser((User)user);
        pInstance = (PersistentStrategyInstance)((Object)this.strategyInstanceDao.save((Object)pInstance));
        return pInstance.getStatus();
    }

    public StrategyMessage createStrategyMessage(StrategyMessage inStrategyMessage) {
        this.strategyMessageQueueProcessor.add(inStrategyMessage);
        return inStrategyMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void receiveStrategyEvent(StrategyEvent inEvent) {
        Set<StrategyEventListener> set = this.strategyEventListeners;
        synchronized (set) {
            for (StrategyEventListener listener : this.strategyEventListeners) {
                try {
                    listener.receiveStrategyEvent(inEvent);
                }
                catch (Exception e) {
                    SLF4JLoggerProxy.warn((Object)this, (Throwable)e);
                    this.removeStrategyEventListener(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStrategyEventListener(StrategyEventListener inListener) {
        Set<StrategyEventListener> set = this.strategyEventListeners;
        synchronized (set) {
            this.strategyEventListeners.add(inListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStrategyEventListener(StrategyEventListener inListener) {
        Set<StrategyEventListener> set = this.strategyEventListeners;
        synchronized (set) {
            this.strategyEventListeners.remove(inListener);
        }
    }

    @Transactional(readOnly=true, propagation=Propagation.REQUIRED)
    public Optional<? extends StrategyInstance> findByName(String inName) {
        return this.strategyInstanceDao.findByName(inName);
    }

    private void deleteAllMessagesFor(PersistentStrategyInstance inStrategyInstance) {
        BooleanBuilder where = new BooleanBuilder();
        where = where.and((Predicate)QPersistentStrategyMessage.persistentStrategyMessage.strategyInstance.eq((Object)inStrategyInstance));
        this.strategyMessageDao.deleteAll(this.strategyMessageDao.findAll((Predicate)where));
    }

    private org.springframework.data.domain.Sort buildSort(org.marketcetera.persist.PageRequest inPageRequest, org.springframework.data.domain.Sort inDefaultSort) {
        if (inPageRequest.getSortOrder() == null || inPageRequest.getSortOrder().isEmpty()) {
            return inDefaultSort;
        }
        ArrayList specifiedSorts = Lists.newArrayList();
        for (Sort requestedSort : inPageRequest.getSortOrder()) {
            String property = requestedSort.getProperty();
            specifiedSorts.add(new Sort.Order(requestedSort.getDirection().getSpringSortDirection(), property));
        }
        return org.springframework.data.domain.Sort.by((List)specifiedSorts);
    }

    private class StrategyMessageQueueProcessor
    extends BatchQueueProcessor<StrategyMessage> {
        private final LoadingCache<String, PersistentStrategyInstance> strategyInstancesByName = CacheBuilder.newBuilder().expireAfterAccess(60L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, PersistentStrategyInstance>(){

            public PersistentStrategyInstance load(String inKey) throws Exception {
                Optional<PersistentStrategyInstance> strategyInstanceOption = StrategyServiceImpl.this.strategyInstanceDao.findByName(inKey);
                return strategyInstanceOption.orElse(null);
            }
        });
        private final Collection<PersistentStrategyMessage> persistentStrategyMessages = Lists.newArrayList();

        private StrategyMessageQueueProcessor() {
        }

        protected void add(StrategyMessage inData) {
            super.add((Object)inData);
        }

        protected void processData(Deque<StrategyMessage> inData) throws Exception {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setName("strategyEventTransaction");
            def.setPropagationBehavior(0);
            def.setReadOnly(false);
            TransactionStatus status = StrategyServiceImpl.this.txManager.getTransaction((TransactionDefinition)def);
            try {
                this.persistentStrategyMessages.clear();
                for (StrategyMessage strategyMessage : inData) {
                    if (!(strategyMessage instanceof PersistentStrategyMessage)) {
                        throw new UnsupportedOperationException("Need to create persistent instance");
                    }
                    PersistentStrategyMessage strategyMessage2 = (PersistentStrategyMessage)strategyMessage;
                    PersistentStrategyInstance strategyInstance = (PersistentStrategyInstance)((Object)this.strategyInstancesByName.getUnchecked((Object)strategyMessage2.getStrategyInstance().getName()));
                    if (strategyInstance == null) {
                        SLF4JLoggerProxy.warn((Object)StrategyServiceImpl.this, (String)"No strategy instance for name '{}', cannot save message '{}'", (Object[])new Object[]{strategyMessage2.getStrategyInstance().getName(), strategyMessage2});
                        continue;
                    }
                    strategyMessage2.setStrategyInstance(strategyInstance);
                    this.persistentStrategyMessages.add(strategyMessage2);
                }
                StrategyServiceImpl.this.strategyMessageDao.saveAll(this.persistentStrategyMessages);
                StrategyServiceImpl.this.txManager.commit(status);
                for (StrategyMessage strategyMessage : this.persistentStrategyMessages) {
                    StrategyServiceImpl.this.eventBusService.post((Object)new SimpleStrategyMessageEvent(strategyMessage));
                }
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)StrategyServiceImpl.this, (Throwable)e, (String)"Unable to persistent strategy messages: {}", (Object[])new Object[]{inData});
                StrategyServiceImpl.this.txManager.rollback(status);
            }
        }
    }

    private class RunningStrategy {
        private final File jarFile;
        private final StrategyInstance strategyInstance;
        private URLClassLoader newClassloader;
        private AnnotationConfigApplicationContext newContext;

        private void start() throws Throwable {
            URL url = this.jarFile.toURI().toURL();
            this.newClassloader = new URLClassLoader(new URL[]{url}, ClassLoader.getSystemClassLoader());
            String mainClass = this.getMainClassName(this.jarFile);
            SLF4JLoggerProxy.debug((Object)StrategyServiceImpl.this, (String)"Selected {} as the mainClass", (Object[])new Object[]{mainClass});
            Validate.notNull((Object)mainClass, (String)"No 'Main-Class' attribute in JAR", (Object[])new Object[0]);
            Class<?> provisioningClass = this.newClassloader.loadClass(mainClass);
            this.newContext = new AnnotationConfigApplicationContext();
            this.newContext.setClassLoader((ClassLoader)this.newClassloader);
            this.newContext.setParent(StrategyServiceImpl.this.applicationContext);
            this.newContext.register(new Class[]{provisioningClass});
            ConfigurableListableBeanFactory beanFactory = this.newContext.getBeanFactory();
            beanFactory.registerSingleton(StrategyInstanceHolder.class.getCanonicalName(), (Object)new StrategyInstanceHolder(){

                public StrategyInstance getStrategyInstance() {
                    return RunningStrategy.this.strategyInstance;
                }
            });
            String strategyUsername = this.strategyInstance.getUser().getName();
            DirectStrategyClient strategyClient = new DirectStrategyClient((ApplicationContext)this.newContext, strategyUsername);
            beanFactory.registerSingleton(StrategyClient.class.getCanonicalName(), (Object)strategyClient);
            DirectTradeClient tradeClient = (DirectTradeClient)StrategyServiceImpl.this.applicationContext.getBean(DirectTradeClient.class);
            tradeClient.setCurrentUser((HasCurrentUser)this.strategyInstance);
            this.newContext.refresh();
            this.newContext.start();
            strategyClient.start();
        }

        private void stop() {
            try {
                this.newContext.stop();
                this.newContext.close();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)StrategyServiceImpl.this, (Throwable)e);
            }
            try {
                this.newClassloader.close();
            }
            catch (Exception e) {
                SLF4JLoggerProxy.warn((Object)StrategyServiceImpl.this, (Throwable)e);
            }
        }

        private String getMainClassName(File inJarFile) throws FileNotFoundException, IOException {
            String mainClassName;
            try (JarInputStream jarStream = new JarInputStream(new FileInputStream(inJarFile));){
                Manifest manifest = jarStream.getManifest();
                Attributes mainAttributes = manifest.getMainAttributes();
                mainClassName = mainAttributes.getValue("Main-Class");
            }
            return mainClassName;
        }

        private RunningStrategy(StrategyInstance inStrategyInstance, File inStrategyJar) {
            this.strategyInstance = inStrategyInstance;
            this.jarFile = inStrategyJar;
        }
    }
}

