/*
 * Decompiled with CFR 0.152.
 */
package org.marketcetera.strategy.dao;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.apache.commons.lang.StringUtils;
import org.marketcetera.admin.HasUser;
import org.marketcetera.admin.User;
import org.marketcetera.admin.user.PersistentUser;
import org.marketcetera.persist.EntityBase;
import org.marketcetera.strategy.StrategyInstance;
import org.marketcetera.strategy.StrategyStatus;

@Entity(name="StrategyInstance")
@Table(name="metc_strategy_instances")
public class PersistentStrategyInstance
extends EntityBase
implements StrategyInstance,
HasUser {
    @ManyToOne
    @JoinColumn(name="user_id", nullable=true)
    private PersistentUser user;
    @Column(name="name", nullable=true, unique=false)
    private String name;
    @Column(name="filename", nullable=true, unique=false)
    private String filename;
    @Column(name="hash", nullable=true, unique=false)
    private String hash;
    @Column(name="nonce", nullable=true, unique=false)
    private String nonce;
    @Column(name="started", nullable=true, unique=false)
    private Date started;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status", nullable=true, unique=false)
    private StrategyStatus status;
    private static final long serialVersionUID = 1020230886L;

    public PersistentStrategyInstance() {
    }

    public PersistentStrategyInstance(StrategyInstance inStrategyInstance) {
        this.setUser(inStrategyInstance.getUser());
        this.setName(inStrategyInstance.getName());
        this.setFilename(inStrategyInstance.getFilename());
        this.setHash(inStrategyInstance.getHash());
        this.setNonce(inStrategyInstance.getNonce());
        this.setStarted(inStrategyInstance.getStarted());
        this.setStatus(inStrategyInstance.getStatus());
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User inUser) {
        this.user = (PersistentUser)inUser;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String inName) {
        this.name = StringUtils.trimToNull((String)inName);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String inFilename) {
        this.filename = StringUtils.trimToNull((String)inFilename);
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String inHash) {
        this.hash = StringUtils.trimToNull((String)inHash);
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String inNonce) {
        this.nonce = StringUtils.trimToNull((String)inNonce);
    }

    public Date getStarted() {
        return this.started;
    }

    public void setStarted(Date inStarted) {
        this.started = inStarted;
    }

    public StrategyStatus getStatus() {
        return this.status;
    }

    public void setStatus(StrategyStatus inStatus) {
        this.status = inStatus;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StrategyInstance [").append("user=").append(this.user).append(", name=").append(this.name).append(", filename=").append(this.filename).append(", hash=").append(this.hash).append(", nonce=").append(this.nonce).append(", started=").append(this.started).append(", status=").append(this.status).append("]");
        return builder.toString();
    }
}

